// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * At least one of your specified cluster subnets is in an Availability Zone that does not support Amazon EKS. The exception output specifies the supported Availability Zones for your account, from which you can choose subnets for your cluster.
 */
class UnsupportedAvailabilityZoneException private constructor(builder: Builder) : EksException() {

    /**
     * The Amazon EKS cluster associated with the exception.
     */
    val clusterName: kotlin.String? = builder.clusterName
    override val message: kotlin.String? = builder.message
    /**
     * The Amazon EKS managed node group associated with the exception.
     */
    val nodegroupName: kotlin.String? = builder.nodegroupName
    /**
     * The supported Availability Zones for your account. Choose subnets in these Availability Zones for your cluster.
     */
    val validZones: List<String>? = builder.validZones

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.UnsupportedAvailabilityZoneException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UnsupportedAvailabilityZoneException(")
        append("clusterName=$clusterName,")
        append("message=$message,")
        append("nodegroupName=$nodegroupName,")
        append("validZones=$validZones)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterName?.hashCode() ?: 0
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (nodegroupName?.hashCode() ?: 0)
        result = 31 * result + (validZones?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UnsupportedAvailabilityZoneException

        if (clusterName != other.clusterName) return false
        if (message != other.message) return false
        if (nodegroupName != other.nodegroupName) return false
        if (validZones != other.validZones) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.UnsupportedAvailabilityZoneException = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon EKS cluster associated with the exception.
         */
        var clusterName: kotlin.String? = null
        var message: kotlin.String? = null
        /**
         * The Amazon EKS managed node group associated with the exception.
         */
        var nodegroupName: kotlin.String? = null
        /**
         * The supported Availability Zones for your account. Choose subnets in these Availability Zones for your cluster.
         */
        var validZones: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.UnsupportedAvailabilityZoneException) : this() {
            this.clusterName = x.clusterName
            this.message = x.message
            this.nodegroupName = x.nodegroupName
            this.validZones = x.validZones
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.UnsupportedAvailabilityZoneException = UnsupportedAvailabilityZoneException(this)
    }
}
