// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model



class UpdateClusterConfigRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see [Amazon EKS cluster control plane logs](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html) in the **Amazon EKS User Guide**.
     *
     * CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see [CloudWatch Pricing](http://aws.amazon.com/cloudwatch/pricing/).
     */
    val logging: aws.sdk.kotlin.services.eks.model.Logging? = builder.logging
    /**
     * The name of the Amazon EKS cluster to update.
     */
    val name: kotlin.String? = builder.name
    /**
     * An object representing the VPC configuration to use for an Amazon EKS cluster.
     */
    val resourcesVpcConfig: aws.sdk.kotlin.services.eks.model.VpcConfigRequest? = builder.resourcesVpcConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.UpdateClusterConfigRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateClusterConfigRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("logging=$logging,")
        append("name=$name,")
        append("resourcesVpcConfig=$resourcesVpcConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (logging?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourcesVpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateClusterConfigRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (logging != other.logging) return false
        if (name != other.name) return false
        if (resourcesVpcConfig != other.resourcesVpcConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.UpdateClusterConfigRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         */
        var clientRequestToken: kotlin.String? = null
        /**
         * Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see [Amazon EKS cluster control plane logs](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html) in the **Amazon EKS User Guide**.
         *
         * CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see [CloudWatch Pricing](http://aws.amazon.com/cloudwatch/pricing/).
         */
        var logging: aws.sdk.kotlin.services.eks.model.Logging? = null
        /**
         * The name of the Amazon EKS cluster to update.
         */
        var name: kotlin.String? = null
        /**
         * An object representing the VPC configuration to use for an Amazon EKS cluster.
         */
        var resourcesVpcConfig: aws.sdk.kotlin.services.eks.model.VpcConfigRequest? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.UpdateClusterConfigRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.logging = x.logging
            this.name = x.name
            this.resourcesVpcConfig = x.resourcesVpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.UpdateClusterConfigRequest = UpdateClusterConfigRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.Logging] inside the given [block]
         */
        fun logging(block: aws.sdk.kotlin.services.eks.model.Logging.Builder.() -> kotlin.Unit) {
            this.logging = aws.sdk.kotlin.services.eks.model.Logging.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.VpcConfigRequest] inside the given [block]
         */
        fun resourcesVpcConfig(block: aws.sdk.kotlin.services.eks.model.VpcConfigRequest.Builder.() -> kotlin.Unit) {
            this.resourcesVpcConfig = aws.sdk.kotlin.services.eks.model.VpcConfigRequest.invoke(block)
        }
    }
}
