// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model



class UpdateNodegroupVersionRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The name of the Amazon EKS cluster that is associated with the managed node group to update.
     */
    val clusterName: kotlin.String? = builder.clusterName
    /**
     * Force the update if the existing node group's pods are unable to be drained due to a pod disruption budget issue. If an update fails because pods could not be drained, you can force the update after it fails to terminate the old node whether or not any pods are running on the node.
     */
    val force: kotlin.Boolean = builder.force
    /**
     * An object representing a node group's launch template specification. You can only update a node group using a launch template if the node group was originally deployed with a launch template.
     */
    val launchTemplate: aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification? = builder.launchTemplate
    /**
     * The name of the managed node group to update.
     */
    val nodegroupName: kotlin.String? = builder.nodegroupName
    /**
     * The AMI version of the Amazon EKS optimized AMI to use for the update. By default, the latest available AMI version for the node group's Kubernetes version is used. For more information, see [Amazon EKS optimized Amazon Linux 2 AMI versions ](https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html) in the *Amazon EKS User Guide*. If you specify `launchTemplate`, and your launch template uses a custom AMI, then don't specify `releaseVersion`, or the node group update will fail. For more information about using launch templates with Amazon EKS, see [Launch template support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
     */
    val releaseVersion: kotlin.String? = builder.releaseVersion
    /**
     * The Kubernetes version to update to. If no version is specified, then the Kubernetes version of the node group does not change. You can specify the Kubernetes version of the cluster to update the node group to the latest AMI version of the cluster's Kubernetes version. If you specify `launchTemplate`, and your launch template uses a custom AMI, then don't specify `version`, or the node group update will fail. For more information about using launch templates with Amazon EKS, see [Launch template support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
     */
    val version: kotlin.String? = builder.version

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.UpdateNodegroupVersionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateNodegroupVersionRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("clusterName=$clusterName,")
        append("force=$force,")
        append("launchTemplate=$launchTemplate,")
        append("nodegroupName=$nodegroupName,")
        append("releaseVersion=$releaseVersion,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (force.hashCode())
        result = 31 * result + (launchTemplate?.hashCode() ?: 0)
        result = 31 * result + (nodegroupName?.hashCode() ?: 0)
        result = 31 * result + (releaseVersion?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateNodegroupVersionRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (clusterName != other.clusterName) return false
        if (force != other.force) return false
        if (launchTemplate != other.launchTemplate) return false
        if (nodegroupName != other.nodegroupName) return false
        if (releaseVersion != other.releaseVersion) return false
        if (version != other.version) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.UpdateNodegroupVersionRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         */
        var clientRequestToken: kotlin.String? = null
        /**
         * The name of the Amazon EKS cluster that is associated with the managed node group to update.
         */
        var clusterName: kotlin.String? = null
        /**
         * Force the update if the existing node group's pods are unable to be drained due to a pod disruption budget issue. If an update fails because pods could not be drained, you can force the update after it fails to terminate the old node whether or not any pods are running on the node.
         */
        var force: kotlin.Boolean = false
        /**
         * An object representing a node group's launch template specification. You can only update a node group using a launch template if the node group was originally deployed with a launch template.
         */
        var launchTemplate: aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification? = null
        /**
         * The name of the managed node group to update.
         */
        var nodegroupName: kotlin.String? = null
        /**
         * The AMI version of the Amazon EKS optimized AMI to use for the update. By default, the latest available AMI version for the node group's Kubernetes version is used. For more information, see [Amazon EKS optimized Amazon Linux 2 AMI versions ](https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html) in the *Amazon EKS User Guide*. If you specify `launchTemplate`, and your launch template uses a custom AMI, then don't specify `releaseVersion`, or the node group update will fail. For more information about using launch templates with Amazon EKS, see [Launch template support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
         */
        var releaseVersion: kotlin.String? = null
        /**
         * The Kubernetes version to update to. If no version is specified, then the Kubernetes version of the node group does not change. You can specify the Kubernetes version of the cluster to update the node group to the latest AMI version of the cluster's Kubernetes version. If you specify `launchTemplate`, and your launch template uses a custom AMI, then don't specify `version`, or the node group update will fail. For more information about using launch templates with Amazon EKS, see [Launch template support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
         */
        var version: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.UpdateNodegroupVersionRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.clusterName = x.clusterName
            this.force = x.force
            this.launchTemplate = x.launchTemplate
            this.nodegroupName = x.nodegroupName
            this.releaseVersion = x.releaseVersion
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.UpdateNodegroupVersionRequest = UpdateNodegroupVersionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification] inside the given [block]
         */
        fun launchTemplate(block: aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification.Builder.() -> kotlin.Unit) {
            this.launchTemplate = aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification.invoke(block)
        }
    }
}
