// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model



/**
 * An object representing an Amazon EKS cluster VPC configuration response.
 */
class VpcConfigResponse private constructor(builder: Builder) {
    /**
     * The cluster security group that was created by Amazon EKS for the cluster. Managed node groups use this security group for control-plane-to-data-plane communication.
     */
    val clusterSecurityGroupId: kotlin.String? = builder.clusterSecurityGroupId
    /**
     * This parameter indicates whether the Amazon EKS private API server endpoint is enabled. If the Amazon EKS private API server endpoint is enabled, Kubernetes API requests that originate from within your cluster's VPC use the private VPC endpoint instead of traversing the internet. If this value is disabled and you have nodes or Fargate pods in the cluster, then ensure that `publicAccessCidrs` includes the necessary CIDR blocks for communication with the nodes or Fargate pods. For more information, see [Amazon EKS cluster endpoint access control](https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html) in the **Amazon EKS User Guide**.
     */
    val endpointPrivateAccess: kotlin.Boolean = builder.endpointPrivateAccess
    /**
     * This parameter indicates whether the Amazon EKS public API server endpoint is enabled. If the Amazon EKS public API server endpoint is disabled, your cluster's Kubernetes API server can only receive requests that originate from within the cluster VPC.
     */
    val endpointPublicAccess: kotlin.Boolean = builder.endpointPublicAccess
    /**
     * The CIDR blocks that are allowed access to your cluster's public Kubernetes API server endpoint. Communication to the endpoint from addresses outside of the listed CIDR blocks is denied. The default value is `0.0.0.0/0`. If you've disabled private endpoint access and you have nodes or Fargate pods in the cluster, then ensure that the necessary CIDR blocks are listed. For more information, see [Amazon EKS cluster endpoint access control](https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html) in the **Amazon EKS User Guide**.
     */
    val publicAccessCidrs: List<String>? = builder.publicAccessCidrs
    /**
     * The security groups associated with the cross-account elastic network interfaces that are used to allow communication between your nodes and the Kubernetes control plane.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The subnets associated with your cluster.
     */
    val subnetIds: List<String>? = builder.subnetIds
    /**
     * The VPC associated with your cluster.
     */
    val vpcId: kotlin.String? = builder.vpcId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.VpcConfigResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcConfigResponse(")
        append("clusterSecurityGroupId=$clusterSecurityGroupId,")
        append("endpointPrivateAccess=$endpointPrivateAccess,")
        append("endpointPublicAccess=$endpointPublicAccess,")
        append("publicAccessCidrs=$publicAccessCidrs,")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetIds=$subnetIds,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterSecurityGroupId?.hashCode() ?: 0
        result = 31 * result + (endpointPrivateAccess.hashCode())
        result = 31 * result + (endpointPublicAccess.hashCode())
        result = 31 * result + (publicAccessCidrs?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcConfigResponse

        if (clusterSecurityGroupId != other.clusterSecurityGroupId) return false
        if (endpointPrivateAccess != other.endpointPrivateAccess) return false
        if (endpointPublicAccess != other.endpointPublicAccess) return false
        if (publicAccessCidrs != other.publicAccessCidrs) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetIds != other.subnetIds) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.VpcConfigResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The cluster security group that was created by Amazon EKS for the cluster. Managed node groups use this security group for control-plane-to-data-plane communication.
         */
        var clusterSecurityGroupId: kotlin.String? = null
        /**
         * This parameter indicates whether the Amazon EKS private API server endpoint is enabled. If the Amazon EKS private API server endpoint is enabled, Kubernetes API requests that originate from within your cluster's VPC use the private VPC endpoint instead of traversing the internet. If this value is disabled and you have nodes or Fargate pods in the cluster, then ensure that `publicAccessCidrs` includes the necessary CIDR blocks for communication with the nodes or Fargate pods. For more information, see [Amazon EKS cluster endpoint access control](https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html) in the **Amazon EKS User Guide**.
         */
        var endpointPrivateAccess: kotlin.Boolean = false
        /**
         * This parameter indicates whether the Amazon EKS public API server endpoint is enabled. If the Amazon EKS public API server endpoint is disabled, your cluster's Kubernetes API server can only receive requests that originate from within the cluster VPC.
         */
        var endpointPublicAccess: kotlin.Boolean = false
        /**
         * The CIDR blocks that are allowed access to your cluster's public Kubernetes API server endpoint. Communication to the endpoint from addresses outside of the listed CIDR blocks is denied. The default value is `0.0.0.0/0`. If you've disabled private endpoint access and you have nodes or Fargate pods in the cluster, then ensure that the necessary CIDR blocks are listed. For more information, see [Amazon EKS cluster endpoint access control](https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html) in the **Amazon EKS User Guide**.
         */
        var publicAccessCidrs: List<String>? = null
        /**
         * The security groups associated with the cross-account elastic network interfaces that are used to allow communication between your nodes and the Kubernetes control plane.
         */
        var securityGroupIds: List<String>? = null
        /**
         * The subnets associated with your cluster.
         */
        var subnetIds: List<String>? = null
        /**
         * The VPC associated with your cluster.
         */
        var vpcId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.VpcConfigResponse) : this() {
            this.clusterSecurityGroupId = x.clusterSecurityGroupId
            this.endpointPrivateAccess = x.endpointPrivateAccess
            this.endpointPublicAccess = x.endpointPublicAccess
            this.publicAccessCidrs = x.publicAccessCidrs
            this.securityGroupIds = x.securityGroupIds
            this.subnetIds = x.subnetIds
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.VpcConfigResponse = VpcConfigResponse(this)
    }
}
