// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.paginators

import aws.sdk.kotlin.services.eks.EksClient
import aws.sdk.kotlin.services.eks.model.AddonInfo
import aws.sdk.kotlin.services.eks.model.DescribeAddonVersionsRequest
import aws.sdk.kotlin.services.eks.model.DescribeAddonVersionsResponse
import aws.sdk.kotlin.services.eks.model.IdentityProviderConfig
import aws.sdk.kotlin.services.eks.model.ListAddonsRequest
import aws.sdk.kotlin.services.eks.model.ListAddonsResponse
import aws.sdk.kotlin.services.eks.model.ListClustersRequest
import aws.sdk.kotlin.services.eks.model.ListClustersResponse
import aws.sdk.kotlin.services.eks.model.ListFargateProfilesRequest
import aws.sdk.kotlin.services.eks.model.ListFargateProfilesResponse
import aws.sdk.kotlin.services.eks.model.ListIdentityProviderConfigsRequest
import aws.sdk.kotlin.services.eks.model.ListIdentityProviderConfigsResponse
import aws.sdk.kotlin.services.eks.model.ListNodegroupsRequest
import aws.sdk.kotlin.services.eks.model.ListNodegroupsResponse
import aws.sdk.kotlin.services.eks.model.ListUpdatesRequest
import aws.sdk.kotlin.services.eks.model.ListUpdatesResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeAddonVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeAddonVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAddonVersionsResponse]
 */
fun EksClient.describeAddonVersionsPaginated(initialRequest: DescribeAddonVersionsRequest): Flow<DescribeAddonVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeAddonVersionsPaginated.describeAddonVersions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeAddonVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAddonVersionsResponse]
 */
fun EksClient.describeAddonVersionsPaginated(block: DescribeAddonVersionsRequest.Builder.() -> Unit): Flow<DescribeAddonVersionsResponse> =
    describeAddonVersionsPaginated(DescribeAddonVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeAddonVersionsPaginated]
 * to access the nested member [AddonInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AddonInfo]
 */
@JvmName("describeAddonVersionsResponseAddonInfo")
fun Flow<DescribeAddonVersionsResponse>.addons(): Flow<AddonInfo> =
    transform() { response ->
        response.addons?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAddonsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAddonsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAddonsResponse]
 */
fun EksClient.listAddonsPaginated(initialRequest: ListAddonsRequest): Flow<ListAddonsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAddonsPaginated.listAddons(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAddonsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAddonsResponse]
 */
fun EksClient.listAddonsPaginated(block: ListAddonsRequest.Builder.() -> Unit): Flow<ListAddonsResponse> =
    listAddonsPaginated(ListAddonsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAddonsPaginated]
 * to access the nested member [String]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [String]
 */
@JvmName("listAddonsResponseString")
fun Flow<ListAddonsResponse>.addons(): Flow<String> =
    transform() { response ->
        response.addons?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListClustersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClustersResponse]
 */
fun EksClient.listClustersPaginated(initialRequest: ListClustersRequest): Flow<ListClustersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listClustersPaginated.listClusters(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClustersResponse]
 */
fun EksClient.listClustersPaginated(block: ListClustersRequest.Builder.() -> Unit): Flow<ListClustersResponse> =
    listClustersPaginated(ListClustersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listClustersPaginated]
 * to access the nested member [String]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [String]
 */
@JvmName("listClustersResponseString")
fun Flow<ListClustersResponse>.clusters(): Flow<String> =
    transform() { response ->
        response.clusters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFargateProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFargateProfilesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFargateProfilesResponse]
 */
fun EksClient.listFargateProfilesPaginated(initialRequest: ListFargateProfilesRequest): Flow<ListFargateProfilesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFargateProfilesPaginated.listFargateProfiles(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFargateProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFargateProfilesResponse]
 */
fun EksClient.listFargateProfilesPaginated(block: ListFargateProfilesRequest.Builder.() -> Unit): Flow<ListFargateProfilesResponse> =
    listFargateProfilesPaginated(ListFargateProfilesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFargateProfilesPaginated]
 * to access the nested member [String]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [String]
 */
@JvmName("listFargateProfilesResponseString")
fun Flow<ListFargateProfilesResponse>.fargateProfileNames(): Flow<String> =
    transform() { response ->
        response.fargateProfileNames?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListIdentityProviderConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListIdentityProviderConfigsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIdentityProviderConfigsResponse]
 */
fun EksClient.listIdentityProviderConfigsPaginated(initialRequest: ListIdentityProviderConfigsRequest): Flow<ListIdentityProviderConfigsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listIdentityProviderConfigsPaginated.listIdentityProviderConfigs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListIdentityProviderConfigsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIdentityProviderConfigsResponse]
 */
fun EksClient.listIdentityProviderConfigsPaginated(block: ListIdentityProviderConfigsRequest.Builder.() -> Unit): Flow<ListIdentityProviderConfigsResponse> =
    listIdentityProviderConfigsPaginated(ListIdentityProviderConfigsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listIdentityProviderConfigsPaginated]
 * to access the nested member [IdentityProviderConfig]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [IdentityProviderConfig]
 */
@JvmName("listIdentityProviderConfigsResponseIdentityProviderConfig")
fun Flow<ListIdentityProviderConfigsResponse>.identityProviderConfigs(): Flow<IdentityProviderConfig> =
    transform() { response ->
        response.identityProviderConfigs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListNodegroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListNodegroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNodegroupsResponse]
 */
fun EksClient.listNodegroupsPaginated(initialRequest: ListNodegroupsRequest): Flow<ListNodegroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listNodegroupsPaginated.listNodegroups(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListNodegroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNodegroupsResponse]
 */
fun EksClient.listNodegroupsPaginated(block: ListNodegroupsRequest.Builder.() -> Unit): Flow<ListNodegroupsResponse> =
    listNodegroupsPaginated(ListNodegroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listNodegroupsPaginated]
 * to access the nested member [String]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [String]
 */
@JvmName("listNodegroupsResponseString")
fun Flow<ListNodegroupsResponse>.nodegroups(): Flow<String> =
    transform() { response ->
        response.nodegroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListUpdatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListUpdatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUpdatesResponse]
 */
fun EksClient.listUpdatesPaginated(initialRequest: ListUpdatesRequest): Flow<ListUpdatesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listUpdatesPaginated.listUpdates(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListUpdatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUpdatesResponse]
 */
fun EksClient.listUpdatesPaginated(block: ListUpdatesRequest.Builder.() -> Unit): Flow<ListUpdatesResponse> =
    listUpdatesPaginated(ListUpdatesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listUpdatesPaginated]
 * to access the nested member [String]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [String]
 */
@JvmName("listUpdatesResponseString")
fun Flow<ListUpdatesResponse>.updateIds(): Flow<String> =
    transform() { response ->
        response.updateIds?.forEach {
            emit(it)
        }
    }
