// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.transform

import aws.sdk.kotlin.services.eks.model.CreateClusterRequest
import aws.sdk.kotlin.services.eks.model.EncryptionConfig
import aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigRequest
import aws.sdk.kotlin.services.eks.model.Logging
import aws.sdk.kotlin.services.eks.model.VpcConfigRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateClusterOperationSerializer: HttpSerialize<CreateClusterRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateClusterRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/clusters"
        }

        val payload = serializeCreateClusterOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateClusterOperationBody(context: ExecutionContext, input: CreateClusterRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientRequestToken"))
    val ENCRYPTIONCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("encryptionConfig"))
    val KUBERNETESNETWORKCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("kubernetesNetworkConfig"))
    val LOGGING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("logging"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val RESOURCESVPCCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("resourcesVpcConfig"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("version"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(ENCRYPTIONCONFIG_DESCRIPTOR)
        field(KUBERNETESNETWORKCONFIG_DESCRIPTOR)
        field(LOGGING_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(RESOURCESVPCCONFIG_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTREQUESTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        if (input.encryptionConfig != null) {
            listField(ENCRYPTIONCONFIG_DESCRIPTOR) {
                for (el0 in input.encryptionConfig) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeEncryptionConfigDocument))
                }
            }
        }
        input.kubernetesNetworkConfig?.let { field(KUBERNETESNETWORKCONFIG_DESCRIPTOR, it, ::serializeKubernetesNetworkConfigRequestDocument) }
        input.logging?.let { field(LOGGING_DESCRIPTOR, it, ::serializeLoggingDocument) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.resourcesVpcConfig?.let { field(RESOURCESVPCCONFIG_DESCRIPTOR, it, ::serializeVpcConfigRequestDocument) }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.version?.let { field(VERSION_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
