// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.eks.model.DescribeIdentityProviderConfigResponse
import aws.sdk.kotlin.services.eks.model.EksException
import aws.sdk.kotlin.services.eks.model.IdentityProviderConfigResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeIdentityProviderConfigOperationDeserializer: HttpDeserialize<DescribeIdentityProviderConfigResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeIdentityProviderConfigResponse {
        if (!response.status.isSuccess()) {
            throwDescribeIdentityProviderConfigError(context, response)
        }
        val builder = DescribeIdentityProviderConfigResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeIdentityProviderConfigOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeIdentityProviderConfigError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw EksException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ClientException" -> ClientExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServerException" -> ServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> EksException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeIdentityProviderConfigOperationBody(builder: DescribeIdentityProviderConfigResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val IDENTITYPROVIDERCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("identityProviderConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(IDENTITYPROVIDERCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                IDENTITYPROVIDERCONFIG_DESCRIPTOR.index -> builder.identityProviderConfig = deserializeIdentityProviderConfigResponseDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
