// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.transform

import aws.sdk.kotlin.services.eks.model.ResolveConflicts
import aws.sdk.kotlin.services.eks.model.UpdateAddonRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateAddonOperationSerializer: HttpSerialize<UpdateAddonRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateAddonRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "clusters",
                "${input.clusterName}".encodeLabel(),
                "addons",
                "${input.addonName}".encodeLabel(),
                "update",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateAddonOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateAddonOperationBody(context: ExecutionContext, input: UpdateAddonRequest): ByteArray {
    val serializer = JsonSerializer()
    val ADDONVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("addonVersion"))
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientRequestToken"))
    val RESOLVECONFLICTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("resolveConflicts"))
    val SERVICEACCOUNTROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("serviceAccountRoleArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDONVERSION_DESCRIPTOR)
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(RESOLVECONFLICTS_DESCRIPTOR)
        field(SERVICEACCOUNTROLEARN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.addonVersion?.let { field(ADDONVERSION_DESCRIPTOR, it) }
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTREQUESTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.resolveConflicts?.let { field(RESOLVECONFLICTS_DESCRIPTOR, it.value) }
        input.serviceAccountRoleArn?.let { field(SERVICEACCOUNTROLEARN_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
