// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.waiters

import aws.sdk.kotlin.services.eks.EksClient
import aws.sdk.kotlin.services.eks.model.DescribeAddonRequest
import aws.sdk.kotlin.services.eks.model.DescribeAddonResponse
import aws.sdk.kotlin.services.eks.model.DescribeClusterRequest
import aws.sdk.kotlin.services.eks.model.DescribeClusterResponse
import aws.sdk.kotlin.services.eks.model.DescribeFargateProfileRequest
import aws.sdk.kotlin.services.eks.model.DescribeFargateProfileResponse
import aws.sdk.kotlin.services.eks.model.DescribeNodegroupRequest
import aws.sdk.kotlin.services.eks.model.DescribeNodegroupResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import kotlin.time.Duration.Companion.milliseconds


suspend fun EksClient.waitUntilAddonActive(request: DescribeAddonRequest): Outcome<DescribeAddonResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 10_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeAddonRequest, DescribeAddonResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val addon = it?.addon
            val status = addon?.status
            status?.toString() == "CREATE_FAILED"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val addon = it?.addon
            val status = addon?.status
            status?.toString() == "DEGRADED"
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val addon = it?.addon
            val status = addon?.status
            status?.toString() == "ACTIVE"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeAddon(request) }
}

suspend fun EksClient.waitUntilAddonActive(block: DescribeAddonRequest.Builder.() -> Unit): Outcome<DescribeAddonResponse> =
    waitUntilAddonActive(DescribeAddonRequest.Builder().apply(block).build())

suspend fun EksClient.waitUntilAddonDeleted(request: DescribeAddonRequest): Outcome<DescribeAddonResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 10_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeAddonRequest, DescribeAddonResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val addon = it?.addon
            val status = addon?.status
            status?.toString() == "DELETE_FAILED"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ResourceNotFoundException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeAddon(request) }
}

suspend fun EksClient.waitUntilAddonDeleted(block: DescribeAddonRequest.Builder.() -> Unit): Outcome<DescribeAddonResponse> =
    waitUntilAddonDeleted(DescribeAddonRequest.Builder().apply(block).build())

suspend fun EksClient.waitUntilClusterActive(request: DescribeClusterRequest): Outcome<DescribeClusterResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeClusterRequest, DescribeClusterResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cluster = it?.cluster
            val status = cluster?.status
            status?.toString() == "DELETING"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cluster = it?.cluster
            val status = cluster?.status
            status?.toString() == "FAILED"
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val cluster = it?.cluster
            val status = cluster?.status
            status?.toString() == "ACTIVE"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeCluster(request) }
}

suspend fun EksClient.waitUntilClusterActive(block: DescribeClusterRequest.Builder.() -> Unit): Outcome<DescribeClusterResponse> =
    waitUntilClusterActive(DescribeClusterRequest.Builder().apply(block).build())

suspend fun EksClient.waitUntilClusterDeleted(request: DescribeClusterRequest): Outcome<DescribeClusterResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeClusterRequest, DescribeClusterResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cluster = it?.cluster
            val status = cluster?.status
            status?.toString() == "ACTIVE"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cluster = it?.cluster
            val status = cluster?.status
            status?.toString() == "CREATING"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cluster = it?.cluster
            val status = cluster?.status
            status?.toString() == "PENDING"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ResourceNotFoundException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeCluster(request) }
}

suspend fun EksClient.waitUntilClusterDeleted(block: DescribeClusterRequest.Builder.() -> Unit): Outcome<DescribeClusterResponse> =
    waitUntilClusterDeleted(DescribeClusterRequest.Builder().apply(block).build())

suspend fun EksClient.waitUntilFargateProfileActive(request: DescribeFargateProfileRequest): Outcome<DescribeFargateProfileResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 10_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeFargateProfileRequest, DescribeFargateProfileResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val fargateProfile = it?.fargateProfile
            val status = fargateProfile?.status
            status?.toString() == "CREATE_FAILED"
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val fargateProfile = it?.fargateProfile
            val status = fargateProfile?.status
            status?.toString() == "ACTIVE"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeFargateProfile(request) }
}

suspend fun EksClient.waitUntilFargateProfileActive(block: DescribeFargateProfileRequest.Builder.() -> Unit): Outcome<DescribeFargateProfileResponse> =
    waitUntilFargateProfileActive(DescribeFargateProfileRequest.Builder().apply(block).build())

suspend fun EksClient.waitUntilFargateProfileDeleted(request: DescribeFargateProfileRequest): Outcome<DescribeFargateProfileResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeFargateProfileRequest, DescribeFargateProfileResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val fargateProfile = it?.fargateProfile
            val status = fargateProfile?.status
            status?.toString() == "DELETE_FAILED"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ResourceNotFoundException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeFargateProfile(request) }
}

suspend fun EksClient.waitUntilFargateProfileDeleted(block: DescribeFargateProfileRequest.Builder.() -> Unit): Outcome<DescribeFargateProfileResponse> =
    waitUntilFargateProfileDeleted(DescribeFargateProfileRequest.Builder().apply(block).build())

suspend fun EksClient.waitUntilNodegroupActive(request: DescribeNodegroupRequest): Outcome<DescribeNodegroupResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeNodegroupRequest, DescribeNodegroupResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val nodegroup = it?.nodegroup
            val status = nodegroup?.status
            status?.toString() == "CREATE_FAILED"
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val nodegroup = it?.nodegroup
            val status = nodegroup?.status
            status?.toString() == "ACTIVE"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeNodegroup(request) }
}

suspend fun EksClient.waitUntilNodegroupActive(block: DescribeNodegroupRequest.Builder.() -> Unit): Outcome<DescribeNodegroupResponse> =
    waitUntilNodegroupActive(DescribeNodegroupRequest.Builder().apply(block).build())

suspend fun EksClient.waitUntilNodegroupDeleted(request: DescribeNodegroupRequest): Outcome<DescribeNodegroupResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeNodegroupRequest, DescribeNodegroupResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val nodegroup = it?.nodegroup
            val status = nodegroup?.status
            status?.toString() == "DELETE_FAILED"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ResourceNotFoundException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeNodegroup(request) }
}

suspend fun EksClient.waitUntilNodegroupDeleted(block: DescribeNodegroupRequest.Builder.() -> Unit): Outcome<DescribeNodegroupResponse> =
    waitUntilNodegroupDeleted(DescribeNodegroupRequest.Builder().apply(block).build())
