// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.eks.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.eks.model.*
import aws.sdk.kotlin.services.eks.model.AssociateEncryptionConfigRequest
import aws.sdk.kotlin.services.eks.model.AssociateEncryptionConfigResponse
import aws.sdk.kotlin.services.eks.model.AssociateIdentityProviderConfigRequest
import aws.sdk.kotlin.services.eks.model.AssociateIdentityProviderConfigResponse
import aws.sdk.kotlin.services.eks.model.CreateAddonRequest
import aws.sdk.kotlin.services.eks.model.CreateAddonResponse
import aws.sdk.kotlin.services.eks.model.CreateClusterRequest
import aws.sdk.kotlin.services.eks.model.CreateClusterResponse
import aws.sdk.kotlin.services.eks.model.CreateFargateProfileRequest
import aws.sdk.kotlin.services.eks.model.CreateFargateProfileResponse
import aws.sdk.kotlin.services.eks.model.CreateNodegroupRequest
import aws.sdk.kotlin.services.eks.model.CreateNodegroupResponse
import aws.sdk.kotlin.services.eks.model.DeleteAddonRequest
import aws.sdk.kotlin.services.eks.model.DeleteAddonResponse
import aws.sdk.kotlin.services.eks.model.DeleteClusterRequest
import aws.sdk.kotlin.services.eks.model.DeleteClusterResponse
import aws.sdk.kotlin.services.eks.model.DeleteFargateProfileRequest
import aws.sdk.kotlin.services.eks.model.DeleteFargateProfileResponse
import aws.sdk.kotlin.services.eks.model.DeleteNodegroupRequest
import aws.sdk.kotlin.services.eks.model.DeleteNodegroupResponse
import aws.sdk.kotlin.services.eks.model.DeregisterClusterRequest
import aws.sdk.kotlin.services.eks.model.DeregisterClusterResponse
import aws.sdk.kotlin.services.eks.model.DescribeAddonRequest
import aws.sdk.kotlin.services.eks.model.DescribeAddonResponse
import aws.sdk.kotlin.services.eks.model.DescribeAddonVersionsRequest
import aws.sdk.kotlin.services.eks.model.DescribeAddonVersionsResponse
import aws.sdk.kotlin.services.eks.model.DescribeClusterRequest
import aws.sdk.kotlin.services.eks.model.DescribeClusterResponse
import aws.sdk.kotlin.services.eks.model.DescribeFargateProfileRequest
import aws.sdk.kotlin.services.eks.model.DescribeFargateProfileResponse
import aws.sdk.kotlin.services.eks.model.DescribeIdentityProviderConfigRequest
import aws.sdk.kotlin.services.eks.model.DescribeIdentityProviderConfigResponse
import aws.sdk.kotlin.services.eks.model.DescribeNodegroupRequest
import aws.sdk.kotlin.services.eks.model.DescribeNodegroupResponse
import aws.sdk.kotlin.services.eks.model.DescribeUpdateRequest
import aws.sdk.kotlin.services.eks.model.DescribeUpdateResponse
import aws.sdk.kotlin.services.eks.model.DisassociateIdentityProviderConfigRequest
import aws.sdk.kotlin.services.eks.model.DisassociateIdentityProviderConfigResponse
import aws.sdk.kotlin.services.eks.model.ListAddonsRequest
import aws.sdk.kotlin.services.eks.model.ListAddonsResponse
import aws.sdk.kotlin.services.eks.model.ListClustersRequest
import aws.sdk.kotlin.services.eks.model.ListClustersResponse
import aws.sdk.kotlin.services.eks.model.ListFargateProfilesRequest
import aws.sdk.kotlin.services.eks.model.ListFargateProfilesResponse
import aws.sdk.kotlin.services.eks.model.ListIdentityProviderConfigsRequest
import aws.sdk.kotlin.services.eks.model.ListIdentityProviderConfigsResponse
import aws.sdk.kotlin.services.eks.model.ListNodegroupsRequest
import aws.sdk.kotlin.services.eks.model.ListNodegroupsResponse
import aws.sdk.kotlin.services.eks.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.eks.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.eks.model.ListUpdatesRequest
import aws.sdk.kotlin.services.eks.model.ListUpdatesResponse
import aws.sdk.kotlin.services.eks.model.RegisterClusterRequest
import aws.sdk.kotlin.services.eks.model.RegisterClusterResponse
import aws.sdk.kotlin.services.eks.model.TagResourceRequest
import aws.sdk.kotlin.services.eks.model.TagResourceResponse
import aws.sdk.kotlin.services.eks.model.UntagResourceRequest
import aws.sdk.kotlin.services.eks.model.UntagResourceResponse
import aws.sdk.kotlin.services.eks.model.UpdateAddonRequest
import aws.sdk.kotlin.services.eks.model.UpdateAddonResponse
import aws.sdk.kotlin.services.eks.model.UpdateClusterConfigRequest
import aws.sdk.kotlin.services.eks.model.UpdateClusterConfigResponse
import aws.sdk.kotlin.services.eks.model.UpdateClusterVersionRequest
import aws.sdk.kotlin.services.eks.model.UpdateClusterVersionResponse
import aws.sdk.kotlin.services.eks.model.UpdateNodegroupConfigRequest
import aws.sdk.kotlin.services.eks.model.UpdateNodegroupConfigResponse
import aws.sdk.kotlin.services.eks.model.UpdateNodegroupVersionRequest
import aws.sdk.kotlin.services.eks.model.UpdateNodegroupVersionResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon Elastic Kubernetes Service (Amazon EKS) is a managed service that makes it easy for you to run Kubernetes on Amazon Web Services without needing to stand up or maintain your own Kubernetes control plane. Kubernetes is an open-source system for automating the deployment, scaling, and management of containerized applications.
 *
 * Amazon EKS runs up-to-date versions of the open-source Kubernetes software, so you can use all the existing plugins and tooling from the Kubernetes community. Applications running on Amazon EKS are fully compatible with applications running on any standard Kubernetes environment, whether running in on-premises data centers or public clouds. This means that you can easily migrate any standard Kubernetes application to Amazon EKS without any code modification required.
 */
public interface EksClient : SdkClient {

    override val serviceName: String
        get() = "EKS"
    /**
     * EksClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): EksClient {
            val config = Config.Builder().apply(block).build()
            return DefaultEksClient(config)
        }

        public operator fun invoke(config: Config): EksClient = DefaultEksClient(config)

        /**
         * Construct a [EksClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): EksClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultEksClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associate encryption configuration to an existing cluster.
     *
     * You can use this API to enable encryption on existing clusters which do not have encryption already enabled. This allows you to implement a defense-in-depth security strategy without migrating applications to new Amazon EKS clusters.
     */
    public suspend fun associateEncryptionConfig(input: AssociateEncryptionConfigRequest): AssociateEncryptionConfigResponse

    /**
     * Associate an identity provider configuration to a cluster.
     *
     * If you want to authenticate identities using an identity provider, you can create an identity provider configuration and associate it to your cluster. After configuring authentication to your cluster you can create Kubernetes `roles` and `clusterroles` to assign permissions to the roles, and then bind the roles to the identities using Kubernetes `rolebindings` and `clusterrolebindings`. For more information see [Using RBAC Authorization](https://kubernetes.io/docs/reference/access-authn-authz/rbac/) in the Kubernetes documentation.
     */
    public suspend fun associateIdentityProviderConfig(input: AssociateIdentityProviderConfigRequest): AssociateIdentityProviderConfigResponse

    /**
     * Creates an Amazon EKS add-on.
     *
     * Amazon EKS add-ons help to automate the provisioning and lifecycle management of common operational software for Amazon EKS clusters. Amazon EKS add-ons require clusters running version 1.18 or later because Amazon EKS add-ons rely on the Server-side Apply Kubernetes feature, which is only available in Kubernetes 1.18 and later. For more information, see [Amazon EKS add-ons](https://docs.aws.amazon.com/eks/latest/userguide/eks-add-ons.html) in the *Amazon EKS User Guide*.
     */
    public suspend fun createAddon(input: CreateAddonRequest): CreateAddonResponse

    /**
     * Creates an Amazon EKS control plane.
     *
     * The Amazon EKS control plane consists of control plane instances that run the Kubernetes software, such as `etcd` and the API server. The control plane runs in an account managed by Amazon Web Services, and the Kubernetes API is exposed by the Amazon EKS API server endpoint. Each Amazon EKS cluster control plane is single tenant and unique. It runs on its own set of Amazon EC2 instances.
     *
     * The cluster control plane is provisioned across multiple Availability Zones and fronted by an Elastic Load Balancing Network Load Balancer. Amazon EKS also provisions elastic network interfaces in your VPC subnets to provide connectivity from the control plane instances to the nodes (for example, to support `kubectl exec`, `logs`, and `proxy` data flows).
     *
     * Amazon EKS nodes run in your Amazon Web Services account and connect to your cluster's control plane over the Kubernetes API server endpoint and a certificate file that is created for your cluster.
     *
     * In most cases, it takes several minutes to create a cluster. After you create an Amazon EKS cluster, you must configure your Kubernetes tooling to communicate with the API server and launch nodes into your cluster. For more information, see [Managing Cluster Authentication](https://docs.aws.amazon.com/eks/latest/userguide/managing-auth.html) and [Launching Amazon EKS nodes](https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html) in the *Amazon EKS User Guide*.
     */
    public suspend fun createCluster(input: CreateClusterRequest): CreateClusterResponse

    /**
     * Creates an Fargate profile for your Amazon EKS cluster. You must have at least one Fargate profile in a cluster to be able to run pods on Fargate.
     *
     * The Fargate profile allows an administrator to declare which pods run on Fargate and specify which pods run on which Fargate profile. This declaration is done through the profile’s selectors. Each profile can have up to five selectors that contain a namespace and labels. A namespace is required for every selector. The label field consists of multiple optional key-value pairs. Pods that match the selectors are scheduled on Fargate. If a to-be-scheduled pod matches any of the selectors in the Fargate profile, then that pod is run on Fargate.
     *
     * When you create a Fargate profile, you must specify a pod execution role to use with the pods that are scheduled with the profile. This role is added to the cluster's Kubernetes [Role Based Access Control](https://kubernetes.io/docs/admin/authorization/rbac/) (RBAC) for authorization so that the `kubelet` that is running on the Fargate infrastructure can register with your Amazon EKS cluster so that it can appear in your cluster as a node. The pod execution role also provides IAM permissions to the Fargate infrastructure to allow read access to Amazon ECR image repositories. For more information, see [Pod Execution Role](https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html) in the *Amazon EKS User Guide*.
     *
     * Fargate profiles are immutable. However, you can create a new updated profile to replace an existing profile and then delete the original after the updated profile has finished creating.
     *
     * If any Fargate profiles in a cluster are in the `DELETING` status, you must wait for that Fargate profile to finish deleting before you can create any other profiles in that cluster.
     *
     * For more information, see [Fargate Profile](https://docs.aws.amazon.com/eks/latest/userguide/fargate-profile.html) in the *Amazon EKS User Guide*.
     */
    public suspend fun createFargateProfile(input: CreateFargateProfileRequest): CreateFargateProfileResponse

    /**
     * Creates a managed node group for an Amazon EKS cluster. You can only create a node group for your cluster that is equal to the current Kubernetes version for the cluster. All node groups are created with the latest AMI release version for the respective minor Kubernetes version of the cluster, unless you deploy a custom AMI using a launch template. For more information about using launch templates, see [Launch template support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html).
     *
     * An Amazon EKS managed node group is an Amazon EC2 Auto Scaling group and associated Amazon EC2 instances that are managed by Amazon Web Services for an Amazon EKS cluster. Each node group uses a version of the Amazon EKS optimized Amazon Linux 2 AMI. For more information, see [Managed Node Groups](https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html) in the *Amazon EKS User Guide*.
     */
    public suspend fun createNodegroup(input: CreateNodegroupRequest): CreateNodegroupResponse

    /**
     * Delete an Amazon EKS add-on.
     *
     * When you remove the add-on, it will also be deleted from the cluster. You can always manually start an add-on on the cluster using the Kubernetes API.
     */
    public suspend fun deleteAddon(input: DeleteAddonRequest): DeleteAddonResponse

    /**
     * Deletes the Amazon EKS cluster control plane.
     *
     * If you have active services in your cluster that are associated with a load balancer, you must delete those services before deleting the cluster so that the load balancers are deleted properly. Otherwise, you can have orphaned resources in your VPC that prevent you from being able to delete the VPC. For more information, see [Deleting a Cluster](https://docs.aws.amazon.com/eks/latest/userguide/delete-cluster.html) in the *Amazon EKS User Guide*.
     *
     * If you have managed node groups or Fargate profiles attached to the cluster, you must delete them first. For more information, see DeleteNodegroup and DeleteFargateProfile.
     */
    public suspend fun deleteCluster(input: DeleteClusterRequest): DeleteClusterResponse

    /**
     * Deletes an Fargate profile.
     *
     * When you delete a Fargate profile, any pods running on Fargate that were created with the profile are deleted. If those pods match another Fargate profile, then they are scheduled on Fargate with that profile. If they no longer match any Fargate profiles, then they are not scheduled on Fargate and they may remain in a pending state.
     *
     * Only one Fargate profile in a cluster can be in the `DELETING` status at a time. You must wait for a Fargate profile to finish deleting before you can delete any other profiles in that cluster.
     */
    public suspend fun deleteFargateProfile(input: DeleteFargateProfileRequest): DeleteFargateProfileResponse

    /**
     * Deletes an Amazon EKS node group for a cluster.
     */
    public suspend fun deleteNodegroup(input: DeleteNodegroupRequest): DeleteNodegroupResponse

    /**
     * Deregisters a connected cluster to remove it from the Amazon EKS control plane.
     */
    public suspend fun deregisterCluster(input: DeregisterClusterRequest): DeregisterClusterResponse

    /**
     * Describes an Amazon EKS add-on.
     */
    public suspend fun describeAddon(input: DescribeAddonRequest): DescribeAddonResponse

    /**
     * Describes the Kubernetes versions that the add-on can be used with.
     */
    public suspend fun describeAddonVersions(input: DescribeAddonVersionsRequest = DescribeAddonVersionsRequest {}): DescribeAddonVersionsResponse

    /**
     * Returns descriptive information about an Amazon EKS cluster.
     *
     * The API server endpoint and certificate authority data returned by this operation are required for `kubelet` and `kubectl` to communicate with your Kubernetes API server. For more information, see [Create a kubeconfig for Amazon EKS](https://docs.aws.amazon.com/eks/latest/userguide/create-kubeconfig.html).
     *
     * The API server endpoint and certificate authority data aren't available until the cluster reaches the `ACTIVE` state.
     */
    public suspend fun describeCluster(input: DescribeClusterRequest): DescribeClusterResponse

    /**
     * Returns descriptive information about an Fargate profile.
     */
    public suspend fun describeFargateProfile(input: DescribeFargateProfileRequest): DescribeFargateProfileResponse

    /**
     * Returns descriptive information about an identity provider configuration.
     */
    public suspend fun describeIdentityProviderConfig(input: DescribeIdentityProviderConfigRequest): DescribeIdentityProviderConfigResponse

    /**
     * Returns descriptive information about an Amazon EKS node group.
     */
    public suspend fun describeNodegroup(input: DescribeNodegroupRequest): DescribeNodegroupResponse

    /**
     * Returns descriptive information about an update against your Amazon EKS cluster or associated managed node group or Amazon EKS add-on.
     *
     * When the status of the update is `Succeeded`, the update is complete. If an update fails, the status is `Failed`, and an error detail explains the reason for the failure.
     */
    public suspend fun describeUpdate(input: DescribeUpdateRequest): DescribeUpdateResponse

    /**
     * Disassociates an identity provider configuration from a cluster. If you disassociate an identity provider from your cluster, users included in the provider can no longer access the cluster. However, you can still access the cluster with Amazon Web Services IAM users.
     */
    public suspend fun disassociateIdentityProviderConfig(input: DisassociateIdentityProviderConfigRequest): DisassociateIdentityProviderConfigResponse

    /**
     * Lists the available add-ons.
     */
    public suspend fun listAddons(input: ListAddonsRequest): ListAddonsResponse

    /**
     * Lists the Amazon EKS clusters in your Amazon Web Services account in the specified Region.
     */
    public suspend fun listClusters(input: ListClustersRequest = ListClustersRequest {}): ListClustersResponse

    /**
     * Lists the Fargate profiles associated with the specified cluster in your Amazon Web Services account in the specified Region.
     */
    public suspend fun listFargateProfiles(input: ListFargateProfilesRequest): ListFargateProfilesResponse

    /**
     * A list of identity provider configurations.
     */
    public suspend fun listIdentityProviderConfigs(input: ListIdentityProviderConfigsRequest): ListIdentityProviderConfigsResponse

    /**
     * Lists the Amazon EKS managed node groups associated with the specified cluster in your Amazon Web Services account in the specified Region. Self-managed node groups are not listed.
     */
    public suspend fun listNodegroups(input: ListNodegroupsRequest): ListNodegroupsResponse

    /**
     * List the tags for an Amazon EKS resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the updates associated with an Amazon EKS cluster or managed node group in your Amazon Web Services account, in the specified Region.
     */
    public suspend fun listUpdates(input: ListUpdatesRequest): ListUpdatesResponse

    /**
     * Connects a Kubernetes cluster to the Amazon EKS control plane.
     *
     * Any Kubernetes cluster can be connected to the Amazon EKS control plane to view current information about the cluster and its nodes.
     *
     * Cluster connection requires two steps. First, send a ` <a>RegisterClusterRequest</a> ` to add it to the Amazon EKS control plane.
     *
     * Second, a [Manifest](https://amazon-eks.s3.us-west-2.amazonaws.com/eks-connector/manifests/eks-connector/latest/eks-connector.yaml) containing the `activationID` and `activationCode` must be applied to the Kubernetes cluster through it's native provider to provide visibility.
     *
     * After the Manifest is updated and applied, then the connected cluster is visible to the Amazon EKS control plane. If the Manifest is not applied within three days, then the connected cluster will no longer be visible and must be deregistered. See DeregisterCluster.
     */
    public suspend fun registerCluster(input: RegisterClusterRequest): RegisterClusterResponse

    /**
     * Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are deleted as well. Tags that you create for Amazon EKS resources do not propagate to any other resources associated with the cluster. For example, if you tag a cluster with this operation, that tag does not automatically propagate to the subnets and nodes associated with the cluster.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Deletes specified tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an Amazon EKS add-on.
     */
    public suspend fun updateAddon(input: UpdateAddonRequest): UpdateAddonResponse

    /**
     * Updates an Amazon EKS cluster configuration. Your cluster continues to function during the update. The response output includes an update ID that you can use to track the status of your cluster update with the DescribeUpdate API operation.
     *
     * You can use this API operation to enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see [Amazon EKS Cluster Control Plane Logs](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html) in the **Amazon EKS User Guide**.
     *
     * CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see [CloudWatch Pricing](http://aws.amazon.com/cloudwatch/pricing/).
     *
     * You can also use this API operation to enable or disable public and private access to your cluster's Kubernetes API server endpoint. By default, public access is enabled, and private access is disabled. For more information, see [Amazon EKS cluster endpoint access control](https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html) in the **Amazon EKS User Guide**.
     *
     * You can't update the subnets or security group IDs for an existing cluster.
     *
     * Cluster updates are asynchronous, and they should finish within a few minutes. During an update, the cluster status moves to `UPDATING` (this status transition is eventually consistent). When the update is complete (either `Failed` or `Successful`), the cluster status moves to `Active`.
     */
    public suspend fun updateClusterConfig(input: UpdateClusterConfigRequest): UpdateClusterConfigResponse

    /**
     * Updates an Amazon EKS cluster to the specified Kubernetes version. Your cluster continues to function during the update. The response output includes an update ID that you can use to track the status of your cluster update with the DescribeUpdate API operation.
     *
     * Cluster updates are asynchronous, and they should finish within a few minutes. During an update, the cluster status moves to `UPDATING` (this status transition is eventually consistent). When the update is complete (either `Failed` or `Successful`), the cluster status moves to `Active`.
     *
     * If your cluster has managed node groups attached to it, all of your node groups’ Kubernetes versions must match the cluster’s Kubernetes version in order to update the cluster to a new Kubernetes version.
     */
    public suspend fun updateClusterVersion(input: UpdateClusterVersionRequest): UpdateClusterVersionResponse

    /**
     * Updates an Amazon EKS managed node group configuration. Your node group continues to function during the update. The response output includes an update ID that you can use to track the status of your node group update with the DescribeUpdate API operation. Currently you can update the Kubernetes labels for a node group or the scaling configuration.
     */
    public suspend fun updateNodegroupConfig(input: UpdateNodegroupConfigRequest): UpdateNodegroupConfigResponse

    /**
     * Updates the Kubernetes version or AMI version of an Amazon EKS managed node group.
     *
     * You can update a node group using a launch template only if the node group was originally deployed with a launch template. If you need to update a custom AMI in a node group that was deployed with a launch template, then update your custom AMI, specify the new ID in a new version of the launch template, and then update the node group to the new version of the launch template.
     *
     * If you update without a launch template, then you can update to the latest available AMI version of a node group's current Kubernetes version by not specifying a Kubernetes version in the request. You can update to the latest AMI version of your cluster's current Kubernetes version by specifying your cluster's Kubernetes version in the request. For more information, see [Amazon EKS optimized Amazon Linux 2 AMI versions](https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html) in the *Amazon EKS User Guide*.
     *
     * You cannot roll back a node group to an earlier Kubernetes version or AMI version.
     *
     * When a node in a managed node group is terminated due to a scaling action or update, the pods in that node are drained first. Amazon EKS attempts to drain the nodes gracefully and will fail if it is unable to do so. You can `force` the update if Amazon EKS is unable to drain the nodes as a result of a pod disruption budget issue.
     */
    public suspend fun updateNodegroupVersion(input: UpdateNodegroupVersionRequest): UpdateNodegroupVersionResponse
}

/**
 * Associate encryption configuration to an existing cluster.
 *
 * You can use this API to enable encryption on existing clusters which do not have encryption already enabled. This allows you to implement a defense-in-depth security strategy without migrating applications to new Amazon EKS clusters.
 */
public suspend inline fun EksClient.associateEncryptionConfig(crossinline block: AssociateEncryptionConfigRequest.Builder.() -> Unit): AssociateEncryptionConfigResponse = associateEncryptionConfig(AssociateEncryptionConfigRequest.Builder().apply(block).build())

/**
 * Associate an identity provider configuration to a cluster.
 *
 * If you want to authenticate identities using an identity provider, you can create an identity provider configuration and associate it to your cluster. After configuring authentication to your cluster you can create Kubernetes `roles` and `clusterroles` to assign permissions to the roles, and then bind the roles to the identities using Kubernetes `rolebindings` and `clusterrolebindings`. For more information see [Using RBAC Authorization](https://kubernetes.io/docs/reference/access-authn-authz/rbac/) in the Kubernetes documentation.
 */
public suspend inline fun EksClient.associateIdentityProviderConfig(crossinline block: AssociateIdentityProviderConfigRequest.Builder.() -> Unit): AssociateIdentityProviderConfigResponse = associateIdentityProviderConfig(AssociateIdentityProviderConfigRequest.Builder().apply(block).build())

/**
 * Creates an Amazon EKS add-on.
 *
 * Amazon EKS add-ons help to automate the provisioning and lifecycle management of common operational software for Amazon EKS clusters. Amazon EKS add-ons require clusters running version 1.18 or later because Amazon EKS add-ons rely on the Server-side Apply Kubernetes feature, which is only available in Kubernetes 1.18 and later. For more information, see [Amazon EKS add-ons](https://docs.aws.amazon.com/eks/latest/userguide/eks-add-ons.html) in the *Amazon EKS User Guide*.
 */
public suspend inline fun EksClient.createAddon(crossinline block: CreateAddonRequest.Builder.() -> Unit): CreateAddonResponse = createAddon(CreateAddonRequest.Builder().apply(block).build())

/**
 * Creates an Amazon EKS control plane.
 *
 * The Amazon EKS control plane consists of control plane instances that run the Kubernetes software, such as `etcd` and the API server. The control plane runs in an account managed by Amazon Web Services, and the Kubernetes API is exposed by the Amazon EKS API server endpoint. Each Amazon EKS cluster control plane is single tenant and unique. It runs on its own set of Amazon EC2 instances.
 *
 * The cluster control plane is provisioned across multiple Availability Zones and fronted by an Elastic Load Balancing Network Load Balancer. Amazon EKS also provisions elastic network interfaces in your VPC subnets to provide connectivity from the control plane instances to the nodes (for example, to support `kubectl exec`, `logs`, and `proxy` data flows).
 *
 * Amazon EKS nodes run in your Amazon Web Services account and connect to your cluster's control plane over the Kubernetes API server endpoint and a certificate file that is created for your cluster.
 *
 * In most cases, it takes several minutes to create a cluster. After you create an Amazon EKS cluster, you must configure your Kubernetes tooling to communicate with the API server and launch nodes into your cluster. For more information, see [Managing Cluster Authentication](https://docs.aws.amazon.com/eks/latest/userguide/managing-auth.html) and [Launching Amazon EKS nodes](https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html) in the *Amazon EKS User Guide*.
 */
public suspend inline fun EksClient.createCluster(crossinline block: CreateClusterRequest.Builder.() -> Unit): CreateClusterResponse = createCluster(CreateClusterRequest.Builder().apply(block).build())

/**
 * Creates an Fargate profile for your Amazon EKS cluster. You must have at least one Fargate profile in a cluster to be able to run pods on Fargate.
 *
 * The Fargate profile allows an administrator to declare which pods run on Fargate and specify which pods run on which Fargate profile. This declaration is done through the profile’s selectors. Each profile can have up to five selectors that contain a namespace and labels. A namespace is required for every selector. The label field consists of multiple optional key-value pairs. Pods that match the selectors are scheduled on Fargate. If a to-be-scheduled pod matches any of the selectors in the Fargate profile, then that pod is run on Fargate.
 *
 * When you create a Fargate profile, you must specify a pod execution role to use with the pods that are scheduled with the profile. This role is added to the cluster's Kubernetes [Role Based Access Control](https://kubernetes.io/docs/admin/authorization/rbac/) (RBAC) for authorization so that the `kubelet` that is running on the Fargate infrastructure can register with your Amazon EKS cluster so that it can appear in your cluster as a node. The pod execution role also provides IAM permissions to the Fargate infrastructure to allow read access to Amazon ECR image repositories. For more information, see [Pod Execution Role](https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html) in the *Amazon EKS User Guide*.
 *
 * Fargate profiles are immutable. However, you can create a new updated profile to replace an existing profile and then delete the original after the updated profile has finished creating.
 *
 * If any Fargate profiles in a cluster are in the `DELETING` status, you must wait for that Fargate profile to finish deleting before you can create any other profiles in that cluster.
 *
 * For more information, see [Fargate Profile](https://docs.aws.amazon.com/eks/latest/userguide/fargate-profile.html) in the *Amazon EKS User Guide*.
 */
public suspend inline fun EksClient.createFargateProfile(crossinline block: CreateFargateProfileRequest.Builder.() -> Unit): CreateFargateProfileResponse = createFargateProfile(CreateFargateProfileRequest.Builder().apply(block).build())

/**
 * Creates a managed node group for an Amazon EKS cluster. You can only create a node group for your cluster that is equal to the current Kubernetes version for the cluster. All node groups are created with the latest AMI release version for the respective minor Kubernetes version of the cluster, unless you deploy a custom AMI using a launch template. For more information about using launch templates, see [Launch template support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html).
 *
 * An Amazon EKS managed node group is an Amazon EC2 Auto Scaling group and associated Amazon EC2 instances that are managed by Amazon Web Services for an Amazon EKS cluster. Each node group uses a version of the Amazon EKS optimized Amazon Linux 2 AMI. For more information, see [Managed Node Groups](https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html) in the *Amazon EKS User Guide*.
 */
public suspend inline fun EksClient.createNodegroup(crossinline block: CreateNodegroupRequest.Builder.() -> Unit): CreateNodegroupResponse = createNodegroup(CreateNodegroupRequest.Builder().apply(block).build())

/**
 * Delete an Amazon EKS add-on.
 *
 * When you remove the add-on, it will also be deleted from the cluster. You can always manually start an add-on on the cluster using the Kubernetes API.
 */
public suspend inline fun EksClient.deleteAddon(crossinline block: DeleteAddonRequest.Builder.() -> Unit): DeleteAddonResponse = deleteAddon(DeleteAddonRequest.Builder().apply(block).build())

/**
 * Deletes the Amazon EKS cluster control plane.
 *
 * If you have active services in your cluster that are associated with a load balancer, you must delete those services before deleting the cluster so that the load balancers are deleted properly. Otherwise, you can have orphaned resources in your VPC that prevent you from being able to delete the VPC. For more information, see [Deleting a Cluster](https://docs.aws.amazon.com/eks/latest/userguide/delete-cluster.html) in the *Amazon EKS User Guide*.
 *
 * If you have managed node groups or Fargate profiles attached to the cluster, you must delete them first. For more information, see DeleteNodegroup and DeleteFargateProfile.
 */
public suspend inline fun EksClient.deleteCluster(crossinline block: DeleteClusterRequest.Builder.() -> Unit): DeleteClusterResponse = deleteCluster(DeleteClusterRequest.Builder().apply(block).build())

/**
 * Deletes an Fargate profile.
 *
 * When you delete a Fargate profile, any pods running on Fargate that were created with the profile are deleted. If those pods match another Fargate profile, then they are scheduled on Fargate with that profile. If they no longer match any Fargate profiles, then they are not scheduled on Fargate and they may remain in a pending state.
 *
 * Only one Fargate profile in a cluster can be in the `DELETING` status at a time. You must wait for a Fargate profile to finish deleting before you can delete any other profiles in that cluster.
 */
public suspend inline fun EksClient.deleteFargateProfile(crossinline block: DeleteFargateProfileRequest.Builder.() -> Unit): DeleteFargateProfileResponse = deleteFargateProfile(DeleteFargateProfileRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon EKS node group for a cluster.
 */
public suspend inline fun EksClient.deleteNodegroup(crossinline block: DeleteNodegroupRequest.Builder.() -> Unit): DeleteNodegroupResponse = deleteNodegroup(DeleteNodegroupRequest.Builder().apply(block).build())

/**
 * Deregisters a connected cluster to remove it from the Amazon EKS control plane.
 */
public suspend inline fun EksClient.deregisterCluster(crossinline block: DeregisterClusterRequest.Builder.() -> Unit): DeregisterClusterResponse = deregisterCluster(DeregisterClusterRequest.Builder().apply(block).build())

/**
 * Describes an Amazon EKS add-on.
 */
public suspend inline fun EksClient.describeAddon(crossinline block: DescribeAddonRequest.Builder.() -> Unit): DescribeAddonResponse = describeAddon(DescribeAddonRequest.Builder().apply(block).build())

/**
 * Describes the Kubernetes versions that the add-on can be used with.
 */
public suspend inline fun EksClient.describeAddonVersions(crossinline block: DescribeAddonVersionsRequest.Builder.() -> Unit): DescribeAddonVersionsResponse = describeAddonVersions(DescribeAddonVersionsRequest.Builder().apply(block).build())

/**
 * Returns descriptive information about an Amazon EKS cluster.
 *
 * The API server endpoint and certificate authority data returned by this operation are required for `kubelet` and `kubectl` to communicate with your Kubernetes API server. For more information, see [Create a kubeconfig for Amazon EKS](https://docs.aws.amazon.com/eks/latest/userguide/create-kubeconfig.html).
 *
 * The API server endpoint and certificate authority data aren't available until the cluster reaches the `ACTIVE` state.
 */
public suspend inline fun EksClient.describeCluster(crossinline block: DescribeClusterRequest.Builder.() -> Unit): DescribeClusterResponse = describeCluster(DescribeClusterRequest.Builder().apply(block).build())

/**
 * Returns descriptive information about an Fargate profile.
 */
public suspend inline fun EksClient.describeFargateProfile(crossinline block: DescribeFargateProfileRequest.Builder.() -> Unit): DescribeFargateProfileResponse = describeFargateProfile(DescribeFargateProfileRequest.Builder().apply(block).build())

/**
 * Returns descriptive information about an identity provider configuration.
 */
public suspend inline fun EksClient.describeIdentityProviderConfig(crossinline block: DescribeIdentityProviderConfigRequest.Builder.() -> Unit): DescribeIdentityProviderConfigResponse = describeIdentityProviderConfig(DescribeIdentityProviderConfigRequest.Builder().apply(block).build())

/**
 * Returns descriptive information about an Amazon EKS node group.
 */
public suspend inline fun EksClient.describeNodegroup(crossinline block: DescribeNodegroupRequest.Builder.() -> Unit): DescribeNodegroupResponse = describeNodegroup(DescribeNodegroupRequest.Builder().apply(block).build())

/**
 * Returns descriptive information about an update against your Amazon EKS cluster or associated managed node group or Amazon EKS add-on.
 *
 * When the status of the update is `Succeeded`, the update is complete. If an update fails, the status is `Failed`, and an error detail explains the reason for the failure.
 */
public suspend inline fun EksClient.describeUpdate(crossinline block: DescribeUpdateRequest.Builder.() -> Unit): DescribeUpdateResponse = describeUpdate(DescribeUpdateRequest.Builder().apply(block).build())

/**
 * Disassociates an identity provider configuration from a cluster. If you disassociate an identity provider from your cluster, users included in the provider can no longer access the cluster. However, you can still access the cluster with Amazon Web Services IAM users.
 */
public suspend inline fun EksClient.disassociateIdentityProviderConfig(crossinline block: DisassociateIdentityProviderConfigRequest.Builder.() -> Unit): DisassociateIdentityProviderConfigResponse = disassociateIdentityProviderConfig(DisassociateIdentityProviderConfigRequest.Builder().apply(block).build())

/**
 * Lists the available add-ons.
 */
public suspend inline fun EksClient.listAddons(crossinline block: ListAddonsRequest.Builder.() -> Unit): ListAddonsResponse = listAddons(ListAddonsRequest.Builder().apply(block).build())

/**
 * Lists the Amazon EKS clusters in your Amazon Web Services account in the specified Region.
 */
public suspend inline fun EksClient.listClusters(crossinline block: ListClustersRequest.Builder.() -> Unit): ListClustersResponse = listClusters(ListClustersRequest.Builder().apply(block).build())

/**
 * Lists the Fargate profiles associated with the specified cluster in your Amazon Web Services account in the specified Region.
 */
public suspend inline fun EksClient.listFargateProfiles(crossinline block: ListFargateProfilesRequest.Builder.() -> Unit): ListFargateProfilesResponse = listFargateProfiles(ListFargateProfilesRequest.Builder().apply(block).build())

/**
 * A list of identity provider configurations.
 */
public suspend inline fun EksClient.listIdentityProviderConfigs(crossinline block: ListIdentityProviderConfigsRequest.Builder.() -> Unit): ListIdentityProviderConfigsResponse = listIdentityProviderConfigs(ListIdentityProviderConfigsRequest.Builder().apply(block).build())

/**
 * Lists the Amazon EKS managed node groups associated with the specified cluster in your Amazon Web Services account in the specified Region. Self-managed node groups are not listed.
 */
public suspend inline fun EksClient.listNodegroups(crossinline block: ListNodegroupsRequest.Builder.() -> Unit): ListNodegroupsResponse = listNodegroups(ListNodegroupsRequest.Builder().apply(block).build())

/**
 * List the tags for an Amazon EKS resource.
 */
public suspend inline fun EksClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists the updates associated with an Amazon EKS cluster or managed node group in your Amazon Web Services account, in the specified Region.
 */
public suspend inline fun EksClient.listUpdates(crossinline block: ListUpdatesRequest.Builder.() -> Unit): ListUpdatesResponse = listUpdates(ListUpdatesRequest.Builder().apply(block).build())

/**
 * Connects a Kubernetes cluster to the Amazon EKS control plane.
 *
 * Any Kubernetes cluster can be connected to the Amazon EKS control plane to view current information about the cluster and its nodes.
 *
 * Cluster connection requires two steps. First, send a ` <a>RegisterClusterRequest</a> ` to add it to the Amazon EKS control plane.
 *
 * Second, a [Manifest](https://amazon-eks.s3.us-west-2.amazonaws.com/eks-connector/manifests/eks-connector/latest/eks-connector.yaml) containing the `activationID` and `activationCode` must be applied to the Kubernetes cluster through it's native provider to provide visibility.
 *
 * After the Manifest is updated and applied, then the connected cluster is visible to the Amazon EKS control plane. If the Manifest is not applied within three days, then the connected cluster will no longer be visible and must be deregistered. See DeregisterCluster.
 */
public suspend inline fun EksClient.registerCluster(crossinline block: RegisterClusterRequest.Builder.() -> Unit): RegisterClusterResponse = registerCluster(RegisterClusterRequest.Builder().apply(block).build())

/**
 * Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are deleted as well. Tags that you create for Amazon EKS resources do not propagate to any other resources associated with the cluster. For example, if you tag a cluster with this operation, that tag does not automatically propagate to the subnets and nodes associated with the cluster.
 */
public suspend inline fun EksClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Deletes specified tags from a resource.
 */
public suspend inline fun EksClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an Amazon EKS add-on.
 */
public suspend inline fun EksClient.updateAddon(crossinline block: UpdateAddonRequest.Builder.() -> Unit): UpdateAddonResponse = updateAddon(UpdateAddonRequest.Builder().apply(block).build())

/**
 * Updates an Amazon EKS cluster configuration. Your cluster continues to function during the update. The response output includes an update ID that you can use to track the status of your cluster update with the DescribeUpdate API operation.
 *
 * You can use this API operation to enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see [Amazon EKS Cluster Control Plane Logs](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html) in the **Amazon EKS User Guide**.
 *
 * CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see [CloudWatch Pricing](http://aws.amazon.com/cloudwatch/pricing/).
 *
 * You can also use this API operation to enable or disable public and private access to your cluster's Kubernetes API server endpoint. By default, public access is enabled, and private access is disabled. For more information, see [Amazon EKS cluster endpoint access control](https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html) in the **Amazon EKS User Guide**.
 *
 * You can't update the subnets or security group IDs for an existing cluster.
 *
 * Cluster updates are asynchronous, and they should finish within a few minutes. During an update, the cluster status moves to `UPDATING` (this status transition is eventually consistent). When the update is complete (either `Failed` or `Successful`), the cluster status moves to `Active`.
 */
public suspend inline fun EksClient.updateClusterConfig(crossinline block: UpdateClusterConfigRequest.Builder.() -> Unit): UpdateClusterConfigResponse = updateClusterConfig(UpdateClusterConfigRequest.Builder().apply(block).build())

/**
 * Updates an Amazon EKS cluster to the specified Kubernetes version. Your cluster continues to function during the update. The response output includes an update ID that you can use to track the status of your cluster update with the DescribeUpdate API operation.
 *
 * Cluster updates are asynchronous, and they should finish within a few minutes. During an update, the cluster status moves to `UPDATING` (this status transition is eventually consistent). When the update is complete (either `Failed` or `Successful`), the cluster status moves to `Active`.
 *
 * If your cluster has managed node groups attached to it, all of your node groups’ Kubernetes versions must match the cluster’s Kubernetes version in order to update the cluster to a new Kubernetes version.
 */
public suspend inline fun EksClient.updateClusterVersion(crossinline block: UpdateClusterVersionRequest.Builder.() -> Unit): UpdateClusterVersionResponse = updateClusterVersion(UpdateClusterVersionRequest.Builder().apply(block).build())

/**
 * Updates an Amazon EKS managed node group configuration. Your node group continues to function during the update. The response output includes an update ID that you can use to track the status of your node group update with the DescribeUpdate API operation. Currently you can update the Kubernetes labels for a node group or the scaling configuration.
 */
public suspend inline fun EksClient.updateNodegroupConfig(crossinline block: UpdateNodegroupConfigRequest.Builder.() -> Unit): UpdateNodegroupConfigResponse = updateNodegroupConfig(UpdateNodegroupConfigRequest.Builder().apply(block).build())

/**
 * Updates the Kubernetes version or AMI version of an Amazon EKS managed node group.
 *
 * You can update a node group using a launch template only if the node group was originally deployed with a launch template. If you need to update a custom AMI in a node group that was deployed with a launch template, then update your custom AMI, specify the new ID in a new version of the launch template, and then update the node group to the new version of the launch template.
 *
 * If you update without a launch template, then you can update to the latest available AMI version of a node group's current Kubernetes version by not specifying a Kubernetes version in the request. You can update to the latest AMI version of your cluster's current Kubernetes version by specifying your cluster's Kubernetes version in the request. For more information, see [Amazon EKS optimized Amazon Linux 2 AMI versions](https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html) in the *Amazon EKS User Guide*.
 *
 * You cannot roll back a node group to an earlier Kubernetes version or AMI version.
 *
 * When a node in a managed node group is terminated due to a scaling action or update, the pods in that node are drained first. Amazon EKS attempts to drain the nodes gracefully and will fail if it is unable to do so. You can `force` the update if Amazon EKS is unable to drain the nodes as a result of a pod disruption budget issue.
 */
public suspend inline fun EksClient.updateNodegroupVersion(crossinline block: UpdateNodegroupVersionRequest.Builder.() -> Unit): UpdateNodegroupVersionResponse = updateNodegroupVersion(UpdateNodegroupVersionRequest.Builder().apply(block).build())
