// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model



public class CreateAddonRequest private constructor(builder: Builder) {
    /**
     * The name of the add-on. The name must match one of the names returned by `DescribeAddonVersions`[](https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html).
     */
    public val addonName: kotlin.String? = builder.addonName
    /**
     * The version of the add-on. The version must match one of the versions returned by `DescribeAddonVersions`[](https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html).
     */
    public val addonVersion: kotlin.String? = builder.addonVersion
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The name of the cluster to create the add-on for.
     */
    public val clusterName: kotlin.String? = requireNotNull(builder.clusterName) { "A non-null value must be provided for clusterName" }
    /**
     * How to resolve parameter value conflicts when migrating an existing add-on to an Amazon EKS add-on.
     */
    public val resolveConflicts: aws.sdk.kotlin.services.eks.model.ResolveConflicts? = builder.resolveConflicts
    /**
     * The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's service account. The role must be assigned the IAM permissions required by the add-on. If you don't specify an existing IAM role, then the add-on uses the permissions assigned to the node IAM role. For more information, see [Amazon EKS node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html) in the *Amazon EKS User Guide*.
     *
     * To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your cluster. For more information, see [Enabling IAM roles for service accounts on your cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html) in the *Amazon EKS User Guide*.
     */
    public val serviceAccountRoleArn: kotlin.String? = builder.serviceAccountRoleArn
    /**
     * The metadata to apply to the cluster to assist with categorization and organization. Each tag consists of a key and an optional value. You define both.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.CreateAddonRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAddonRequest(")
        append("addonName=$addonName,")
        append("addonVersion=$addonVersion,")
        append("clientRequestToken=$clientRequestToken,")
        append("clusterName=$clusterName,")
        append("resolveConflicts=$resolveConflicts,")
        append("serviceAccountRoleArn=$serviceAccountRoleArn,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = addonName?.hashCode() ?: 0
        result = 31 * result + (addonVersion?.hashCode() ?: 0)
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (resolveConflicts?.hashCode() ?: 0)
        result = 31 * result + (serviceAccountRoleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAddonRequest

        if (addonName != other.addonName) return false
        if (addonVersion != other.addonVersion) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (clusterName != other.clusterName) return false
        if (resolveConflicts != other.resolveConflicts) return false
        if (serviceAccountRoleArn != other.serviceAccountRoleArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.CreateAddonRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the add-on. The name must match one of the names returned by `DescribeAddonVersions`[](https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html).
         */
        public var addonName: kotlin.String? = null
        /**
         * The version of the add-on. The version must match one of the versions returned by `DescribeAddonVersions`[](https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html).
         */
        public var addonVersion: kotlin.String? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The name of the cluster to create the add-on for.
         */
        public var clusterName: kotlin.String? = null
        /**
         * How to resolve parameter value conflicts when migrating an existing add-on to an Amazon EKS add-on.
         */
        public var resolveConflicts: aws.sdk.kotlin.services.eks.model.ResolveConflicts? = null
        /**
         * The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's service account. The role must be assigned the IAM permissions required by the add-on. If you don't specify an existing IAM role, then the add-on uses the permissions assigned to the node IAM role. For more information, see [Amazon EKS node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html) in the *Amazon EKS User Guide*.
         *
         * To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your cluster. For more information, see [Enabling IAM roles for service accounts on your cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html) in the *Amazon EKS User Guide*.
         */
        public var serviceAccountRoleArn: kotlin.String? = null
        /**
         * The metadata to apply to the cluster to assist with categorization and organization. Each tag consists of a key and an optional value. You define both.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.CreateAddonRequest) : this() {
            this.addonName = x.addonName
            this.addonVersion = x.addonVersion
            this.clientRequestToken = x.clientRequestToken
            this.clusterName = x.clusterName
            this.resolveConflicts = x.resolveConflicts
            this.serviceAccountRoleArn = x.serviceAccountRoleArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.CreateAddonRequest = CreateAddonRequest(this)
    }
}
