// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model



public class CreateFargateProfileRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The name of the Amazon EKS cluster to apply the Fargate profile to.
     */
    public val clusterName: kotlin.String? = requireNotNull(builder.clusterName) { "A non-null value must be provided for clusterName" }
    /**
     * The name of the Fargate profile.
     */
    public val fargateProfileName: kotlin.String? = builder.fargateProfileName
    /**
     * The Amazon Resource Name (ARN) of the pod execution role to use for pods that match the selectors in the Fargate profile. The pod execution role allows Fargate infrastructure to register with your cluster as a node, and it provides read access to Amazon ECR image repositories. For more information, see [Pod Execution Role](https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html) in the *Amazon EKS User Guide*.
     */
    public val podExecutionRoleArn: kotlin.String? = builder.podExecutionRoleArn
    /**
     * The selectors to match for pods to use this Fargate profile. Each selector must have an associated namespace. Optionally, you can also specify labels for a namespace. You may specify up to five selectors in a Fargate profile.
     */
    public val selectors: List<FargateProfileSelector>? = builder.selectors
    /**
     * The IDs of subnets to launch your pods into. At this time, pods running on Fargate are not assigned public IP addresses, so only private subnets (with no direct route to an Internet Gateway) are accepted for this parameter.
     */
    public val subnets: List<String>? = builder.subnets
    /**
     * The metadata to apply to the Fargate profile to assist with categorization and organization. Each tag consists of a key and an optional value. You define both. Fargate profile tags do not propagate to any other resources associated with the Fargate profile, such as the pods that are scheduled with it.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.CreateFargateProfileRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFargateProfileRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("clusterName=$clusterName,")
        append("fargateProfileName=$fargateProfileName,")
        append("podExecutionRoleArn=$podExecutionRoleArn,")
        append("selectors=$selectors,")
        append("subnets=$subnets,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (fargateProfileName?.hashCode() ?: 0)
        result = 31 * result + (podExecutionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (selectors?.hashCode() ?: 0)
        result = 31 * result + (subnets?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFargateProfileRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (clusterName != other.clusterName) return false
        if (fargateProfileName != other.fargateProfileName) return false
        if (podExecutionRoleArn != other.podExecutionRoleArn) return false
        if (selectors != other.selectors) return false
        if (subnets != other.subnets) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.CreateFargateProfileRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The name of the Amazon EKS cluster to apply the Fargate profile to.
         */
        public var clusterName: kotlin.String? = null
        /**
         * The name of the Fargate profile.
         */
        public var fargateProfileName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the pod execution role to use for pods that match the selectors in the Fargate profile. The pod execution role allows Fargate infrastructure to register with your cluster as a node, and it provides read access to Amazon ECR image repositories. For more information, see [Pod Execution Role](https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html) in the *Amazon EKS User Guide*.
         */
        public var podExecutionRoleArn: kotlin.String? = null
        /**
         * The selectors to match for pods to use this Fargate profile. Each selector must have an associated namespace. Optionally, you can also specify labels for a namespace. You may specify up to five selectors in a Fargate profile.
         */
        public var selectors: List<FargateProfileSelector>? = null
        /**
         * The IDs of subnets to launch your pods into. At this time, pods running on Fargate are not assigned public IP addresses, so only private subnets (with no direct route to an Internet Gateway) are accepted for this parameter.
         */
        public var subnets: List<String>? = null
        /**
         * The metadata to apply to the Fargate profile to assist with categorization and organization. Each tag consists of a key and an optional value. You define both. Fargate profile tags do not propagate to any other resources associated with the Fargate profile, such as the pods that are scheduled with it.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.CreateFargateProfileRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.clusterName = x.clusterName
            this.fargateProfileName = x.fargateProfileName
            this.podExecutionRoleArn = x.podExecutionRoleArn
            this.selectors = x.selectors
            this.subnets = x.subnets
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.CreateFargateProfileRequest = CreateFargateProfileRequest(this)
    }
}
