// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model



public class ListFargateProfilesRequest private constructor(builder: Builder) {
    /**
     * The name of the Amazon EKS cluster that you would like to list Fargate profiles in.
     */
    public val clusterName: kotlin.String? = requireNotNull(builder.clusterName) { "A non-null value must be provided for clusterName" }
    /**
     * The maximum number of Fargate profile results returned by `ListFargateProfiles` in paginated output. When you use this parameter, `ListFargateProfiles` returns only `maxResults` results in a single page along with a `nextToken` response element. You can see the remaining results of the initial request by sending another `ListFargateProfiles` request with the returned `nextToken` value. This value can be between 1 and 100. If you don't use this parameter, `ListFargateProfiles` returns up to 100 results and a `nextToken` value if applicable.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The `nextToken` value returned from a previous paginated `ListFargateProfiles` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.ListFargateProfilesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListFargateProfilesRequest(")
        append("clusterName=$clusterName,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterName?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListFargateProfilesRequest

        if (clusterName != other.clusterName) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.ListFargateProfilesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the Amazon EKS cluster that you would like to list Fargate profiles in.
         */
        public var clusterName: kotlin.String? = null
        /**
         * The maximum number of Fargate profile results returned by `ListFargateProfiles` in paginated output. When you use this parameter, `ListFargateProfiles` returns only `maxResults` results in a single page along with a `nextToken` response element. You can see the remaining results of the initial request by sending another `ListFargateProfiles` request with the returned `nextToken` value. This value can be between 1 and 100. If you don't use this parameter, `ListFargateProfiles` returns up to 100 results and a `nextToken` value if applicable.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The `nextToken` value returned from a previous paginated `ListFargateProfiles` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.ListFargateProfilesRequest) : this() {
            this.clusterName = x.clusterName
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.ListFargateProfilesRequest = ListFargateProfilesRequest(this)
    }
}
