// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object representing an Amazon EKS managed node group.
 */
public class Nodegroup private constructor(builder: Builder) {
    /**
     * If the node group was deployed using a launch template with a custom AMI, then this is `CUSTOM`. For node groups that weren't deployed using a launch template, this is the AMI type that was specified in the node group configuration.
     */
    public val amiType: aws.sdk.kotlin.services.eks.model.AmiTypes? = builder.amiType
    /**
     * The capacity type of your managed node group.
     */
    public val capacityType: aws.sdk.kotlin.services.eks.model.CapacityTypes? = builder.capacityType
    /**
     * The name of the cluster that the managed node group resides in.
     */
    public val clusterName: kotlin.String? = builder.clusterName
    /**
     * The Unix epoch timestamp in seconds for when the managed node group was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * If the node group wasn't deployed with a launch template, then this is the disk size in the node group configuration. If the node group was deployed with a launch template, then this is `null`.
     */
    public val diskSize: kotlin.Int? = builder.diskSize
    /**
     * The health status of the node group. If there are issues with your node group's health, they are listed here.
     */
    public val health: aws.sdk.kotlin.services.eks.model.NodegroupHealth? = builder.health
    /**
     * If the node group wasn't deployed with a launch template, then this is the instance type that is associated with the node group. If the node group was deployed with a launch template, then this is `null`.
     */
    public val instanceTypes: List<String>? = builder.instanceTypes
    /**
     * The Kubernetes labels applied to the nodes in the node group.
     *
     * Only labels that are applied with the Amazon EKS API are shown here. There may be other Kubernetes labels applied to the nodes in this group.
     */
    public val labels: Map<String, String>? = builder.labels
    /**
     * If a launch template was used to create the node group, then this is the launch template that was used.
     */
    public val launchTemplate: aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification? = builder.launchTemplate
    /**
     * The Unix epoch timestamp in seconds for when the managed node group was last modified.
     */
    public val modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.modifiedAt
    /**
     * The IAM role associated with your node group. The Amazon EKS node `kubelet` daemon makes calls to Amazon Web Services APIs on your behalf. Nodes receive permissions for these API calls through an IAM instance profile and associated policies.
     */
    public val nodeRole: kotlin.String? = builder.nodeRole
    /**
     * The Amazon Resource Name (ARN) associated with the managed node group.
     */
    public val nodegroupArn: kotlin.String? = builder.nodegroupArn
    /**
     * The name associated with an Amazon EKS managed node group.
     */
    public val nodegroupName: kotlin.String? = builder.nodegroupName
    /**
     * If the node group was deployed using a launch template with a custom AMI, then this is the AMI ID that was specified in the launch template. For node groups that weren't deployed using a launch template, this is the version of the Amazon EKS optimized AMI that the node group was deployed with.
     */
    public val releaseVersion: kotlin.String? = builder.releaseVersion
    /**
     * If the node group wasn't deployed with a launch template, then this is the remote access configuration that is associated with the node group. If the node group was deployed with a launch template, then this is `null`.
     */
    public val remoteAccess: aws.sdk.kotlin.services.eks.model.RemoteAccessConfig? = builder.remoteAccess
    /**
     * The resources associated with the node group, such as Auto Scaling groups and security groups for remote access.
     */
    public val resources: aws.sdk.kotlin.services.eks.model.NodegroupResources? = builder.resources
    /**
     * The scaling configuration details for the Auto Scaling group that is associated with your node group.
     */
    public val scalingConfig: aws.sdk.kotlin.services.eks.model.NodegroupScalingConfig? = builder.scalingConfig
    /**
     * The current status of the managed node group.
     */
    public val status: aws.sdk.kotlin.services.eks.model.NodegroupStatus? = builder.status
    /**
     * The subnets that were specified for the Auto Scaling group that is associated with your node group.
     */
    public val subnets: List<String>? = builder.subnets
    /**
     * The metadata applied to the node group to assist with categorization and organization. Each tag consists of a key and an optional value. You define both. Node group tags do not propagate to any other resources associated with the node group, such as the Amazon EC2 instances or subnets.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The Kubernetes taints to be applied to the nodes in the node group when they are created. Effect is one of `No_Schedule`, `Prefer_No_Schedule`, or `No_Execute`. Kubernetes taints can be used together with tolerations to control how workloads are scheduled to your nodes. For more information, see [Node taints on managed node groups](https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html).
     */
    public val taints: List<Taint>? = builder.taints
    /**
     * The node group update configuration.
     */
    public val updateConfig: aws.sdk.kotlin.services.eks.model.NodegroupUpdateConfig? = builder.updateConfig
    /**
     * The Kubernetes version of the managed node group.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.Nodegroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Nodegroup(")
        append("amiType=$amiType,")
        append("capacityType=$capacityType,")
        append("clusterName=$clusterName,")
        append("createdAt=$createdAt,")
        append("diskSize=$diskSize,")
        append("health=$health,")
        append("instanceTypes=$instanceTypes,")
        append("labels=$labels,")
        append("launchTemplate=$launchTemplate,")
        append("modifiedAt=$modifiedAt,")
        append("nodeRole=$nodeRole,")
        append("nodegroupArn=$nodegroupArn,")
        append("nodegroupName=$nodegroupName,")
        append("releaseVersion=$releaseVersion,")
        append("remoteAccess=$remoteAccess,")
        append("resources=$resources,")
        append("scalingConfig=$scalingConfig,")
        append("status=$status,")
        append("subnets=$subnets,")
        append("tags=$tags,")
        append("taints=$taints,")
        append("updateConfig=$updateConfig,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = amiType?.hashCode() ?: 0
        result = 31 * result + (capacityType?.hashCode() ?: 0)
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (diskSize ?: 0)
        result = 31 * result + (health?.hashCode() ?: 0)
        result = 31 * result + (instanceTypes?.hashCode() ?: 0)
        result = 31 * result + (labels?.hashCode() ?: 0)
        result = 31 * result + (launchTemplate?.hashCode() ?: 0)
        result = 31 * result + (modifiedAt?.hashCode() ?: 0)
        result = 31 * result + (nodeRole?.hashCode() ?: 0)
        result = 31 * result + (nodegroupArn?.hashCode() ?: 0)
        result = 31 * result + (nodegroupName?.hashCode() ?: 0)
        result = 31 * result + (releaseVersion?.hashCode() ?: 0)
        result = 31 * result + (remoteAccess?.hashCode() ?: 0)
        result = 31 * result + (resources?.hashCode() ?: 0)
        result = 31 * result + (scalingConfig?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subnets?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (taints?.hashCode() ?: 0)
        result = 31 * result + (updateConfig?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Nodegroup

        if (amiType != other.amiType) return false
        if (capacityType != other.capacityType) return false
        if (clusterName != other.clusterName) return false
        if (createdAt != other.createdAt) return false
        if (diskSize != other.diskSize) return false
        if (health != other.health) return false
        if (instanceTypes != other.instanceTypes) return false
        if (labels != other.labels) return false
        if (launchTemplate != other.launchTemplate) return false
        if (modifiedAt != other.modifiedAt) return false
        if (nodeRole != other.nodeRole) return false
        if (nodegroupArn != other.nodegroupArn) return false
        if (nodegroupName != other.nodegroupName) return false
        if (releaseVersion != other.releaseVersion) return false
        if (remoteAccess != other.remoteAccess) return false
        if (resources != other.resources) return false
        if (scalingConfig != other.scalingConfig) return false
        if (status != other.status) return false
        if (subnets != other.subnets) return false
        if (tags != other.tags) return false
        if (taints != other.taints) return false
        if (updateConfig != other.updateConfig) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.Nodegroup = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If the node group was deployed using a launch template with a custom AMI, then this is `CUSTOM`. For node groups that weren't deployed using a launch template, this is the AMI type that was specified in the node group configuration.
         */
        public var amiType: aws.sdk.kotlin.services.eks.model.AmiTypes? = null
        /**
         * The capacity type of your managed node group.
         */
        public var capacityType: aws.sdk.kotlin.services.eks.model.CapacityTypes? = null
        /**
         * The name of the cluster that the managed node group resides in.
         */
        public var clusterName: kotlin.String? = null
        /**
         * The Unix epoch timestamp in seconds for when the managed node group was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If the node group wasn't deployed with a launch template, then this is the disk size in the node group configuration. If the node group was deployed with a launch template, then this is `null`.
         */
        public var diskSize: kotlin.Int? = null
        /**
         * The health status of the node group. If there are issues with your node group's health, they are listed here.
         */
        public var health: aws.sdk.kotlin.services.eks.model.NodegroupHealth? = null
        /**
         * If the node group wasn't deployed with a launch template, then this is the instance type that is associated with the node group. If the node group was deployed with a launch template, then this is `null`.
         */
        public var instanceTypes: List<String>? = null
        /**
         * The Kubernetes labels applied to the nodes in the node group.
         *
         * Only labels that are applied with the Amazon EKS API are shown here. There may be other Kubernetes labels applied to the nodes in this group.
         */
        public var labels: Map<String, String>? = null
        /**
         * If a launch template was used to create the node group, then this is the launch template that was used.
         */
        public var launchTemplate: aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification? = null
        /**
         * The Unix epoch timestamp in seconds for when the managed node group was last modified.
         */
        public var modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The IAM role associated with your node group. The Amazon EKS node `kubelet` daemon makes calls to Amazon Web Services APIs on your behalf. Nodes receive permissions for these API calls through an IAM instance profile and associated policies.
         */
        public var nodeRole: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) associated with the managed node group.
         */
        public var nodegroupArn: kotlin.String? = null
        /**
         * The name associated with an Amazon EKS managed node group.
         */
        public var nodegroupName: kotlin.String? = null
        /**
         * If the node group was deployed using a launch template with a custom AMI, then this is the AMI ID that was specified in the launch template. For node groups that weren't deployed using a launch template, this is the version of the Amazon EKS optimized AMI that the node group was deployed with.
         */
        public var releaseVersion: kotlin.String? = null
        /**
         * If the node group wasn't deployed with a launch template, then this is the remote access configuration that is associated with the node group. If the node group was deployed with a launch template, then this is `null`.
         */
        public var remoteAccess: aws.sdk.kotlin.services.eks.model.RemoteAccessConfig? = null
        /**
         * The resources associated with the node group, such as Auto Scaling groups and security groups for remote access.
         */
        public var resources: aws.sdk.kotlin.services.eks.model.NodegroupResources? = null
        /**
         * The scaling configuration details for the Auto Scaling group that is associated with your node group.
         */
        public var scalingConfig: aws.sdk.kotlin.services.eks.model.NodegroupScalingConfig? = null
        /**
         * The current status of the managed node group.
         */
        public var status: aws.sdk.kotlin.services.eks.model.NodegroupStatus? = null
        /**
         * The subnets that were specified for the Auto Scaling group that is associated with your node group.
         */
        public var subnets: List<String>? = null
        /**
         * The metadata applied to the node group to assist with categorization and organization. Each tag consists of a key and an optional value. You define both. Node group tags do not propagate to any other resources associated with the node group, such as the Amazon EC2 instances or subnets.
         */
        public var tags: Map<String, String>? = null
        /**
         * The Kubernetes taints to be applied to the nodes in the node group when they are created. Effect is one of `No_Schedule`, `Prefer_No_Schedule`, or `No_Execute`. Kubernetes taints can be used together with tolerations to control how workloads are scheduled to your nodes. For more information, see [Node taints on managed node groups](https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html).
         */
        public var taints: List<Taint>? = null
        /**
         * The node group update configuration.
         */
        public var updateConfig: aws.sdk.kotlin.services.eks.model.NodegroupUpdateConfig? = null
        /**
         * The Kubernetes version of the managed node group.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.Nodegroup) : this() {
            this.amiType = x.amiType
            this.capacityType = x.capacityType
            this.clusterName = x.clusterName
            this.createdAt = x.createdAt
            this.diskSize = x.diskSize
            this.health = x.health
            this.instanceTypes = x.instanceTypes
            this.labels = x.labels
            this.launchTemplate = x.launchTemplate
            this.modifiedAt = x.modifiedAt
            this.nodeRole = x.nodeRole
            this.nodegroupArn = x.nodegroupArn
            this.nodegroupName = x.nodegroupName
            this.releaseVersion = x.releaseVersion
            this.remoteAccess = x.remoteAccess
            this.resources = x.resources
            this.scalingConfig = x.scalingConfig
            this.status = x.status
            this.subnets = x.subnets
            this.tags = x.tags
            this.taints = x.taints
            this.updateConfig = x.updateConfig
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.Nodegroup = Nodegroup(this)

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.NodegroupHealth] inside the given [block]
         */
        public fun health(block: aws.sdk.kotlin.services.eks.model.NodegroupHealth.Builder.() -> kotlin.Unit) {
            this.health = aws.sdk.kotlin.services.eks.model.NodegroupHealth.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification] inside the given [block]
         */
        public fun launchTemplate(block: aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification.Builder.() -> kotlin.Unit) {
            this.launchTemplate = aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.RemoteAccessConfig] inside the given [block]
         */
        public fun remoteAccess(block: aws.sdk.kotlin.services.eks.model.RemoteAccessConfig.Builder.() -> kotlin.Unit) {
            this.remoteAccess = aws.sdk.kotlin.services.eks.model.RemoteAccessConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.NodegroupResources] inside the given [block]
         */
        public fun resources(block: aws.sdk.kotlin.services.eks.model.NodegroupResources.Builder.() -> kotlin.Unit) {
            this.resources = aws.sdk.kotlin.services.eks.model.NodegroupResources.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.NodegroupScalingConfig] inside the given [block]
         */
        public fun scalingConfig(block: aws.sdk.kotlin.services.eks.model.NodegroupScalingConfig.Builder.() -> kotlin.Unit) {
            this.scalingConfig = aws.sdk.kotlin.services.eks.model.NodegroupScalingConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.NodegroupUpdateConfig] inside the given [block]
         */
        public fun updateConfig(block: aws.sdk.kotlin.services.eks.model.NodegroupUpdateConfig.Builder.() -> kotlin.Unit) {
            this.updateConfig = aws.sdk.kotlin.services.eks.model.NodegroupUpdateConfig.invoke(block)
        }
    }
}
