// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model



/**
 * An object representing an OpenID Connect (OIDC) configuration. Before associating an OIDC identity provider to your cluster, review the considerations in [Authenticating users for your cluster from an OpenID Connect identity provider](https://docs.aws.amazon.com/eks/latest/userguide/authenticate-oidc-identity-provider.html) in the *Amazon EKS User Guide*.
 */
public class OidcIdentityProviderConfigRequest private constructor(builder: Builder) {
    /**
     * This is also known as *audience*. The ID for the client application that makes authentication requests to the OpenID identity provider.
     */
    public val clientId: kotlin.String? = builder.clientId
    /**
     * The JWT claim that the provider uses to return your groups.
     */
    public val groupsClaim: kotlin.String? = builder.groupsClaim
    /**
     * The prefix that is prepended to group claims to prevent clashes with existing names (such as `system:` groups). For example, the value` oidc:` will create group names like `oidc:engineering` and `oidc:infra`.
     */
    public val groupsPrefix: kotlin.String? = builder.groupsPrefix
    /**
     * The name of the OIDC provider configuration.
     */
    public val identityProviderConfigName: kotlin.String? = builder.identityProviderConfigName
    /**
     * The URL of the OpenID identity provider that allows the API server to discover public signing keys for verifying tokens. The URL must begin with `https://` and should correspond to the `iss` claim in the provider's OIDC ID tokens. Per the OIDC standard, path components are allowed but query parameters are not. Typically the URL consists of only a hostname, like `https://server.example.org` or `https://example.com`. This URL should point to the level below `.well-known/openid-configuration` and must be publicly accessible over the internet.
     */
    public val issuerUrl: kotlin.String? = builder.issuerUrl
    /**
     * The key value pairs that describe required claims in the identity token. If set, each claim is verified to be present in the token with a matching value. For the maximum number of claims that you can require, see [Amazon EKS service quotas](https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html) in the *Amazon EKS User Guide*.
     */
    public val requiredClaims: Map<String, String>? = builder.requiredClaims
    /**
     * The JSON Web Token (JWT) claim to use as the username. The default is `sub`, which is expected to be a unique identifier of the end user. You can choose other claims, such as `email` or `name`, depending on the OpenID identity provider. Claims other than `email` are prefixed with the issuer URL to prevent naming clashes with other plug-ins.
     */
    public val usernameClaim: kotlin.String? = builder.usernameClaim
    /**
     * The prefix that is prepended to username claims to prevent clashes with existing names. If you do not provide this field, and `username` is a value other than `email`, the prefix defaults to `issuerurl#`. You can use the value `-` to disable all prefixing.
     */
    public val usernamePrefix: kotlin.String? = builder.usernamePrefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.OidcIdentityProviderConfigRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OidcIdentityProviderConfigRequest(")
        append("clientId=$clientId,")
        append("groupsClaim=$groupsClaim,")
        append("groupsPrefix=$groupsPrefix,")
        append("identityProviderConfigName=$identityProviderConfigName,")
        append("issuerUrl=$issuerUrl,")
        append("requiredClaims=$requiredClaims,")
        append("usernameClaim=$usernameClaim,")
        append("usernamePrefix=$usernamePrefix)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientId?.hashCode() ?: 0
        result = 31 * result + (groupsClaim?.hashCode() ?: 0)
        result = 31 * result + (groupsPrefix?.hashCode() ?: 0)
        result = 31 * result + (identityProviderConfigName?.hashCode() ?: 0)
        result = 31 * result + (issuerUrl?.hashCode() ?: 0)
        result = 31 * result + (requiredClaims?.hashCode() ?: 0)
        result = 31 * result + (usernameClaim?.hashCode() ?: 0)
        result = 31 * result + (usernamePrefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OidcIdentityProviderConfigRequest

        if (clientId != other.clientId) return false
        if (groupsClaim != other.groupsClaim) return false
        if (groupsPrefix != other.groupsPrefix) return false
        if (identityProviderConfigName != other.identityProviderConfigName) return false
        if (issuerUrl != other.issuerUrl) return false
        if (requiredClaims != other.requiredClaims) return false
        if (usernameClaim != other.usernameClaim) return false
        if (usernamePrefix != other.usernamePrefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.OidcIdentityProviderConfigRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * This is also known as *audience*. The ID for the client application that makes authentication requests to the OpenID identity provider.
         */
        public var clientId: kotlin.String? = null
        /**
         * The JWT claim that the provider uses to return your groups.
         */
        public var groupsClaim: kotlin.String? = null
        /**
         * The prefix that is prepended to group claims to prevent clashes with existing names (such as `system:` groups). For example, the value` oidc:` will create group names like `oidc:engineering` and `oidc:infra`.
         */
        public var groupsPrefix: kotlin.String? = null
        /**
         * The name of the OIDC provider configuration.
         */
        public var identityProviderConfigName: kotlin.String? = null
        /**
         * The URL of the OpenID identity provider that allows the API server to discover public signing keys for verifying tokens. The URL must begin with `https://` and should correspond to the `iss` claim in the provider's OIDC ID tokens. Per the OIDC standard, path components are allowed but query parameters are not. Typically the URL consists of only a hostname, like `https://server.example.org` or `https://example.com`. This URL should point to the level below `.well-known/openid-configuration` and must be publicly accessible over the internet.
         */
        public var issuerUrl: kotlin.String? = null
        /**
         * The key value pairs that describe required claims in the identity token. If set, each claim is verified to be present in the token with a matching value. For the maximum number of claims that you can require, see [Amazon EKS service quotas](https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html) in the *Amazon EKS User Guide*.
         */
        public var requiredClaims: Map<String, String>? = null
        /**
         * The JSON Web Token (JWT) claim to use as the username. The default is `sub`, which is expected to be a unique identifier of the end user. You can choose other claims, such as `email` or `name`, depending on the OpenID identity provider. Claims other than `email` are prefixed with the issuer URL to prevent naming clashes with other plug-ins.
         */
        public var usernameClaim: kotlin.String? = null
        /**
         * The prefix that is prepended to username claims to prevent clashes with existing names. If you do not provide this field, and `username` is a value other than `email`, the prefix defaults to `issuerurl#`. You can use the value `-` to disable all prefixing.
         */
        public var usernamePrefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.OidcIdentityProviderConfigRequest) : this() {
            this.clientId = x.clientId
            this.groupsClaim = x.groupsClaim
            this.groupsPrefix = x.groupsPrefix
            this.identityProviderConfigName = x.identityProviderConfigName
            this.issuerUrl = x.issuerUrl
            this.requiredClaims = x.requiredClaims
            this.usernameClaim = x.usernameClaim
            this.usernamePrefix = x.usernamePrefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.OidcIdentityProviderConfigRequest = OidcIdentityProviderConfigRequest(this)
    }
}
