// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model



public class UpdateAddonRequest private constructor(builder: Builder) {
    /**
     * The name of the add-on. The name must match one of the names returned by `ListAddons`[](https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html).
     */
    public val addonName: kotlin.String? = requireNotNull(builder.addonName) { "A non-null value must be provided for addonName" }
    /**
     * The version of the add-on. The version must match one of the versions returned by `DescribeAddonVersions`[](https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html).
     */
    public val addonVersion: kotlin.String? = builder.addonVersion
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The name of the cluster.
     */
    public val clusterName: kotlin.String? = requireNotNull(builder.clusterName) { "A non-null value must be provided for clusterName" }
    /**
     * How to resolve parameter value conflicts when applying the new version of the add-on to the cluster.
     */
    public val resolveConflicts: aws.sdk.kotlin.services.eks.model.ResolveConflicts? = builder.resolveConflicts
    /**
     * The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's service account. The role must be assigned the IAM permissions required by the add-on. If you don't specify an existing IAM role, then the add-on uses the permissions assigned to the node IAM role. For more information, see [Amazon EKS node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html) in the *Amazon EKS User Guide*.
     *
     * To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your cluster. For more information, see [Enabling IAM roles for service accounts on your cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html) in the *Amazon EKS User Guide*.
     */
    public val serviceAccountRoleArn: kotlin.String? = builder.serviceAccountRoleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.UpdateAddonRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAddonRequest(")
        append("addonName=$addonName,")
        append("addonVersion=$addonVersion,")
        append("clientRequestToken=$clientRequestToken,")
        append("clusterName=$clusterName,")
        append("resolveConflicts=$resolveConflicts,")
        append("serviceAccountRoleArn=$serviceAccountRoleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = addonName?.hashCode() ?: 0
        result = 31 * result + (addonVersion?.hashCode() ?: 0)
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (resolveConflicts?.hashCode() ?: 0)
        result = 31 * result + (serviceAccountRoleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateAddonRequest

        if (addonName != other.addonName) return false
        if (addonVersion != other.addonVersion) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (clusterName != other.clusterName) return false
        if (resolveConflicts != other.resolveConflicts) return false
        if (serviceAccountRoleArn != other.serviceAccountRoleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.UpdateAddonRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the add-on. The name must match one of the names returned by `ListAddons`[](https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html).
         */
        public var addonName: kotlin.String? = null
        /**
         * The version of the add-on. The version must match one of the versions returned by `DescribeAddonVersions`[](https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html).
         */
        public var addonVersion: kotlin.String? = null
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The name of the cluster.
         */
        public var clusterName: kotlin.String? = null
        /**
         * How to resolve parameter value conflicts when applying the new version of the add-on to the cluster.
         */
        public var resolveConflicts: aws.sdk.kotlin.services.eks.model.ResolveConflicts? = null
        /**
         * The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's service account. The role must be assigned the IAM permissions required by the add-on. If you don't specify an existing IAM role, then the add-on uses the permissions assigned to the node IAM role. For more information, see [Amazon EKS node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html) in the *Amazon EKS User Guide*.
         *
         * To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your cluster. For more information, see [Enabling IAM roles for service accounts on your cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html) in the *Amazon EKS User Guide*.
         */
        public var serviceAccountRoleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.UpdateAddonRequest) : this() {
            this.addonName = x.addonName
            this.addonVersion = x.addonVersion
            this.clientRequestToken = x.clientRequestToken
            this.clusterName = x.clusterName
            this.resolveConflicts = x.resolveConflicts
            this.serviceAccountRoleArn = x.serviceAccountRoleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.UpdateAddonRequest = UpdateAddonRequest(this)
    }
}
