// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model



/**
 * An object representing the VPC configuration to use for an Amazon EKS cluster.
 */
public class VpcConfigRequest private constructor(builder: Builder) {
    /**
     * Set this value to `true` to enable private access for your cluster's Kubernetes API server endpoint. If you enable private access, Kubernetes API requests from within your cluster's VPC use the private VPC endpoint. The default value for this parameter is `false`, which disables private access for your Kubernetes API server. If you disable private access and you have nodes or Fargate pods in the cluster, then ensure that `publicAccessCidrs` includes the necessary CIDR blocks for communication with the nodes or Fargate pods. For more information, see [Amazon EKS cluster endpoint access control](https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html) in the **Amazon EKS User Guide**.
     */
    public val endpointPrivateAccess: kotlin.Boolean? = builder.endpointPrivateAccess
    /**
     * Set this value to `false` to disable public access to your cluster's Kubernetes API server endpoint. If you disable public access, your cluster's Kubernetes API server can only receive requests from within the cluster VPC. The default value for this parameter is `true`, which enables public access for your Kubernetes API server. For more information, see [Amazon EKS cluster endpoint access control](https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html) in the **Amazon EKS User Guide**.
     */
    public val endpointPublicAccess: kotlin.Boolean? = builder.endpointPublicAccess
    /**
     * The CIDR blocks that are allowed access to your cluster's public Kubernetes API server endpoint. Communication to the endpoint from addresses outside of the CIDR blocks that you specify is denied. The default value is `0.0.0.0/0`. If you've disabled private endpoint access and you have nodes or Fargate pods in the cluster, then ensure that you specify the necessary CIDR blocks. For more information, see [Amazon EKS cluster endpoint access control](https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html) in the **Amazon EKS User Guide**.
     */
    public val publicAccessCidrs: List<String>? = builder.publicAccessCidrs
    /**
     * Specify one or more security groups for the cross-account elastic network interfaces that Amazon EKS creates to use that allow communication between your nodes and the Kubernetes control plane. If you don't specify any security groups, then familiarize yourself with the difference between Amazon EKS defaults for clusters deployed with Kubernetes:
     * + 1.14 Amazon EKS platform version `eks.2` and earlier
     * + 1.14 Amazon EKS platform version `eks.3` and later
     *
     * For more information, see [Amazon EKS security group considerations](https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html) in the **Amazon EKS User Guide**.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * Specify subnets for your Amazon EKS nodes. Amazon EKS creates cross-account elastic network interfaces in these subnets to allow communication between your nodes and the Kubernetes control plane.
     */
    public val subnetIds: List<String>? = builder.subnetIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.VpcConfigRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcConfigRequest(")
        append("endpointPrivateAccess=$endpointPrivateAccess,")
        append("endpointPublicAccess=$endpointPublicAccess,")
        append("publicAccessCidrs=$publicAccessCidrs,")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetIds=$subnetIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endpointPrivateAccess?.hashCode() ?: 0
        result = 31 * result + (endpointPublicAccess?.hashCode() ?: 0)
        result = 31 * result + (publicAccessCidrs?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcConfigRequest

        if (endpointPrivateAccess != other.endpointPrivateAccess) return false
        if (endpointPublicAccess != other.endpointPublicAccess) return false
        if (publicAccessCidrs != other.publicAccessCidrs) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetIds != other.subnetIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.VpcConfigRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Set this value to `true` to enable private access for your cluster's Kubernetes API server endpoint. If you enable private access, Kubernetes API requests from within your cluster's VPC use the private VPC endpoint. The default value for this parameter is `false`, which disables private access for your Kubernetes API server. If you disable private access and you have nodes or Fargate pods in the cluster, then ensure that `publicAccessCidrs` includes the necessary CIDR blocks for communication with the nodes or Fargate pods. For more information, see [Amazon EKS cluster endpoint access control](https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html) in the **Amazon EKS User Guide**.
         */
        public var endpointPrivateAccess: kotlin.Boolean? = null
        /**
         * Set this value to `false` to disable public access to your cluster's Kubernetes API server endpoint. If you disable public access, your cluster's Kubernetes API server can only receive requests from within the cluster VPC. The default value for this parameter is `true`, which enables public access for your Kubernetes API server. For more information, see [Amazon EKS cluster endpoint access control](https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html) in the **Amazon EKS User Guide**.
         */
        public var endpointPublicAccess: kotlin.Boolean? = null
        /**
         * The CIDR blocks that are allowed access to your cluster's public Kubernetes API server endpoint. Communication to the endpoint from addresses outside of the CIDR blocks that you specify is denied. The default value is `0.0.0.0/0`. If you've disabled private endpoint access and you have nodes or Fargate pods in the cluster, then ensure that you specify the necessary CIDR blocks. For more information, see [Amazon EKS cluster endpoint access control](https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html) in the **Amazon EKS User Guide**.
         */
        public var publicAccessCidrs: List<String>? = null
        /**
         * Specify one or more security groups for the cross-account elastic network interfaces that Amazon EKS creates to use that allow communication between your nodes and the Kubernetes control plane. If you don't specify any security groups, then familiarize yourself with the difference between Amazon EKS defaults for clusters deployed with Kubernetes:
         * + 1.14 Amazon EKS platform version `eks.2` and earlier
         * + 1.14 Amazon EKS platform version `eks.3` and later
         *
         * For more information, see [Amazon EKS security group considerations](https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html) in the **Amazon EKS User Guide**.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * Specify subnets for your Amazon EKS nodes. Amazon EKS creates cross-account elastic network interfaces in these subnets to allow communication between your nodes and the Kubernetes control plane.
         */
        public var subnetIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.VpcConfigRequest) : this() {
            this.endpointPrivateAccess = x.endpointPrivateAccess
            this.endpointPublicAccess = x.endpointPublicAccess
            this.publicAccessCidrs = x.publicAccessCidrs
            this.securityGroupIds = x.securityGroupIds
            this.subnetIds = x.subnetIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.VpcConfigRequest = VpcConfigRequest(this)
    }
}
