// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.transform

import aws.sdk.kotlin.services.eks.model.AmiTypes
import aws.sdk.kotlin.services.eks.model.CapacityTypes
import aws.sdk.kotlin.services.eks.model.CreateNodegroupRequest
import aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification
import aws.sdk.kotlin.services.eks.model.NodegroupScalingConfig
import aws.sdk.kotlin.services.eks.model.NodegroupUpdateConfig
import aws.sdk.kotlin.services.eks.model.RemoteAccessConfig
import aws.sdk.kotlin.services.eks.model.Taint
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateNodegroupOperationSerializer: HttpSerialize<CreateNodegroupRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateNodegroupRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "clusters",
                "${input.clusterName}".encodeLabel(),
                "node-groups",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateNodegroupOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateNodegroupOperationBody(context: ExecutionContext, input: CreateNodegroupRequest): ByteArray {
    val serializer = JsonSerializer()
    val AMITYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("amiType"))
    val CAPACITYTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("capacityType"))
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientRequestToken"))
    val DISKSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("diskSize"))
    val INSTANCETYPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("instanceTypes"))
    val LABELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("labels"))
    val LAUNCHTEMPLATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("launchTemplate"))
    val NODEROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nodeRole"))
    val NODEGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nodegroupName"))
    val RELEASEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("releaseVersion"))
    val REMOTEACCESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("remoteAccess"))
    val SCALINGCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("scalingConfig"))
    val SUBNETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("subnets"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TAINTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("taints"))
    val UPDATECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("updateConfig"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("version"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AMITYPE_DESCRIPTOR)
        field(CAPACITYTYPE_DESCRIPTOR)
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(DISKSIZE_DESCRIPTOR)
        field(INSTANCETYPES_DESCRIPTOR)
        field(LABELS_DESCRIPTOR)
        field(LAUNCHTEMPLATE_DESCRIPTOR)
        field(NODEROLE_DESCRIPTOR)
        field(NODEGROUPNAME_DESCRIPTOR)
        field(RELEASEVERSION_DESCRIPTOR)
        field(REMOTEACCESS_DESCRIPTOR)
        field(SCALINGCONFIG_DESCRIPTOR)
        field(SUBNETS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TAINTS_DESCRIPTOR)
        field(UPDATECONFIG_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.amiType?.let { field(AMITYPE_DESCRIPTOR, it.value) }
        input.capacityType?.let { field(CAPACITYTYPE_DESCRIPTOR, it.value) }
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTREQUESTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.diskSize?.let { field(DISKSIZE_DESCRIPTOR, it) }
        if (input.instanceTypes != null) {
            listField(INSTANCETYPES_DESCRIPTOR) {
                for (el0 in input.instanceTypes) {
                    serializeString(el0)
                }
            }
        }
        if (input.labels != null) {
            mapField(LABELS_DESCRIPTOR) {
                input.labels.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.launchTemplate?.let { field(LAUNCHTEMPLATE_DESCRIPTOR, it, ::serializeLaunchTemplateSpecificationDocument) }
        input.nodeRole?.let { field(NODEROLE_DESCRIPTOR, it) }
        input.nodegroupName?.let { field(NODEGROUPNAME_DESCRIPTOR, it) }
        input.releaseVersion?.let { field(RELEASEVERSION_DESCRIPTOR, it) }
        input.remoteAccess?.let { field(REMOTEACCESS_DESCRIPTOR, it, ::serializeRemoteAccessConfigDocument) }
        input.scalingConfig?.let { field(SCALINGCONFIG_DESCRIPTOR, it, ::serializeNodegroupScalingConfigDocument) }
        if (input.subnets != null) {
            listField(SUBNETS_DESCRIPTOR) {
                for (el0 in input.subnets) {
                    serializeString(el0)
                }
            }
        }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
        if (input.taints != null) {
            listField(TAINTS_DESCRIPTOR) {
                for (el0 in input.taints) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTaintDocument))
                }
            }
        }
        input.updateConfig?.let { field(UPDATECONFIG_DESCRIPTOR, it, ::serializeNodegroupUpdateConfigDocument) }
        input.version?.let { field(VERSION_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
