// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.transform

import aws.sdk.kotlin.services.eks.model.Logging
import aws.sdk.kotlin.services.eks.model.UpdateClusterConfigRequest
import aws.sdk.kotlin.services.eks.model.VpcConfigRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateClusterConfigOperationSerializer: HttpSerialize<UpdateClusterConfigRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateClusterConfigRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "clusters",
                "${input.name}".encodeLabel(),
                "update-config",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateClusterConfigOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateClusterConfigOperationBody(context: ExecutionContext, input: UpdateClusterConfigRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientRequestToken"))
    val LOGGING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("logging"))
    val RESOURCESVPCCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("resourcesVpcConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(LOGGING_DESCRIPTOR)
        field(RESOURCESVPCCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTREQUESTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.logging?.let { field(LOGGING_DESCRIPTOR, it, ::serializeLoggingDocument) }
        input.resourcesVpcConfig?.let { field(RESOURCESVPCCONFIG_DESCRIPTOR, it, ::serializeVpcConfigRequestDocument) }
    }
    return serializer.toByteArray()
}
