// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.transform

import aws.sdk.kotlin.services.eks.model.NodegroupScalingConfig
import aws.sdk.kotlin.services.eks.model.NodegroupUpdateConfig
import aws.sdk.kotlin.services.eks.model.UpdateLabelsPayload
import aws.sdk.kotlin.services.eks.model.UpdateNodegroupConfigRequest
import aws.sdk.kotlin.services.eks.model.UpdateTaintsPayload
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateNodegroupConfigOperationSerializer: HttpSerialize<UpdateNodegroupConfigRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateNodegroupConfigRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "clusters",
                "${input.clusterName}".encodeLabel(),
                "node-groups",
                "${input.nodegroupName}".encodeLabel(),
                "update-config",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateNodegroupConfigOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateNodegroupConfigOperationBody(context: ExecutionContext, input: UpdateNodegroupConfigRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientRequestToken"))
    val LABELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("labels"))
    val SCALINGCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("scalingConfig"))
    val TAINTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("taints"))
    val UPDATECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("updateConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(LABELS_DESCRIPTOR)
        field(SCALINGCONFIG_DESCRIPTOR)
        field(TAINTS_DESCRIPTOR)
        field(UPDATECONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTREQUESTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.labels?.let { field(LABELS_DESCRIPTOR, it, ::serializeUpdateLabelsPayloadDocument) }
        input.scalingConfig?.let { field(SCALINGCONFIG_DESCRIPTOR, it, ::serializeNodegroupScalingConfigDocument) }
        input.taints?.let { field(TAINTS_DESCRIPTOR, it, ::serializeUpdateTaintsPayloadDocument) }
        input.updateConfig?.let { field(UPDATECONFIG_DESCRIPTOR, it, ::serializeNodegroupUpdateConfigDocument) }
    }
    return serializer.toByteArray()
}
