// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupResponse
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.sdk.kotlin.services.elasticache.model.GlobalReplicationGroup
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class DecreaseNodeGroupsInGlobalReplicationGroupOperationDeserializer: HttpDeserialize<DecreaseNodeGroupsInGlobalReplicationGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DecreaseNodeGroupsInGlobalReplicationGroupResponse {
        if (!response.status.isSuccess()) {
            throwDecreaseNodeGroupsInGlobalReplicationGroupError(context, response)
        }
        val builder = DecreaseNodeGroupsInGlobalReplicationGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDecreaseNodeGroupsInGlobalReplicationGroupOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDecreaseNodeGroupsInGlobalReplicationGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "GlobalReplicationGroupNotFoundFault" -> GlobalReplicationGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidGlobalReplicationGroupState" -> InvalidGlobalReplicationGroupStateFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterCombination" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDecreaseNodeGroupsInGlobalReplicationGroupOperationBody(builder: DecreaseNodeGroupsInGlobalReplicationGroupResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DecreaseNodeGroupsInGlobalReplicationGroupResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DecreaseNodeGroupsInGlobalReplicationGroupResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DecreaseNodeGroupsInGlobalReplicationGroup response")
    }
    // end unwrap response wrapper

    val GLOBALREPLICATIONGROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("GlobalReplicationGroup"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticache.amazonaws.com/doc/2015-02-02/"))
        trait(XmlSerialName("DecreaseNodeGroupsInGlobalReplicationGroupResult"))
        field(GLOBALREPLICATIONGROUP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                GLOBALREPLICATIONGROUP_DESCRIPTOR.index -> builder.globalReplicationGroup = deserializeGlobalReplicationGroupDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
