// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains all of the attributes of a specific cluster.
 */
public class CacheCluster private constructor(builder: Builder) {
    /**
     * The ARN (Amazon Resource Name) of the cache cluster.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * A flag that enables encryption at-rest when set to `true`.
     *
     * You cannot modify the value of `AtRestEncryptionEnabled` after the cluster is created. To enable at-rest encryption on a cluster you must set `AtRestEncryptionEnabled` to `true` when you create a cluster.
     *
     * **Required:** Only available when creating a replication group in an Amazon VPC using redis version `3.2.6`, `4.x` or later.
     *
     * Default: `false`
     */
    public val atRestEncryptionEnabled: kotlin.Boolean? = builder.atRestEncryptionEnabled
    /**
     * A flag that enables using an `AuthToken` (password) when issuing Redis commands.
     *
     * Default: `false`
     */
    public val authTokenEnabled: kotlin.Boolean? = builder.authTokenEnabled
    /**
     * The date the auth token was last modified
     */
    public val authTokenLastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.authTokenLastModifiedDate
    /**
     * If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean = builder.autoMinorVersionUpgrade
    /**
     * The date and time when the cluster was created.
     */
    public val cacheClusterCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.cacheClusterCreateTime
    /**
     * The user-supplied identifier of the cluster. This identifier is a unique key that identifies a cluster.
     */
    public val cacheClusterId: kotlin.String? = builder.cacheClusterId
    /**
     * The current state of this cluster, one of the following values: `available`, `creating`, `deleted`, `deleting`, `incompatible-network`, `modifying`, `rebooting cluster nodes`, `restore-failed`, or `snapshotting`.
     */
    public val cacheClusterStatus: kotlin.String? = builder.cacheClusterStatus
    /**
     * The name of the compute and memory capacity node type for the cluster.
     *
     * The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.
     * + General purpose:
     *    + Current generation: **M6g node types:** (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): `cache.m6g.large`, `cache.m6g.xlarge`, `cache.m6g.2xlarge`, `cache.m6g.4xlarge`, `cache.m6g.8xlarge`, `cache.m6g.12xlarge`, `cache.m6g.16xlarge`For region availability, see [Supported Node Types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)**M5 node types:**`cache.m5.large`, `cache.m5.xlarge`, `cache.m5.2xlarge`, `cache.m5.4xlarge`, `cache.m5.12xlarge`, `cache.m5.24xlarge`**M4 node types:**`cache.m4.large`, `cache.m4.xlarge`, `cache.m4.2xlarge`, `cache.m4.4xlarge`, `cache.m4.10xlarge`**T4g node types** (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): `cache.t4g.micro`, `cache.t4g.small`, `cache.t4g.medium`**T3 node types:**`cache.t3.micro`, `cache.t3.small`, `cache.t3.medium`**T2 node types:**`cache.t2.micro`, `cache.t2.small`, `cache.t2.medium`
     *    + Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)**T1 node types:**`cache.t1.micro`**M1 node types:**`cache.m1.small`, `cache.m1.medium`, `cache.m1.large`, `cache.m1.xlarge`**M3 node types:**`cache.m3.medium`, `cache.m3.large`, `cache.m3.xlarge`, `cache.m3.2xlarge`
     * + Compute optimized:
     *    + Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)**C1 node types:**`cache.c1.xlarge`
     * + Memory optimized with data tiering:
     *    + Current generation: **R6gd node types** (available only for Redis engine version 6.2 onward).`cache.r6gd.xlarge`, `cache.r6gd.2xlarge`, `cache.r6gd.4xlarge`, `cache.r6gd.8xlarge`, `cache.r6gd.12xlarge`, `cache.r6gd.16xlarge`
     * + Memory optimized:
     *    + Current generation: **R6g node types** (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).`cache.r6g.large`, `cache.r6g.xlarge`, `cache.r6g.2xlarge`, `cache.r6g.4xlarge`, `cache.r6g.8xlarge`, `cache.r6g.12xlarge`, `cache.r6g.16xlarge`For region availability, see [Supported Node Types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)**R5 node types:**`cache.r5.large`, `cache.r5.xlarge`, `cache.r5.2xlarge`, `cache.r5.4xlarge`, `cache.r5.12xlarge`, `cache.r5.24xlarge`**R4 node types:**`cache.r4.large`, `cache.r4.xlarge`, `cache.r4.2xlarge`, `cache.r4.4xlarge`, `cache.r4.8xlarge`, `cache.r4.16xlarge`
     *    + Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)**M2 node types:**`cache.m2.xlarge`, `cache.m2.2xlarge`, `cache.m2.4xlarge`**R3 node types:**`cache.r3.large`, `cache.r3.xlarge`, `cache.r3.2xlarge`, `cache.r3.4xlarge`, `cache.r3.8xlarge`
     *
     * **Additional node type info**
     * + All current generation instance types are created in Amazon VPC by default.
     * + Redis append-only files (AOF) are not supported for T1 or T2 instances.
     * + Redis Multi-AZ with automatic failover is not supported on T1 instances.
     * + Redis configuration variables `appendonly` and `appendfsync` are not supported on Redis version 2.8.22 and later.
     */
    public val cacheNodeType: kotlin.String? = builder.cacheNodeType
    /**
     * A list of cache nodes that are members of the cluster.
     */
    public val cacheNodes: List<CacheNode>? = builder.cacheNodes
    /**
     * Status of the cache parameter group.
     */
    public val cacheParameterGroup: aws.sdk.kotlin.services.elasticache.model.CacheParameterGroupStatus? = builder.cacheParameterGroup
    /**
     * A list of cache security group elements, composed of name and status sub-elements.
     */
    public val cacheSecurityGroups: List<CacheSecurityGroupMembership>? = builder.cacheSecurityGroups
    /**
     * The name of the cache subnet group associated with the cluster.
     */
    public val cacheSubnetGroupName: kotlin.String? = builder.cacheSubnetGroupName
    /**
     * The URL of the web page where you can download the latest ElastiCache client library.
     */
    public val clientDownloadLandingPage: kotlin.String? = builder.clientDownloadLandingPage
    /**
     * Represents a Memcached cluster endpoint which can be used by an application to connect to any node in the cluster. The configuration endpoint will always have `.cfg` in it.
     *
     * Example: `mem-3.9dvc4r<u>.cfg</u>.usw2.cache.amazonaws.com:11211`
     */
    public val configurationEndpoint: aws.sdk.kotlin.services.elasticache.model.Endpoint? = builder.configurationEndpoint
    /**
     * The name of the cache engine (`memcached` or `redis`) to be used for this cluster.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The version of the cache engine that is used in this cluster.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * Returns the destination, format and type of the logs.
     */
    public val logDeliveryConfigurations: List<LogDeliveryConfiguration>? = builder.logDeliveryConfigurations
    /**
     * Describes a notification topic and its status. Notification topics are used for publishing ElastiCache events to subscribers using Amazon Simple Notification Service (SNS).
     */
    public val notificationConfiguration: aws.sdk.kotlin.services.elasticache.model.NotificationConfiguration? = builder.notificationConfiguration
    /**
     * The number of cache nodes in the cluster.
     *
     * For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.
     */
    public val numCacheNodes: kotlin.Int? = builder.numCacheNodes
    /**
     * A group of settings that are applied to the cluster in the future, or that are currently being applied.
     */
    public val pendingModifiedValues: aws.sdk.kotlin.services.elasticache.model.PendingModifiedValues? = builder.pendingModifiedValues
    /**
     * The name of the Availability Zone in which the cluster is located or "Multiple" if the cache nodes are located in different Availability Zones.
     */
    public val preferredAvailabilityZone: kotlin.String? = builder.preferredAvailabilityZone
    /**
     * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     *
     * Valid values for `ddd` are:
     * + `sun`
     * + `mon`
     * + `tue`
     * + `wed`
     * + `thu`
     * + `fri`
     * + `sat`
     *
     * Example: `sun:23:00-mon:01:30`
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * The outpost ARN in which the cache cluster is created.
     */
    public val preferredOutpostArn: kotlin.String? = builder.preferredOutpostArn
    /**
     * The replication group to which this cluster belongs. If this field is empty, the cluster is not associated with any replication group.
     */
    public val replicationGroupId: kotlin.String? = builder.replicationGroupId
    /**
     * A boolean value indicating whether log delivery is enabled for the replication group.
     */
    public val replicationGroupLogDeliveryEnabled: kotlin.Boolean = builder.replicationGroupLogDeliveryEnabled
    /**
     * A list of VPC Security Groups associated with the cluster.
     */
    public val securityGroups: List<SecurityGroupMembership>? = builder.securityGroups
    /**
     * The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For example, if you set `SnapshotRetentionLimit` to 5, a snapshot that was taken today is retained for 5 days before being deleted.
     *
     *  If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.
     */
    public val snapshotRetentionLimit: kotlin.Int? = builder.snapshotRetentionLimit
    /**
     * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your cluster.
     *
     * Example: `05:00-09:00`
     */
    public val snapshotWindow: kotlin.String? = builder.snapshotWindow
    /**
     * A flag that enables in-transit encryption when set to `true`.
     *
     * You cannot modify the value of `TransitEncryptionEnabled` after the cluster is created. To enable in-transit encryption on a cluster you must set `TransitEncryptionEnabled` to `true` when you create a cluster.
     *
     * **Required:** Only available when creating a replication group in an Amazon VPC using redis version `3.2.6`, `4.x` or later.
     *
     * Default: `false`
     */
    public val transitEncryptionEnabled: kotlin.Boolean? = builder.transitEncryptionEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.CacheCluster = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CacheCluster(")
        append("arn=$arn,")
        append("atRestEncryptionEnabled=$atRestEncryptionEnabled,")
        append("authTokenEnabled=$authTokenEnabled,")
        append("authTokenLastModifiedDate=$authTokenLastModifiedDate,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("cacheClusterCreateTime=$cacheClusterCreateTime,")
        append("cacheClusterId=$cacheClusterId,")
        append("cacheClusterStatus=$cacheClusterStatus,")
        append("cacheNodeType=$cacheNodeType,")
        append("cacheNodes=$cacheNodes,")
        append("cacheParameterGroup=$cacheParameterGroup,")
        append("cacheSecurityGroups=$cacheSecurityGroups,")
        append("cacheSubnetGroupName=$cacheSubnetGroupName,")
        append("clientDownloadLandingPage=$clientDownloadLandingPage,")
        append("configurationEndpoint=$configurationEndpoint,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("logDeliveryConfigurations=$logDeliveryConfigurations,")
        append("notificationConfiguration=$notificationConfiguration,")
        append("numCacheNodes=$numCacheNodes,")
        append("pendingModifiedValues=$pendingModifiedValues,")
        append("preferredAvailabilityZone=$preferredAvailabilityZone,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("preferredOutpostArn=$preferredOutpostArn,")
        append("replicationGroupId=$replicationGroupId,")
        append("replicationGroupLogDeliveryEnabled=$replicationGroupLogDeliveryEnabled,")
        append("securityGroups=$securityGroups,")
        append("snapshotRetentionLimit=$snapshotRetentionLimit,")
        append("snapshotWindow=$snapshotWindow,")
        append("transitEncryptionEnabled=$transitEncryptionEnabled)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (atRestEncryptionEnabled?.hashCode() ?: 0)
        result = 31 * result + (authTokenEnabled?.hashCode() ?: 0)
        result = 31 * result + (authTokenLastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (autoMinorVersionUpgrade.hashCode())
        result = 31 * result + (cacheClusterCreateTime?.hashCode() ?: 0)
        result = 31 * result + (cacheClusterId?.hashCode() ?: 0)
        result = 31 * result + (cacheClusterStatus?.hashCode() ?: 0)
        result = 31 * result + (cacheNodeType?.hashCode() ?: 0)
        result = 31 * result + (cacheNodes?.hashCode() ?: 0)
        result = 31 * result + (cacheParameterGroup?.hashCode() ?: 0)
        result = 31 * result + (cacheSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (cacheSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (clientDownloadLandingPage?.hashCode() ?: 0)
        result = 31 * result + (configurationEndpoint?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (logDeliveryConfigurations?.hashCode() ?: 0)
        result = 31 * result + (notificationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (numCacheNodes ?: 0)
        result = 31 * result + (pendingModifiedValues?.hashCode() ?: 0)
        result = 31 * result + (preferredAvailabilityZone?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredOutpostArn?.hashCode() ?: 0)
        result = 31 * result + (replicationGroupId?.hashCode() ?: 0)
        result = 31 * result + (replicationGroupLogDeliveryEnabled.hashCode())
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (snapshotRetentionLimit ?: 0)
        result = 31 * result + (snapshotWindow?.hashCode() ?: 0)
        result = 31 * result + (transitEncryptionEnabled?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CacheCluster

        if (arn != other.arn) return false
        if (atRestEncryptionEnabled != other.atRestEncryptionEnabled) return false
        if (authTokenEnabled != other.authTokenEnabled) return false
        if (authTokenLastModifiedDate != other.authTokenLastModifiedDate) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (cacheClusterCreateTime != other.cacheClusterCreateTime) return false
        if (cacheClusterId != other.cacheClusterId) return false
        if (cacheClusterStatus != other.cacheClusterStatus) return false
        if (cacheNodeType != other.cacheNodeType) return false
        if (cacheNodes != other.cacheNodes) return false
        if (cacheParameterGroup != other.cacheParameterGroup) return false
        if (cacheSecurityGroups != other.cacheSecurityGroups) return false
        if (cacheSubnetGroupName != other.cacheSubnetGroupName) return false
        if (clientDownloadLandingPage != other.clientDownloadLandingPage) return false
        if (configurationEndpoint != other.configurationEndpoint) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (logDeliveryConfigurations != other.logDeliveryConfigurations) return false
        if (notificationConfiguration != other.notificationConfiguration) return false
        if (numCacheNodes != other.numCacheNodes) return false
        if (pendingModifiedValues != other.pendingModifiedValues) return false
        if (preferredAvailabilityZone != other.preferredAvailabilityZone) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (preferredOutpostArn != other.preferredOutpostArn) return false
        if (replicationGroupId != other.replicationGroupId) return false
        if (replicationGroupLogDeliveryEnabled != other.replicationGroupLogDeliveryEnabled) return false
        if (securityGroups != other.securityGroups) return false
        if (snapshotRetentionLimit != other.snapshotRetentionLimit) return false
        if (snapshotWindow != other.snapshotWindow) return false
        if (transitEncryptionEnabled != other.transitEncryptionEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.CacheCluster = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN (Amazon Resource Name) of the cache cluster.
         */
        public var arn: kotlin.String? = null
        /**
         * A flag that enables encryption at-rest when set to `true`.
         *
         * You cannot modify the value of `AtRestEncryptionEnabled` after the cluster is created. To enable at-rest encryption on a cluster you must set `AtRestEncryptionEnabled` to `true` when you create a cluster.
         *
         * **Required:** Only available when creating a replication group in an Amazon VPC using redis version `3.2.6`, `4.x` or later.
         *
         * Default: `false`
         */
        public var atRestEncryptionEnabled: kotlin.Boolean? = null
        /**
         * A flag that enables using an `AuthToken` (password) when issuing Redis commands.
         *
         * Default: `false`
         */
        public var authTokenEnabled: kotlin.Boolean? = null
        /**
         * The date the auth token was last modified
         */
        public var authTokenLastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean = false
        /**
         * The date and time when the cluster was created.
         */
        public var cacheClusterCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user-supplied identifier of the cluster. This identifier is a unique key that identifies a cluster.
         */
        public var cacheClusterId: kotlin.String? = null
        /**
         * The current state of this cluster, one of the following values: `available`, `creating`, `deleted`, `deleting`, `incompatible-network`, `modifying`, `rebooting cluster nodes`, `restore-failed`, or `snapshotting`.
         */
        public var cacheClusterStatus: kotlin.String? = null
        /**
         * The name of the compute and memory capacity node type for the cluster.
         *
         * The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.
         * + General purpose:
         *    + Current generation: **M6g node types:** (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): `cache.m6g.large`, `cache.m6g.xlarge`, `cache.m6g.2xlarge`, `cache.m6g.4xlarge`, `cache.m6g.8xlarge`, `cache.m6g.12xlarge`, `cache.m6g.16xlarge`For region availability, see [Supported Node Types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)**M5 node types:**`cache.m5.large`, `cache.m5.xlarge`, `cache.m5.2xlarge`, `cache.m5.4xlarge`, `cache.m5.12xlarge`, `cache.m5.24xlarge`**M4 node types:**`cache.m4.large`, `cache.m4.xlarge`, `cache.m4.2xlarge`, `cache.m4.4xlarge`, `cache.m4.10xlarge`**T4g node types** (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): `cache.t4g.micro`, `cache.t4g.small`, `cache.t4g.medium`**T3 node types:**`cache.t3.micro`, `cache.t3.small`, `cache.t3.medium`**T2 node types:**`cache.t2.micro`, `cache.t2.small`, `cache.t2.medium`
         *    + Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)**T1 node types:**`cache.t1.micro`**M1 node types:**`cache.m1.small`, `cache.m1.medium`, `cache.m1.large`, `cache.m1.xlarge`**M3 node types:**`cache.m3.medium`, `cache.m3.large`, `cache.m3.xlarge`, `cache.m3.2xlarge`
         * + Compute optimized:
         *    + Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)**C1 node types:**`cache.c1.xlarge`
         * + Memory optimized with data tiering:
         *    + Current generation: **R6gd node types** (available only for Redis engine version 6.2 onward).`cache.r6gd.xlarge`, `cache.r6gd.2xlarge`, `cache.r6gd.4xlarge`, `cache.r6gd.8xlarge`, `cache.r6gd.12xlarge`, `cache.r6gd.16xlarge`
         * + Memory optimized:
         *    + Current generation: **R6g node types** (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).`cache.r6g.large`, `cache.r6g.xlarge`, `cache.r6g.2xlarge`, `cache.r6g.4xlarge`, `cache.r6g.8xlarge`, `cache.r6g.12xlarge`, `cache.r6g.16xlarge`For region availability, see [Supported Node Types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)**R5 node types:**`cache.r5.large`, `cache.r5.xlarge`, `cache.r5.2xlarge`, `cache.r5.4xlarge`, `cache.r5.12xlarge`, `cache.r5.24xlarge`**R4 node types:**`cache.r4.large`, `cache.r4.xlarge`, `cache.r4.2xlarge`, `cache.r4.4xlarge`, `cache.r4.8xlarge`, `cache.r4.16xlarge`
         *    + Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)**M2 node types:**`cache.m2.xlarge`, `cache.m2.2xlarge`, `cache.m2.4xlarge`**R3 node types:**`cache.r3.large`, `cache.r3.xlarge`, `cache.r3.2xlarge`, `cache.r3.4xlarge`, `cache.r3.8xlarge`
         *
         * **Additional node type info**
         * + All current generation instance types are created in Amazon VPC by default.
         * + Redis append-only files (AOF) are not supported for T1 or T2 instances.
         * + Redis Multi-AZ with automatic failover is not supported on T1 instances.
         * + Redis configuration variables `appendonly` and `appendfsync` are not supported on Redis version 2.8.22 and later.
         */
        public var cacheNodeType: kotlin.String? = null
        /**
         * A list of cache nodes that are members of the cluster.
         */
        public var cacheNodes: List<CacheNode>? = null
        /**
         * Status of the cache parameter group.
         */
        public var cacheParameterGroup: aws.sdk.kotlin.services.elasticache.model.CacheParameterGroupStatus? = null
        /**
         * A list of cache security group elements, composed of name and status sub-elements.
         */
        public var cacheSecurityGroups: List<CacheSecurityGroupMembership>? = null
        /**
         * The name of the cache subnet group associated with the cluster.
         */
        public var cacheSubnetGroupName: kotlin.String? = null
        /**
         * The URL of the web page where you can download the latest ElastiCache client library.
         */
        public var clientDownloadLandingPage: kotlin.String? = null
        /**
         * Represents a Memcached cluster endpoint which can be used by an application to connect to any node in the cluster. The configuration endpoint will always have `.cfg` in it.
         *
         * Example: `mem-3.9dvc4r<u>.cfg</u>.usw2.cache.amazonaws.com:11211`
         */
        public var configurationEndpoint: aws.sdk.kotlin.services.elasticache.model.Endpoint? = null
        /**
         * The name of the cache engine (`memcached` or `redis`) to be used for this cluster.
         */
        public var engine: kotlin.String? = null
        /**
         * The version of the cache engine that is used in this cluster.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * Returns the destination, format and type of the logs.
         */
        public var logDeliveryConfigurations: List<LogDeliveryConfiguration>? = null
        /**
         * Describes a notification topic and its status. Notification topics are used for publishing ElastiCache events to subscribers using Amazon Simple Notification Service (SNS).
         */
        public var notificationConfiguration: aws.sdk.kotlin.services.elasticache.model.NotificationConfiguration? = null
        /**
         * The number of cache nodes in the cluster.
         *
         * For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.
         */
        public var numCacheNodes: kotlin.Int? = null
        /**
         * A group of settings that are applied to the cluster in the future, or that are currently being applied.
         */
        public var pendingModifiedValues: aws.sdk.kotlin.services.elasticache.model.PendingModifiedValues? = null
        /**
         * The name of the Availability Zone in which the cluster is located or "Multiple" if the cache nodes are located in different Availability Zones.
         */
        public var preferredAvailabilityZone: kotlin.String? = null
        /**
         * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
         *
         * Valid values for `ddd` are:
         * + `sun`
         * + `mon`
         * + `tue`
         * + `wed`
         * + `thu`
         * + `fri`
         * + `sat`
         *
         * Example: `sun:23:00-mon:01:30`
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * The outpost ARN in which the cache cluster is created.
         */
        public var preferredOutpostArn: kotlin.String? = null
        /**
         * The replication group to which this cluster belongs. If this field is empty, the cluster is not associated with any replication group.
         */
        public var replicationGroupId: kotlin.String? = null
        /**
         * A boolean value indicating whether log delivery is enabled for the replication group.
         */
        public var replicationGroupLogDeliveryEnabled: kotlin.Boolean = false
        /**
         * A list of VPC Security Groups associated with the cluster.
         */
        public var securityGroups: List<SecurityGroupMembership>? = null
        /**
         * The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For example, if you set `SnapshotRetentionLimit` to 5, a snapshot that was taken today is retained for 5 days before being deleted.
         *
         *  If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.
         */
        public var snapshotRetentionLimit: kotlin.Int? = null
        /**
         * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your cluster.
         *
         * Example: `05:00-09:00`
         */
        public var snapshotWindow: kotlin.String? = null
        /**
         * A flag that enables in-transit encryption when set to `true`.
         *
         * You cannot modify the value of `TransitEncryptionEnabled` after the cluster is created. To enable in-transit encryption on a cluster you must set `TransitEncryptionEnabled` to `true` when you create a cluster.
         *
         * **Required:** Only available when creating a replication group in an Amazon VPC using redis version `3.2.6`, `4.x` or later.
         *
         * Default: `false`
         */
        public var transitEncryptionEnabled: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.CacheCluster) : this() {
            this.arn = x.arn
            this.atRestEncryptionEnabled = x.atRestEncryptionEnabled
            this.authTokenEnabled = x.authTokenEnabled
            this.authTokenLastModifiedDate = x.authTokenLastModifiedDate
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.cacheClusterCreateTime = x.cacheClusterCreateTime
            this.cacheClusterId = x.cacheClusterId
            this.cacheClusterStatus = x.cacheClusterStatus
            this.cacheNodeType = x.cacheNodeType
            this.cacheNodes = x.cacheNodes
            this.cacheParameterGroup = x.cacheParameterGroup
            this.cacheSecurityGroups = x.cacheSecurityGroups
            this.cacheSubnetGroupName = x.cacheSubnetGroupName
            this.clientDownloadLandingPage = x.clientDownloadLandingPage
            this.configurationEndpoint = x.configurationEndpoint
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.logDeliveryConfigurations = x.logDeliveryConfigurations
            this.notificationConfiguration = x.notificationConfiguration
            this.numCacheNodes = x.numCacheNodes
            this.pendingModifiedValues = x.pendingModifiedValues
            this.preferredAvailabilityZone = x.preferredAvailabilityZone
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.preferredOutpostArn = x.preferredOutpostArn
            this.replicationGroupId = x.replicationGroupId
            this.replicationGroupLogDeliveryEnabled = x.replicationGroupLogDeliveryEnabled
            this.securityGroups = x.securityGroups
            this.snapshotRetentionLimit = x.snapshotRetentionLimit
            this.snapshotWindow = x.snapshotWindow
            this.transitEncryptionEnabled = x.transitEncryptionEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.CacheCluster = CacheCluster(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticache.model.CacheParameterGroupStatus] inside the given [block]
         */
        public fun cacheParameterGroup(block: aws.sdk.kotlin.services.elasticache.model.CacheParameterGroupStatus.Builder.() -> kotlin.Unit) {
            this.cacheParameterGroup = aws.sdk.kotlin.services.elasticache.model.CacheParameterGroupStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticache.model.Endpoint] inside the given [block]
         */
        public fun configurationEndpoint(block: aws.sdk.kotlin.services.elasticache.model.Endpoint.Builder.() -> kotlin.Unit) {
            this.configurationEndpoint = aws.sdk.kotlin.services.elasticache.model.Endpoint.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticache.model.NotificationConfiguration] inside the given [block]
         */
        public fun notificationConfiguration(block: aws.sdk.kotlin.services.elasticache.model.NotificationConfiguration.Builder.() -> kotlin.Unit) {
            this.notificationConfiguration = aws.sdk.kotlin.services.elasticache.model.NotificationConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticache.model.PendingModifiedValues] inside the given [block]
         */
        public fun pendingModifiedValues(block: aws.sdk.kotlin.services.elasticache.model.PendingModifiedValues.Builder.() -> kotlin.Unit) {
            this.pendingModifiedValues = aws.sdk.kotlin.services.elasticache.model.PendingModifiedValues.invoke(block)
        }
    }
}
