// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model



/**
 * Node group (shard) configuration options when adding or removing replicas. Each node group (shard) configuration has the following members: NodeGroupId, NewReplicaCount, and PreferredAvailabilityZones.
 */
public class ConfigureShard private constructor(builder: Builder) {
    /**
     * The number of replicas you want in this node group at the end of this operation. The maximum value for `NewReplicaCount` is 5. The minimum value depends upon the type of Redis replication group you are working with.
     *
     * The minimum number of replicas in a shard or replication group is:
     * + Redis (cluster mode disabled)
     *    + If Multi-AZ: 1
     *    + If Multi-AZ: 0
     * + Redis (cluster mode enabled): 0 (though you will not be able to failover to a replica if your primary node fails)
     */
    public val newReplicaCount: kotlin.Int = builder.newReplicaCount
    /**
     * The 4-digit id for the node group you are configuring. For Redis (cluster mode disabled) replication groups, the node group id is always 0001. To find a Redis (cluster mode enabled)'s node group's (shard's) id, see [Finding a Shard's Id](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/shard-find-id.html).
     */
    public val nodeGroupId: kotlin.String? = builder.nodeGroupId
    /**
     * A list of `PreferredAvailabilityZone` strings that specify which availability zones the replication group's nodes are to be in. The nummber of `PreferredAvailabilityZone` values must equal the value of `NewReplicaCount` plus 1 to account for the primary node. If this member of `ReplicaConfiguration` is omitted, ElastiCache for Redis selects the availability zone for each of the replicas.
     */
    public val preferredAvailabilityZones: List<String>? = builder.preferredAvailabilityZones
    /**
     * The outpost ARNs in which the cache cluster is created.
     */
    public val preferredOutpostArns: List<String>? = builder.preferredOutpostArns

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.ConfigureShard = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConfigureShard(")
        append("newReplicaCount=$newReplicaCount,")
        append("nodeGroupId=$nodeGroupId,")
        append("preferredAvailabilityZones=$preferredAvailabilityZones,")
        append("preferredOutpostArns=$preferredOutpostArns)")
    }

    override fun hashCode(): kotlin.Int {
        var result = newReplicaCount
        result = 31 * result + (nodeGroupId?.hashCode() ?: 0)
        result = 31 * result + (preferredAvailabilityZones?.hashCode() ?: 0)
        result = 31 * result + (preferredOutpostArns?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConfigureShard

        if (newReplicaCount != other.newReplicaCount) return false
        if (nodeGroupId != other.nodeGroupId) return false
        if (preferredAvailabilityZones != other.preferredAvailabilityZones) return false
        if (preferredOutpostArns != other.preferredOutpostArns) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.ConfigureShard = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of replicas you want in this node group at the end of this operation. The maximum value for `NewReplicaCount` is 5. The minimum value depends upon the type of Redis replication group you are working with.
         *
         * The minimum number of replicas in a shard or replication group is:
         * + Redis (cluster mode disabled)
         *    + If Multi-AZ: 1
         *    + If Multi-AZ: 0
         * + Redis (cluster mode enabled): 0 (though you will not be able to failover to a replica if your primary node fails)
         */
        public var newReplicaCount: kotlin.Int = 0
        /**
         * The 4-digit id for the node group you are configuring. For Redis (cluster mode disabled) replication groups, the node group id is always 0001. To find a Redis (cluster mode enabled)'s node group's (shard's) id, see [Finding a Shard's Id](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/shard-find-id.html).
         */
        public var nodeGroupId: kotlin.String? = null
        /**
         * A list of `PreferredAvailabilityZone` strings that specify which availability zones the replication group's nodes are to be in. The nummber of `PreferredAvailabilityZone` values must equal the value of `NewReplicaCount` plus 1 to account for the primary node. If this member of `ReplicaConfiguration` is omitted, ElastiCache for Redis selects the availability zone for each of the replicas.
         */
        public var preferredAvailabilityZones: List<String>? = null
        /**
         * The outpost ARNs in which the cache cluster is created.
         */
        public var preferredOutpostArns: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.ConfigureShard) : this() {
            this.newReplicaCount = x.newReplicaCount
            this.nodeGroupId = x.nodeGroupId
            this.preferredAvailabilityZones = x.preferredAvailabilityZones
            this.preferredOutpostArns = x.preferredOutpostArns
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.ConfigureShard = ConfigureShard(this)
    }
}
