// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model



public class DecreaseReplicaCountRequest private constructor(builder: Builder) {
    /**
     * If `True`, the number of replica nodes is decreased immediately. `ApplyImmediately=False` is not currently supported.
     */
    public val applyImmediately: kotlin.Boolean = builder.applyImmediately
    /**
     * The number of read replica nodes you want at the completion of this operation. For Redis (cluster mode disabled) replication groups, this is the number of replica nodes in the replication group. For Redis (cluster mode enabled) replication groups, this is the number of replica nodes in each of the replication group's node groups.
     *
     * The minimum number of replicas in a shard or replication group is:
     * + Redis (cluster mode disabled)
     *    + If Multi-AZ is enabled: 1
     *    + If Multi-AZ is not enabled: 0
     * + Redis (cluster mode enabled): 0 (though you will not be able to failover to a replica if your primary node fails)
     */
    public val newReplicaCount: kotlin.Int? = builder.newReplicaCount
    /**
     * A list of `ConfigureShard` objects that can be used to configure each shard in a Redis (cluster mode enabled) replication group. The `ConfigureShard` has three members: `NewReplicaCount`, `NodeGroupId`, and `PreferredAvailabilityZones`.
     */
    public val replicaConfiguration: List<ConfigureShard>? = builder.replicaConfiguration
    /**
     * A list of the node ids to remove from the replication group or node group (shard).
     */
    public val replicasToRemove: List<String>? = builder.replicasToRemove
    /**
     * The id of the replication group from which you want to remove replica nodes.
     */
    public val replicationGroupId: kotlin.String? = builder.replicationGroupId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.DecreaseReplicaCountRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DecreaseReplicaCountRequest(")
        append("applyImmediately=$applyImmediately,")
        append("newReplicaCount=$newReplicaCount,")
        append("replicaConfiguration=$replicaConfiguration,")
        append("replicasToRemove=$replicasToRemove,")
        append("replicationGroupId=$replicationGroupId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applyImmediately.hashCode()
        result = 31 * result + (newReplicaCount ?: 0)
        result = 31 * result + (replicaConfiguration?.hashCode() ?: 0)
        result = 31 * result + (replicasToRemove?.hashCode() ?: 0)
        result = 31 * result + (replicationGroupId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DecreaseReplicaCountRequest

        if (applyImmediately != other.applyImmediately) return false
        if (newReplicaCount != other.newReplicaCount) return false
        if (replicaConfiguration != other.replicaConfiguration) return false
        if (replicasToRemove != other.replicasToRemove) return false
        if (replicationGroupId != other.replicationGroupId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.DecreaseReplicaCountRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If `True`, the number of replica nodes is decreased immediately. `ApplyImmediately=False` is not currently supported.
         */
        public var applyImmediately: kotlin.Boolean = false
        /**
         * The number of read replica nodes you want at the completion of this operation. For Redis (cluster mode disabled) replication groups, this is the number of replica nodes in the replication group. For Redis (cluster mode enabled) replication groups, this is the number of replica nodes in each of the replication group's node groups.
         *
         * The minimum number of replicas in a shard or replication group is:
         * + Redis (cluster mode disabled)
         *    + If Multi-AZ is enabled: 1
         *    + If Multi-AZ is not enabled: 0
         * + Redis (cluster mode enabled): 0 (though you will not be able to failover to a replica if your primary node fails)
         */
        public var newReplicaCount: kotlin.Int? = null
        /**
         * A list of `ConfigureShard` objects that can be used to configure each shard in a Redis (cluster mode enabled) replication group. The `ConfigureShard` has three members: `NewReplicaCount`, `NodeGroupId`, and `PreferredAvailabilityZones`.
         */
        public var replicaConfiguration: List<ConfigureShard>? = null
        /**
         * A list of the node ids to remove from the replication group or node group (shard).
         */
        public var replicasToRemove: List<String>? = null
        /**
         * The id of the replication group from which you want to remove replica nodes.
         */
        public var replicationGroupId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.DecreaseReplicaCountRequest) : this() {
            this.applyImmediately = x.applyImmediately
            this.newReplicaCount = x.newReplicaCount
            this.replicaConfiguration = x.replicaConfiguration
            this.replicasToRemove = x.replicasToRemove
            this.replicationGroupId = x.replicationGroupId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.DecreaseReplicaCountRequest = DecreaseReplicaCountRequest(this)
    }
}
