// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model



/**
 * Represents the input of a `DescribeSnapshotsMessage` operation.
 */
public class DescribeSnapshotsRequest private constructor(builder: Builder) {
    /**
     * A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that specific cluster are described.
     */
    public val cacheClusterId: kotlin.String? = builder.cacheClusterId
    /**
     * An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a marker is included in the response so that the remaining results can be retrieved.
     *
     * Default: 50
     *
     * Constraints: minimum 20; maximum 50.
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * A user-supplied replication group identifier. If this parameter is specified, only snapshots associated with that specific replication group are described.
     */
    public val replicationGroupId: kotlin.String? = builder.replicationGroupId
    /**
     * A Boolean value which if true, the node group (shard) configuration is included in the snapshot description.
     */
    public val showNodeGroupConfig: kotlin.Boolean? = builder.showNodeGroupConfig
    /**
     * A user-supplied name of the snapshot. If this parameter is specified, only this snapshot are described.
     */
    public val snapshotName: kotlin.String? = builder.snapshotName
    /**
     * If set to `system`, the output shows snapshots that were automatically created by ElastiCache. If set to `user` the output shows snapshots that were manually created. If omitted, the output shows both automatically and manually created snapshots.
     */
    public val snapshotSource: kotlin.String? = builder.snapshotSource

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.DescribeSnapshotsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeSnapshotsRequest(")
        append("cacheClusterId=$cacheClusterId,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("replicationGroupId=$replicationGroupId,")
        append("showNodeGroupConfig=$showNodeGroupConfig,")
        append("snapshotName=$snapshotName,")
        append("snapshotSource=$snapshotSource)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheClusterId?.hashCode() ?: 0
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (replicationGroupId?.hashCode() ?: 0)
        result = 31 * result + (showNodeGroupConfig?.hashCode() ?: 0)
        result = 31 * result + (snapshotName?.hashCode() ?: 0)
        result = 31 * result + (snapshotSource?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeSnapshotsRequest

        if (cacheClusterId != other.cacheClusterId) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (replicationGroupId != other.replicationGroupId) return false
        if (showNodeGroupConfig != other.showNodeGroupConfig) return false
        if (snapshotName != other.snapshotName) return false
        if (snapshotSource != other.snapshotSource) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.DescribeSnapshotsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that specific cluster are described.
         */
        public var cacheClusterId: kotlin.String? = null
        /**
         * An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a marker is included in the response so that the remaining results can be retrieved.
         *
         * Default: 50
         *
         * Constraints: minimum 20; maximum 50.
         */
        public var maxRecords: kotlin.Int? = null
        /**
         * A user-supplied replication group identifier. If this parameter is specified, only snapshots associated with that specific replication group are described.
         */
        public var replicationGroupId: kotlin.String? = null
        /**
         * A Boolean value which if true, the node group (shard) configuration is included in the snapshot description.
         */
        public var showNodeGroupConfig: kotlin.Boolean? = null
        /**
         * A user-supplied name of the snapshot. If this parameter is specified, only this snapshot are described.
         */
        public var snapshotName: kotlin.String? = null
        /**
         * If set to `system`, the output shows snapshots that were automatically created by ElastiCache. If set to `user` the output shows snapshots that were manually created. If omitted, the output shows both automatically and manually created snapshots.
         */
        public var snapshotSource: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.DescribeSnapshotsRequest) : this() {
            this.cacheClusterId = x.cacheClusterId
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.replicationGroupId = x.replicationGroupId
            this.showNodeGroupConfig = x.showNodeGroupConfig
            this.snapshotName = x.snapshotName
            this.snapshotSource = x.snapshotSource
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.DescribeSnapshotsRequest = DescribeSnapshotsRequest(this)
    }
}
