// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model



/**
 * Represents a single node within a node group (shard).
 */
public class NodeGroupMember private constructor(builder: Builder) {
    /**
     * The ID of the cluster to which the node belongs.
     */
    public val cacheClusterId: kotlin.String? = builder.cacheClusterId
    /**
     * The ID of the node within its cluster. A node ID is a numeric identifier (0001, 0002, etc.).
     */
    public val cacheNodeId: kotlin.String? = builder.cacheNodeId
    /**
     * The role that is currently assigned to the node - `primary` or `replica`. This member is only applicable for Redis (cluster mode disabled) replication groups.
     */
    public val currentRole: kotlin.String? = builder.currentRole
    /**
     * The name of the Availability Zone in which the node is located.
     */
    public val preferredAvailabilityZone: kotlin.String? = builder.preferredAvailabilityZone
    /**
     * The outpost ARN of the node group member.
     */
    public val preferredOutpostArn: kotlin.String? = builder.preferredOutpostArn
    /**
     * The information required for client programs to connect to a node for read operations. The read endpoint is only applicable on Redis (cluster mode disabled) clusters.
     */
    public val readEndpoint: aws.sdk.kotlin.services.elasticache.model.Endpoint? = builder.readEndpoint

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.NodeGroupMember = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NodeGroupMember(")
        append("cacheClusterId=$cacheClusterId,")
        append("cacheNodeId=$cacheNodeId,")
        append("currentRole=$currentRole,")
        append("preferredAvailabilityZone=$preferredAvailabilityZone,")
        append("preferredOutpostArn=$preferredOutpostArn,")
        append("readEndpoint=$readEndpoint)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheClusterId?.hashCode() ?: 0
        result = 31 * result + (cacheNodeId?.hashCode() ?: 0)
        result = 31 * result + (currentRole?.hashCode() ?: 0)
        result = 31 * result + (preferredAvailabilityZone?.hashCode() ?: 0)
        result = 31 * result + (preferredOutpostArn?.hashCode() ?: 0)
        result = 31 * result + (readEndpoint?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NodeGroupMember

        if (cacheClusterId != other.cacheClusterId) return false
        if (cacheNodeId != other.cacheNodeId) return false
        if (currentRole != other.currentRole) return false
        if (preferredAvailabilityZone != other.preferredAvailabilityZone) return false
        if (preferredOutpostArn != other.preferredOutpostArn) return false
        if (readEndpoint != other.readEndpoint) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.NodeGroupMember = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the cluster to which the node belongs.
         */
        public var cacheClusterId: kotlin.String? = null
        /**
         * The ID of the node within its cluster. A node ID is a numeric identifier (0001, 0002, etc.).
         */
        public var cacheNodeId: kotlin.String? = null
        /**
         * The role that is currently assigned to the node - `primary` or `replica`. This member is only applicable for Redis (cluster mode disabled) replication groups.
         */
        public var currentRole: kotlin.String? = null
        /**
         * The name of the Availability Zone in which the node is located.
         */
        public var preferredAvailabilityZone: kotlin.String? = null
        /**
         * The outpost ARN of the node group member.
         */
        public var preferredOutpostArn: kotlin.String? = null
        /**
         * The information required for client programs to connect to a node for read operations. The read endpoint is only applicable on Redis (cluster mode disabled) clusters.
         */
        public var readEndpoint: aws.sdk.kotlin.services.elasticache.model.Endpoint? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.NodeGroupMember) : this() {
            this.cacheClusterId = x.cacheClusterId
            this.cacheNodeId = x.cacheNodeId
            this.currentRole = x.currentRole
            this.preferredAvailabilityZone = x.preferredAvailabilityZone
            this.preferredOutpostArn = x.preferredOutpostArn
            this.readEndpoint = x.readEndpoint
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.NodeGroupMember = NodeGroupMember(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticache.model.Endpoint] inside the given [block]
         */
        public fun readEndpoint(block: aws.sdk.kotlin.services.elasticache.model.Endpoint.Builder.() -> kotlin.Unit) {
            this.readEndpoint = aws.sdk.kotlin.services.elasticache.model.Endpoint.invoke(block)
        }
    }
}
