// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model



/**
 * Describes an individual setting that controls some aspect of ElastiCache behavior.
 */
public class Parameter private constructor(builder: Builder) {
    /**
     * The valid range of values for the parameter.
     */
    public val allowedValues: kotlin.String? = builder.allowedValues
    /**
     * Indicates whether a change to the parameter is applied immediately or requires a reboot for the change to be applied. You can force a reboot or wait until the next maintenance window's reboot. For more information, see [Rebooting a Cluster](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html).
     */
    public val changeType: aws.sdk.kotlin.services.elasticache.model.ChangeType? = builder.changeType
    /**
     * The valid data type for the parameter.
     */
    public val dataType: kotlin.String? = builder.dataType
    /**
     * A description of the parameter.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Indicates whether (`true`) or not (`false`) the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed.
     */
    public val isModifiable: kotlin.Boolean = builder.isModifiable
    /**
     * The earliest cache engine version to which the parameter can apply.
     */
    public val minimumEngineVersion: kotlin.String? = builder.minimumEngineVersion
    /**
     * The name of the parameter.
     */
    public val parameterName: kotlin.String? = builder.parameterName
    /**
     * The value of the parameter.
     */
    public val parameterValue: kotlin.String? = builder.parameterValue
    /**
     * The source of the parameter.
     */
    public val source: kotlin.String? = builder.source

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.Parameter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Parameter(")
        append("allowedValues=$allowedValues,")
        append("changeType=$changeType,")
        append("dataType=$dataType,")
        append("description=$description,")
        append("isModifiable=$isModifiable,")
        append("minimumEngineVersion=$minimumEngineVersion,")
        append("parameterName=$parameterName,")
        append("parameterValue=$parameterValue,")
        append("source=$source)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedValues?.hashCode() ?: 0
        result = 31 * result + (changeType?.hashCode() ?: 0)
        result = 31 * result + (dataType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (isModifiable.hashCode())
        result = 31 * result + (minimumEngineVersion?.hashCode() ?: 0)
        result = 31 * result + (parameterName?.hashCode() ?: 0)
        result = 31 * result + (parameterValue?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Parameter

        if (allowedValues != other.allowedValues) return false
        if (changeType != other.changeType) return false
        if (dataType != other.dataType) return false
        if (description != other.description) return false
        if (isModifiable != other.isModifiable) return false
        if (minimumEngineVersion != other.minimumEngineVersion) return false
        if (parameterName != other.parameterName) return false
        if (parameterValue != other.parameterValue) return false
        if (source != other.source) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.Parameter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The valid range of values for the parameter.
         */
        public var allowedValues: kotlin.String? = null
        /**
         * Indicates whether a change to the parameter is applied immediately or requires a reboot for the change to be applied. You can force a reboot or wait until the next maintenance window's reboot. For more information, see [Rebooting a Cluster](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html).
         */
        public var changeType: aws.sdk.kotlin.services.elasticache.model.ChangeType? = null
        /**
         * The valid data type for the parameter.
         */
        public var dataType: kotlin.String? = null
        /**
         * A description of the parameter.
         */
        public var description: kotlin.String? = null
        /**
         * Indicates whether (`true`) or not (`false`) the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed.
         */
        public var isModifiable: kotlin.Boolean = false
        /**
         * The earliest cache engine version to which the parameter can apply.
         */
        public var minimumEngineVersion: kotlin.String? = null
        /**
         * The name of the parameter.
         */
        public var parameterName: kotlin.String? = null
        /**
         * The value of the parameter.
         */
        public var parameterValue: kotlin.String? = null
        /**
         * The source of the parameter.
         */
        public var source: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.Parameter) : this() {
            this.allowedValues = x.allowedValues
            this.changeType = x.changeType
            this.dataType = x.dataType
            this.description = x.description
            this.isModifiable = x.isModifiable
            this.minimumEngineVersion = x.minimumEngineVersion
            this.parameterName = x.parameterName
            this.parameterValue = x.parameterValue
            this.source = x.source
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.Parameter = Parameter(this)
    }
}
