// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.transform

import aws.sdk.kotlin.services.elasticache.model.CopySnapshotRequest
import aws.sdk.kotlin.services.elasticache.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlCollectionName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CopySnapshotOperationSerializer: HttpSerialize<CopySnapshotRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CopySnapshotRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeCopySnapshotOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeCopySnapshotOperationBody(context: ExecutionContext, input: CopySnapshotRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("KmsKeyId"))
    val SOURCESNAPSHOTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("SourceSnapshotName"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Tags"), FormUrlCollectionName("Tag"))
    val TARGETBUCKET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("TargetBucket"))
    val TARGETSNAPSHOTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("TargetSnapshotName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("CopySnapshotMessage"))
        trait(QueryLiteral("Action", "CopySnapshot"))
        trait(QueryLiteral("Version", "2015-02-02"))
        field(KMSKEYID_DESCRIPTOR)
        field(SOURCESNAPSHOTNAME_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TARGETBUCKET_DESCRIPTOR)
        field(TARGETSNAPSHOTNAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.kmsKeyId?.let { field(KMSKEYID_DESCRIPTOR, it) }
        input.sourceSnapshotName?.let { field(SOURCESNAPSHOTNAME_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.targetBucket?.let { field(TARGETBUCKET_DESCRIPTOR, it) }
        input.targetSnapshotName?.let { field(TARGETSNAPSHOTNAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
