// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model



/**
 * Represents the input of a DescribeCacheClusters operation.
 */
class DescribeCacheClustersRequest private constructor(builder: Builder) {
    /**
     * The user-supplied cluster identifier. If this parameter is specified, only information
     * about that specific cluster is returned. This parameter isn't case sensitive.
     */
    val cacheClusterId: kotlin.String? = builder.cacheClusterId
    /**
     * An optional marker returned from a prior request.
     * Use this marker for pagination of results from this operation. If this
     * parameter is specified, the response includes only records beyond the marker, up to the
     * value specified by MaxRecords.
     */
    val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than the
     * specified MaxRecords value, a marker is included in the response so that
     * the remaining results can be retrieved.
     *
     * Default: 100
     * Constraints: minimum 20; maximum 100.
     */
    val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * An optional flag that can be included in the DescribeCacheCluster request
     * to show only nodes (API/CLI: clusters) that are not members of a replication group.
     * In practice, this mean Memcached and single node Redis clusters.
     */
    val showCacheClustersNotInReplicationGroups: kotlin.Boolean? = builder.showCacheClustersNotInReplicationGroups
    /**
     * An optional flag that can be included in the DescribeCacheCluster request
     * to retrieve information about the individual cache nodes.
     */
    val showCacheNodeInfo: kotlin.Boolean? = builder.showCacheNodeInfo

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.DescribeCacheClustersRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeCacheClustersRequest(")
        append("cacheClusterId=$cacheClusterId,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("showCacheClustersNotInReplicationGroups=$showCacheClustersNotInReplicationGroups,")
        append("showCacheNodeInfo=$showCacheNodeInfo)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheClusterId?.hashCode() ?: 0
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (showCacheClustersNotInReplicationGroups?.hashCode() ?: 0)
        result = 31 * result + (showCacheNodeInfo?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeCacheClustersRequest

        if (cacheClusterId != other.cacheClusterId) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (showCacheClustersNotInReplicationGroups != other.showCacheClustersNotInReplicationGroups) return false
        if (showCacheNodeInfo != other.showCacheNodeInfo) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.DescribeCacheClustersRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The user-supplied cluster identifier. If this parameter is specified, only information
         * about that specific cluster is returned. This parameter isn't case sensitive.
         */
        var cacheClusterId: kotlin.String? = null
        /**
         * An optional marker returned from a prior request.
         * Use this marker for pagination of results from this operation. If this
         * parameter is specified, the response includes only records beyond the marker, up to the
         * value specified by MaxRecords.
         */
        var marker: kotlin.String? = null
        /**
         * The maximum number of records to include in the response. If more records exist than the
         * specified MaxRecords value, a marker is included in the response so that
         * the remaining results can be retrieved.
         *
         * Default: 100
         * Constraints: minimum 20; maximum 100.
         */
        var maxRecords: kotlin.Int? = null
        /**
         * An optional flag that can be included in the DescribeCacheCluster request
         * to show only nodes (API/CLI: clusters) that are not members of a replication group.
         * In practice, this mean Memcached and single node Redis clusters.
         */
        var showCacheClustersNotInReplicationGroups: kotlin.Boolean? = null
        /**
         * An optional flag that can be included in the DescribeCacheCluster request
         * to retrieve information about the individual cache nodes.
         */
        var showCacheNodeInfo: kotlin.Boolean? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.DescribeCacheClustersRequest) : this() {
            this.cacheClusterId = x.cacheClusterId
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.showCacheClustersNotInReplicationGroups = x.showCacheClustersNotInReplicationGroups
            this.showCacheNodeInfo = x.showCacheNodeInfo
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.DescribeCacheClustersRequest = DescribeCacheClustersRequest(this)
    }
}
