// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model



/**
 * Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary
 * cluster automatically replicates updates to the secondary cluster.
 *
 *
 * The GlobalReplicationGroupIdSuffix represents the name of the Global datastore,
 * which is what you use to associate a secondary cluster.
 */
class GlobalReplicationGroup private constructor(builder: Builder) {
    /**
     * The ARN (Amazon Resource Name) of the global replication group.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * A flag that enables encryption at rest when set to true.
     * You cannot modify the value of AtRestEncryptionEnabled after the replication
     * group is created.
     * To enable encryption at rest on a replication group you must set AtRestEncryptionEnabled to
     * true when you create the replication group.
     *
     * Required:
     * Only available when creating a replication group in an Amazon VPC using redis version 3.2.6, 4.x or later.
     */
    val atRestEncryptionEnabled: kotlin.Boolean? = builder.atRestEncryptionEnabled
    /**
     * A flag that enables using an AuthToken (password)
     * when issuing Redis commands.
     * Default: false
     */
    val authTokenEnabled: kotlin.Boolean? = builder.authTokenEnabled
    /**
     * The cache node type of the Global datastore
     */
    val cacheNodeType: kotlin.String? = builder.cacheNodeType
    /**
     * A flag that indicates whether the Global datastore is cluster enabled.
     */
    val clusterEnabled: kotlin.Boolean? = builder.clusterEnabled
    /**
     * The Elasticache engine. For Redis only.
     */
    val engine: kotlin.String? = builder.engine
    /**
     * The Elasticache Redis engine version.
     */
    val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * Indicates the slot configuration and global identifier for each slice group.
     */
    val globalNodeGroups: List<GlobalNodeGroup>? = builder.globalNodeGroups
    /**
     * The optional description of the Global datastore
     */
    val globalReplicationGroupDescription: kotlin.String? = builder.globalReplicationGroupDescription
    /**
     * The name of the Global datastore
     */
    val globalReplicationGroupId: kotlin.String? = builder.globalReplicationGroupId
    /**
     * The replication groups that comprise the Global datastore.
     */
    val members: List<GlobalReplicationGroupMember>? = builder.members
    /**
     * The status of the Global datastore
     */
    val status: kotlin.String? = builder.status
    /**
     * A flag that enables in-transit encryption when set to true.
     *
     * You cannot modify the value of TransitEncryptionEnabled after the cluster is created. To enable in-transit encryption on a cluster you must set TransitEncryptionEnabled to true when you create a cluster.
     *
     * Required:
     * Only available when creating a replication group in an Amazon VPC using redis version 3.2.6, 4.x or later.
     */
    val transitEncryptionEnabled: kotlin.Boolean? = builder.transitEncryptionEnabled

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.GlobalReplicationGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GlobalReplicationGroup(")
        append("arn=$arn,")
        append("atRestEncryptionEnabled=$atRestEncryptionEnabled,")
        append("authTokenEnabled=$authTokenEnabled,")
        append("cacheNodeType=$cacheNodeType,")
        append("clusterEnabled=$clusterEnabled,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("globalNodeGroups=$globalNodeGroups,")
        append("globalReplicationGroupDescription=$globalReplicationGroupDescription,")
        append("globalReplicationGroupId=$globalReplicationGroupId,")
        append("members=$members,")
        append("status=$status,")
        append("transitEncryptionEnabled=$transitEncryptionEnabled)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (atRestEncryptionEnabled?.hashCode() ?: 0)
        result = 31 * result + (authTokenEnabled?.hashCode() ?: 0)
        result = 31 * result + (cacheNodeType?.hashCode() ?: 0)
        result = 31 * result + (clusterEnabled?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (globalNodeGroups?.hashCode() ?: 0)
        result = 31 * result + (globalReplicationGroupDescription?.hashCode() ?: 0)
        result = 31 * result + (globalReplicationGroupId?.hashCode() ?: 0)
        result = 31 * result + (members?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (transitEncryptionEnabled?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GlobalReplicationGroup

        if (arn != other.arn) return false
        if (atRestEncryptionEnabled != other.atRestEncryptionEnabled) return false
        if (authTokenEnabled != other.authTokenEnabled) return false
        if (cacheNodeType != other.cacheNodeType) return false
        if (clusterEnabled != other.clusterEnabled) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (globalNodeGroups != other.globalNodeGroups) return false
        if (globalReplicationGroupDescription != other.globalReplicationGroupDescription) return false
        if (globalReplicationGroupId != other.globalReplicationGroupId) return false
        if (members != other.members) return false
        if (status != other.status) return false
        if (transitEncryptionEnabled != other.transitEncryptionEnabled) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.GlobalReplicationGroup = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ARN (Amazon Resource Name) of the global replication group.
         */
        var arn: kotlin.String? = null
        /**
         * A flag that enables encryption at rest when set to true.
         * You cannot modify the value of AtRestEncryptionEnabled after the replication
         * group is created.
         * To enable encryption at rest on a replication group you must set AtRestEncryptionEnabled to
         * true when you create the replication group.
         *
         * Required:
         * Only available when creating a replication group in an Amazon VPC using redis version 3.2.6, 4.x or later.
         */
        var atRestEncryptionEnabled: kotlin.Boolean? = null
        /**
         * A flag that enables using an AuthToken (password)
         * when issuing Redis commands.
         * Default: false
         */
        var authTokenEnabled: kotlin.Boolean? = null
        /**
         * The cache node type of the Global datastore
         */
        var cacheNodeType: kotlin.String? = null
        /**
         * A flag that indicates whether the Global datastore is cluster enabled.
         */
        var clusterEnabled: kotlin.Boolean? = null
        /**
         * The Elasticache engine. For Redis only.
         */
        var engine: kotlin.String? = null
        /**
         * The Elasticache Redis engine version.
         */
        var engineVersion: kotlin.String? = null
        /**
         * Indicates the slot configuration and global identifier for each slice group.
         */
        var globalNodeGroups: List<GlobalNodeGroup>? = null
        /**
         * The optional description of the Global datastore
         */
        var globalReplicationGroupDescription: kotlin.String? = null
        /**
         * The name of the Global datastore
         */
        var globalReplicationGroupId: kotlin.String? = null
        /**
         * The replication groups that comprise the Global datastore.
         */
        var members: List<GlobalReplicationGroupMember>? = null
        /**
         * The status of the Global datastore
         */
        var status: kotlin.String? = null
        /**
         * A flag that enables in-transit encryption when set to true.
         *
         * You cannot modify the value of TransitEncryptionEnabled after the cluster is created. To enable in-transit encryption on a cluster you must set TransitEncryptionEnabled to true when you create a cluster.
         *
         * Required:
         * Only available when creating a replication group in an Amazon VPC using redis version 3.2.6, 4.x or later.
         */
        var transitEncryptionEnabled: kotlin.Boolean? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.GlobalReplicationGroup) : this() {
            this.arn = x.arn
            this.atRestEncryptionEnabled = x.atRestEncryptionEnabled
            this.authTokenEnabled = x.authTokenEnabled
            this.cacheNodeType = x.cacheNodeType
            this.clusterEnabled = x.clusterEnabled
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.globalNodeGroups = x.globalNodeGroups
            this.globalReplicationGroupDescription = x.globalReplicationGroupDescription
            this.globalReplicationGroupId = x.globalReplicationGroupId
            this.members = x.members
            this.status = x.status
            this.transitEncryptionEnabled = x.transitEncryptionEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.GlobalReplicationGroup = GlobalReplicationGroup(this)
    }
}
