// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model



/**
 * Represents the input for a ModifyReplicationGroupShardConfiguration operation.
 */
class ModifyReplicationGroupShardConfigurationRequest private constructor(builder: Builder) {
    /**
     * Indicates that the shard reconfiguration process begins immediately.
     * At present, the only permitted value for this parameter is true.
     * Value: true
     */
    val applyImmediately: kotlin.Boolean = builder.applyImmediately
    /**
     * The number of node groups (shards) that results from the modification of the
     * shard configuration.
     */
    val nodeGroupCount: kotlin.Int = builder.nodeGroupCount
    /**
     * If the value of NodeGroupCount is less than the
     * current number of node groups (shards), then either NodeGroupsToRemove or
     * NodeGroupsToRetain is required.
     * NodeGroupsToRemove is a list of NodeGroupIds to remove
     * from the cluster.
     * ElastiCache for Redis will attempt to remove all node groups listed by NodeGroupsToRemove
     * from the cluster.
     */
    val nodeGroupsToRemove: List<String>? = builder.nodeGroupsToRemove
    /**
     * If the value of NodeGroupCount is less than the
     * current number of node groups (shards), then either NodeGroupsToRemove or
     * NodeGroupsToRetain is required.
     * NodeGroupsToRetain is a list of NodeGroupIds to retain
     * in the cluster.
     * ElastiCache for Redis will attempt to remove all node groups except those listed by NodeGroupsToRetain
     * from the cluster.
     */
    val nodeGroupsToRetain: List<String>? = builder.nodeGroupsToRetain
    /**
     * The name of the Redis (cluster mode enabled) cluster (replication group)
     * on which the shards are to be configured.
     */
    val replicationGroupId: kotlin.String? = builder.replicationGroupId
    /**
     * Specifies the preferred availability zones for each node group in the cluster.
     * If the value of NodeGroupCount is greater than the current number
     * of node groups (shards), you can use this parameter to specify the preferred
     * availability zones of the cluster's shards.
     * If you omit this parameter ElastiCache selects availability zones for you.
     * You can specify this parameter only if the value of NodeGroupCount
     * is greater than the current number of node groups (shards).
     */
    val reshardingConfiguration: List<ReshardingConfiguration>? = builder.reshardingConfiguration

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.ModifyReplicationGroupShardConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyReplicationGroupShardConfigurationRequest(")
        append("applyImmediately=$applyImmediately,")
        append("nodeGroupCount=$nodeGroupCount,")
        append("nodeGroupsToRemove=$nodeGroupsToRemove,")
        append("nodeGroupsToRetain=$nodeGroupsToRetain,")
        append("replicationGroupId=$replicationGroupId,")
        append("reshardingConfiguration=$reshardingConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applyImmediately.hashCode()
        result = 31 * result + (nodeGroupCount)
        result = 31 * result + (nodeGroupsToRemove?.hashCode() ?: 0)
        result = 31 * result + (nodeGroupsToRetain?.hashCode() ?: 0)
        result = 31 * result + (replicationGroupId?.hashCode() ?: 0)
        result = 31 * result + (reshardingConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyReplicationGroupShardConfigurationRequest

        if (applyImmediately != other.applyImmediately) return false
        if (nodeGroupCount != other.nodeGroupCount) return false
        if (nodeGroupsToRemove != other.nodeGroupsToRemove) return false
        if (nodeGroupsToRetain != other.nodeGroupsToRetain) return false
        if (replicationGroupId != other.replicationGroupId) return false
        if (reshardingConfiguration != other.reshardingConfiguration) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.ModifyReplicationGroupShardConfigurationRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates that the shard reconfiguration process begins immediately.
         * At present, the only permitted value for this parameter is true.
         * Value: true
         */
        var applyImmediately: kotlin.Boolean = false
        /**
         * The number of node groups (shards) that results from the modification of the
         * shard configuration.
         */
        var nodeGroupCount: kotlin.Int = 0
        /**
         * If the value of NodeGroupCount is less than the
         * current number of node groups (shards), then either NodeGroupsToRemove or
         * NodeGroupsToRetain is required.
         * NodeGroupsToRemove is a list of NodeGroupIds to remove
         * from the cluster.
         * ElastiCache for Redis will attempt to remove all node groups listed by NodeGroupsToRemove
         * from the cluster.
         */
        var nodeGroupsToRemove: List<String>? = null
        /**
         * If the value of NodeGroupCount is less than the
         * current number of node groups (shards), then either NodeGroupsToRemove or
         * NodeGroupsToRetain is required.
         * NodeGroupsToRetain is a list of NodeGroupIds to retain
         * in the cluster.
         * ElastiCache for Redis will attempt to remove all node groups except those listed by NodeGroupsToRetain
         * from the cluster.
         */
        var nodeGroupsToRetain: List<String>? = null
        /**
         * The name of the Redis (cluster mode enabled) cluster (replication group)
         * on which the shards are to be configured.
         */
        var replicationGroupId: kotlin.String? = null
        /**
         * Specifies the preferred availability zones for each node group in the cluster.
         * If the value of NodeGroupCount is greater than the current number
         * of node groups (shards), you can use this parameter to specify the preferred
         * availability zones of the cluster's shards.
         * If you omit this parameter ElastiCache selects availability zones for you.
         * You can specify this parameter only if the value of NodeGroupCount
         * is greater than the current number of node groups (shards).
         */
        var reshardingConfiguration: List<ReshardingConfiguration>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.ModifyReplicationGroupShardConfigurationRequest) : this() {
            this.applyImmediately = x.applyImmediately
            this.nodeGroupCount = x.nodeGroupCount
            this.nodeGroupsToRemove = x.nodeGroupsToRemove
            this.nodeGroupsToRetain = x.nodeGroupsToRetain
            this.replicationGroupId = x.replicationGroupId
            this.reshardingConfiguration = x.reshardingConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.ModifyReplicationGroupShardConfigurationRequest = ModifyReplicationGroupShardConfigurationRequest(this)
    }
}
