// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model



/**
 * Node group (shard) configuration options.
 * Each node group (shard) configuration has the following: Slots, PrimaryAvailabilityZone, ReplicaAvailabilityZones, ReplicaCount.
 */
class NodeGroupConfiguration private constructor(builder: Builder) {
    /**
     * Either the ElastiCache for Redis supplied 4-digit id or a user supplied id for the node group these
     * configuration values apply to.
     */
    val nodeGroupId: kotlin.String? = builder.nodeGroupId
    /**
     * The Availability Zone where the primary node of this node group (shard) is launched.
     */
    val primaryAvailabilityZone: kotlin.String? = builder.primaryAvailabilityZone
    /**
     * The outpost ARN of the primary node.
     */
    val primaryOutpostArn: kotlin.String? = builder.primaryOutpostArn
    /**
     * A list of Availability Zones to be used for the read replicas.
     * The number of Availability Zones in this list must match the value of ReplicaCount
     * or ReplicasPerNodeGroup if not specified.
     */
    val replicaAvailabilityZones: List<String>? = builder.replicaAvailabilityZones
    /**
     * The number of read replica nodes in this node group (shard).
     */
    val replicaCount: kotlin.Int? = builder.replicaCount
    /**
     * The outpost ARN of the node replicas.
     */
    val replicaOutpostArns: List<String>? = builder.replicaOutpostArns
    /**
     * A string that specifies the keyspace for a particular node group.
     * Keyspaces range from 0 to 16,383.
     * The string is in the format startkey-endkey.
     * Example: "0-3999"
     */
    val slots: kotlin.String? = builder.slots

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.NodeGroupConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NodeGroupConfiguration(")
        append("nodeGroupId=$nodeGroupId,")
        append("primaryAvailabilityZone=$primaryAvailabilityZone,")
        append("primaryOutpostArn=$primaryOutpostArn,")
        append("replicaAvailabilityZones=$replicaAvailabilityZones,")
        append("replicaCount=$replicaCount,")
        append("replicaOutpostArns=$replicaOutpostArns,")
        append("slots=$slots)")
    }

    override fun hashCode(): kotlin.Int {
        var result = nodeGroupId?.hashCode() ?: 0
        result = 31 * result + (primaryAvailabilityZone?.hashCode() ?: 0)
        result = 31 * result + (primaryOutpostArn?.hashCode() ?: 0)
        result = 31 * result + (replicaAvailabilityZones?.hashCode() ?: 0)
        result = 31 * result + (replicaCount ?: 0)
        result = 31 * result + (replicaOutpostArns?.hashCode() ?: 0)
        result = 31 * result + (slots?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NodeGroupConfiguration

        if (nodeGroupId != other.nodeGroupId) return false
        if (primaryAvailabilityZone != other.primaryAvailabilityZone) return false
        if (primaryOutpostArn != other.primaryOutpostArn) return false
        if (replicaAvailabilityZones != other.replicaAvailabilityZones) return false
        if (replicaCount != other.replicaCount) return false
        if (replicaOutpostArns != other.replicaOutpostArns) return false
        if (slots != other.slots) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.NodeGroupConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * Either the ElastiCache for Redis supplied 4-digit id or a user supplied id for the node group these
         * configuration values apply to.
         */
        var nodeGroupId: kotlin.String? = null
        /**
         * The Availability Zone where the primary node of this node group (shard) is launched.
         */
        var primaryAvailabilityZone: kotlin.String? = null
        /**
         * The outpost ARN of the primary node.
         */
        var primaryOutpostArn: kotlin.String? = null
        /**
         * A list of Availability Zones to be used for the read replicas.
         * The number of Availability Zones in this list must match the value of ReplicaCount
         * or ReplicasPerNodeGroup if not specified.
         */
        var replicaAvailabilityZones: List<String>? = null
        /**
         * The number of read replica nodes in this node group (shard).
         */
        var replicaCount: kotlin.Int? = null
        /**
         * The outpost ARN of the node replicas.
         */
        var replicaOutpostArns: List<String>? = null
        /**
         * A string that specifies the keyspace for a particular node group.
         * Keyspaces range from 0 to 16,383.
         * The string is in the format startkey-endkey.
         * Example: "0-3999"
         */
        var slots: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.NodeGroupConfiguration) : this() {
            this.nodeGroupId = x.nodeGroupId
            this.primaryAvailabilityZone = x.primaryAvailabilityZone
            this.primaryOutpostArn = x.primaryOutpostArn
            this.replicaAvailabilityZones = x.replicaAvailabilityZones
            this.replicaCount = x.replicaCount
            this.replicaOutpostArns = x.replicaOutpostArns
            this.slots = x.slots
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.NodeGroupConfiguration = NodeGroupConfiguration(this)
    }
}
