// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.transform

import aws.sdk.kotlin.services.elasticache.model.AzMode
import aws.sdk.kotlin.services.elasticache.model.CreateCacheClusterRequest
import aws.sdk.kotlin.services.elasticache.model.LogDeliveryConfigurationRequest
import aws.sdk.kotlin.services.elasticache.model.OutpostMode
import aws.sdk.kotlin.services.elasticache.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlCollectionName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateCacheClusterOperationSerializer: HttpSerialize<CreateCacheClusterRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateCacheClusterRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeCreateCacheClusterOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        return builder
    }
}

private fun serializeCreateCacheClusterOperationBody(context: ExecutionContext, input: CreateCacheClusterRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val AZMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("AZMode"))
    val AUTHTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("AuthToken"))
    val AUTOMINORVERSIONUPGRADE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("AutoMinorVersionUpgrade"))
    val CACHECLUSTERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("CacheClusterId"))
    val CACHENODETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("CacheNodeType"))
    val CACHEPARAMETERGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("CacheParameterGroupName"))
    val CACHESECURITYGROUPNAMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("CacheSecurityGroupNames"), FormUrlCollectionName("CacheSecurityGroupName"))
    val CACHESUBNETGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("CacheSubnetGroupName"))
    val ENGINE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Engine"))
    val ENGINEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("EngineVersion"))
    val LOGDELIVERYCONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("LogDeliveryConfigurations"), FormUrlCollectionName("LogDeliveryConfigurationRequest"))
    val NOTIFICATIONTOPICARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("NotificationTopicArn"))
    val NUMCACHENODES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("NumCacheNodes"))
    val OUTPOSTMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("OutpostMode"))
    val PORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("Port"))
    val PREFERREDAVAILABILITYZONE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("PreferredAvailabilityZone"))
    val PREFERREDAVAILABILITYZONES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("PreferredAvailabilityZones"), FormUrlCollectionName("PreferredAvailabilityZone"))
    val PREFERREDMAINTENANCEWINDOW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("PreferredMaintenanceWindow"))
    val PREFERREDOUTPOSTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("PreferredOutpostArn"))
    val PREFERREDOUTPOSTARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("PreferredOutpostArns"), FormUrlCollectionName("PreferredOutpostArn"))
    val REPLICATIONGROUPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ReplicationGroupId"))
    val SECURITYGROUPIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("SecurityGroupIds"), FormUrlCollectionName("SecurityGroupId"))
    val SNAPSHOTARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("SnapshotArns"), FormUrlCollectionName("SnapshotArn"))
    val SNAPSHOTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("SnapshotName"))
    val SNAPSHOTRETENTIONLIMIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("SnapshotRetentionLimit"))
    val SNAPSHOTWINDOW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("SnapshotWindow"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Tags"), FormUrlCollectionName("Tag"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("CreateCacheClusterMessage"))
        trait(QueryLiteral("Action", "CreateCacheCluster"))
        trait(QueryLiteral("Version", "2015-02-02"))
        field(AZMODE_DESCRIPTOR)
        field(AUTHTOKEN_DESCRIPTOR)
        field(AUTOMINORVERSIONUPGRADE_DESCRIPTOR)
        field(CACHECLUSTERID_DESCRIPTOR)
        field(CACHENODETYPE_DESCRIPTOR)
        field(CACHEPARAMETERGROUPNAME_DESCRIPTOR)
        field(CACHESECURITYGROUPNAMES_DESCRIPTOR)
        field(CACHESUBNETGROUPNAME_DESCRIPTOR)
        field(ENGINE_DESCRIPTOR)
        field(ENGINEVERSION_DESCRIPTOR)
        field(LOGDELIVERYCONFIGURATIONS_DESCRIPTOR)
        field(NOTIFICATIONTOPICARN_DESCRIPTOR)
        field(NUMCACHENODES_DESCRIPTOR)
        field(OUTPOSTMODE_DESCRIPTOR)
        field(PORT_DESCRIPTOR)
        field(PREFERREDAVAILABILITYZONE_DESCRIPTOR)
        field(PREFERREDAVAILABILITYZONES_DESCRIPTOR)
        field(PREFERREDMAINTENANCEWINDOW_DESCRIPTOR)
        field(PREFERREDOUTPOSTARN_DESCRIPTOR)
        field(PREFERREDOUTPOSTARNS_DESCRIPTOR)
        field(REPLICATIONGROUPID_DESCRIPTOR)
        field(SECURITYGROUPIDS_DESCRIPTOR)
        field(SNAPSHOTARNS_DESCRIPTOR)
        field(SNAPSHOTNAME_DESCRIPTOR)
        field(SNAPSHOTRETENTIONLIMIT_DESCRIPTOR)
        field(SNAPSHOTWINDOW_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.azMode?.let { field(AZMODE_DESCRIPTOR, it.value) }
        input.authToken?.let { field(AUTHTOKEN_DESCRIPTOR, it) }
        input.autoMinorVersionUpgrade?.let { field(AUTOMINORVERSIONUPGRADE_DESCRIPTOR, it) }
        input.cacheClusterId?.let { field(CACHECLUSTERID_DESCRIPTOR, it) }
        input.cacheNodeType?.let { field(CACHENODETYPE_DESCRIPTOR, it) }
        input.cacheParameterGroupName?.let { field(CACHEPARAMETERGROUPNAME_DESCRIPTOR, it) }
        if (input.cacheSecurityGroupNames != null) {
            listField(CACHESECURITYGROUPNAMES_DESCRIPTOR) {
                for (el0 in input.cacheSecurityGroupNames) {
                    serializeString(el0)
                }
            }
        }
        input.cacheSubnetGroupName?.let { field(CACHESUBNETGROUPNAME_DESCRIPTOR, it) }
        input.engine?.let { field(ENGINE_DESCRIPTOR, it) }
        input.engineVersion?.let { field(ENGINEVERSION_DESCRIPTOR, it) }
        if (input.logDeliveryConfigurations != null) {
            listField(LOGDELIVERYCONFIGURATIONS_DESCRIPTOR) {
                for (el0 in input.logDeliveryConfigurations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeLogDeliveryConfigurationRequestDocument))
                }
            }
        }
        input.notificationTopicArn?.let { field(NOTIFICATIONTOPICARN_DESCRIPTOR, it) }
        input.numCacheNodes?.let { field(NUMCACHENODES_DESCRIPTOR, it) }
        input.outpostMode?.let { field(OUTPOSTMODE_DESCRIPTOR, it.value) }
        input.port?.let { field(PORT_DESCRIPTOR, it) }
        input.preferredAvailabilityZone?.let { field(PREFERREDAVAILABILITYZONE_DESCRIPTOR, it) }
        if (input.preferredAvailabilityZones != null) {
            listField(PREFERREDAVAILABILITYZONES_DESCRIPTOR) {
                for (el0 in input.preferredAvailabilityZones) {
                    serializeString(el0)
                }
            }
        }
        input.preferredMaintenanceWindow?.let { field(PREFERREDMAINTENANCEWINDOW_DESCRIPTOR, it) }
        input.preferredOutpostArn?.let { field(PREFERREDOUTPOSTARN_DESCRIPTOR, it) }
        if (input.preferredOutpostArns != null) {
            listField(PREFERREDOUTPOSTARNS_DESCRIPTOR) {
                for (el0 in input.preferredOutpostArns) {
                    serializeString(el0)
                }
            }
        }
        input.replicationGroupId?.let { field(REPLICATIONGROUPID_DESCRIPTOR, it) }
        if (input.securityGroupIds != null) {
            listField(SECURITYGROUPIDS_DESCRIPTOR) {
                for (el0 in input.securityGroupIds) {
                    serializeString(el0)
                }
            }
        }
        if (input.snapshotArns != null) {
            listField(SNAPSHOTARNS_DESCRIPTOR) {
                for (el0 in input.snapshotArns) {
                    serializeString(el0)
                }
            }
        }
        input.snapshotName?.let { field(SNAPSHOTNAME_DESCRIPTOR, it) }
        input.snapshotRetentionLimit?.let { field(SNAPSHOTRETENTIONLIMIT_DESCRIPTOR, it) }
        input.snapshotWindow?.let { field(SNAPSHOTWINDOW_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
