// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model



/**
 * Represents the input of a DescribeReplicationGroups operation.
 */
class DescribeReplicationGroupsRequest private constructor(builder: Builder) {
    /**
     * An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this
     * parameter is specified, the response includes only records beyond the marker, up to the
     * value specified by MaxRecords.
     */
    val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than the
     * specified MaxRecords value, a marker is included in the response so that
     * the remaining results can be retrieved.
     *
     * Default: 100
     * Constraints: minimum 20; maximum 100.
     */
    val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * The identifier for the replication group to be described. This parameter is not case sensitive.
     * If you do not specify this parameter, information about all replication groups is returned.
     */
    val replicationGroupId: kotlin.String? = builder.replicationGroupId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.DescribeReplicationGroupsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeReplicationGroupsRequest(")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("replicationGroupId=$replicationGroupId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = marker?.hashCode() ?: 0
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (replicationGroupId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeReplicationGroupsRequest

        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (replicationGroupId != other.replicationGroupId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.DescribeReplicationGroupsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this
         * parameter is specified, the response includes only records beyond the marker, up to the
         * value specified by MaxRecords.
         */
        var marker: kotlin.String? = null
        /**
         * The maximum number of records to include in the response. If more records exist than the
         * specified MaxRecords value, a marker is included in the response so that
         * the remaining results can be retrieved.
         *
         * Default: 100
         * Constraints: minimum 20; maximum 100.
         */
        var maxRecords: kotlin.Int? = null
        /**
         * The identifier for the replication group to be described. This parameter is not case sensitive.
         * If you do not specify this parameter, information about all replication groups is returned.
         */
        var replicationGroupId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.DescribeReplicationGroupsRequest) : this() {
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.replicationGroupId = x.replicationGroupId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.DescribeReplicationGroupsRequest = DescribeReplicationGroupsRequest(this)
    }
}
