// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model



/**
 * Represents the input of a ModifyReplicationGroups operation.
 */
class ModifyReplicationGroupRequest private constructor(builder: Builder) {
    /**
     * If true, this parameter causes the modifications in this request and any
     * pending modifications to be applied, asynchronously and as soon as possible, regardless
     * of the PreferredMaintenanceWindow setting for the replication group.
     * If false, changes to the nodes in the replication group are applied on
     * the next maintenance reboot, or the next failure reboot, whichever occurs first.
     * Valid values: true | false
     *
     * Default: false
     */
    val applyImmediately: kotlin.Boolean = builder.applyImmediately
    /**
     * Reserved parameter. The password used to access a password protected server. This parameter must be specified with the auth-token-update-strategy
     * parameter.
     * Password constraints:
     *
     *
     * Must be only printable ASCII characters
     *
     * Must be at least 16 characters and no more than 128 characters in length
     *
     * Cannot contain any of the following characters: '/', '"', or '@', '%'
     *
     *
     *
     *
     * For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH.
     */
    val authToken: kotlin.String? = builder.authToken
    /**
     * Specifies the strategy to use to update the AUTH token. This parameter must be specified with the auth-token parameter.
     * Possible values:
     *
     * Rotate
     *
     * Set
     *
     *
     *
     * For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis AUTH
     */
    val authTokenUpdateStrategy: aws.sdk.kotlin.services.elasticache.model.AuthTokenUpdateStrategyType? = builder.authTokenUpdateStrategy
    /**
     * If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.
     */
    val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * Determines whether a read replica is automatically promoted to read/write primary if the existing primary encounters a failure.
     * Valid values: true | false
     */
    val automaticFailoverEnabled: kotlin.Boolean? = builder.automaticFailoverEnabled
    /**
     * A valid cache node type that you want to scale this replication group to.
     */
    val cacheNodeType: kotlin.String? = builder.cacheNodeType
    /**
     * The name of the cache parameter group to apply to all of the clusters in this replication group.
     * This change is asynchronously applied as soon as possible for parameters when the
     * ApplyImmediately parameter is specified as true for this request.
     */
    val cacheParameterGroupName: kotlin.String? = builder.cacheParameterGroupName
    /**
     * A list of cache security group names to authorize for the clusters in this replication group. This change is asynchronously applied as soon as possible.
     * This parameter can be used only with replication group containing clusters running outside of an Amazon Virtual Private Cloud (Amazon VPC).
     * Constraints: Must contain no more than 255 alphanumeric characters. Must not be Default.
     */
    val cacheSecurityGroupNames: List<String>? = builder.cacheSecurityGroupNames
    /**
     * The upgraded version of the cache engine to be run on the clusters in the replication group.
     *
     * Important: You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version), but you cannot downgrade to an earlier engine version.
     * If you want to use an earlier engine version,
     * you must delete the existing replication group and create it anew with the earlier engine version.
     */
    val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * Specifies the destination, format and type of the logs.
     */
    val logDeliveryConfigurations: List<LogDeliveryConfigurationRequest>? = builder.logDeliveryConfigurations
    /**
     * A flag to indicate MultiAZ is enabled.
     */
    val multiAzEnabled: kotlin.Boolean? = builder.multiAzEnabled
    /**
     * Deprecated. This parameter is not used.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    val nodeGroupId: kotlin.String? = builder.nodeGroupId
    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.
     *
     * The Amazon SNS topic owner must be same as the replication group owner.
     */
    val notificationTopicArn: kotlin.String? = builder.notificationTopicArn
    /**
     * The status of the Amazon SNS notification topic for the replication group.
     * Notifications are sent only if the status is active.
     * Valid values: active | inactive
     */
    val notificationTopicStatus: kotlin.String? = builder.notificationTopicStatus
    /**
     * Specifies the weekly time range during which maintenance
     * on the cluster is performed. It is specified as a range in
     * the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum
     * maintenance window is a 60 minute period.
     * Valid values for ddd are:
     *
     *
     *
     * sun
     *
     *
     *
     * mon
     *
     *
     *
     * tue
     *
     *
     *
     * wed
     *
     *
     *
     * thu
     *
     *
     *
     * fri
     *
     *
     *
     * sat
     *
     *
     *
     * Example: sun:23:00-mon:01:30
     */
    val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * For replication groups with a single primary,
     * if this parameter is specified, ElastiCache promotes the specified cluster in the specified replication group to the primary role.
     * The nodes of all other clusters in the replication group are read replicas.
     */
    val primaryClusterId: kotlin.String? = builder.primaryClusterId
    /**
     * Removes the user group associated with this replication group.
     */
    val removeUserGroups: kotlin.Boolean? = builder.removeUserGroups
    /**
     * A description for the replication group. Maximum length is 255 characters.
     */
    val replicationGroupDescription: kotlin.String? = builder.replicationGroupDescription
    /**
     * The identifier of the replication group to modify.
     */
    val replicationGroupId: kotlin.String? = builder.replicationGroupId
    /**
     * Specifies the VPC Security Groups associated with the clusters in the replication group.
     * This parameter can be used only with replication group containing clusters running in
     * an Amazon Virtual Private Cloud (Amazon VPC).
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The number of days for which ElastiCache retains automatic node group (shard) snapshots before
     * deleting them. For example, if you set SnapshotRetentionLimit to 5, a
     * snapshot that was taken today is retained for 5 days before being deleted.
     *
     * Important If the value of SnapshotRetentionLimit is set to zero (0),
     * backups are turned off.
     */
    val snapshotRetentionLimit: kotlin.Int? = builder.snapshotRetentionLimit
    /**
     * The daily time range (in UTC) during which ElastiCache  begins taking a daily snapshot of
     * the node group (shard) specified by SnapshottingClusterId.
     * Example: 05:00-09:00
     *
     * If you do not specify this parameter, ElastiCache  automatically chooses an appropriate time range.
     */
    val snapshotWindow: kotlin.String? = builder.snapshotWindow
    /**
     * The cluster ID that is used as the daily snapshot source for the replication group.
     * This parameter cannot be set for Redis (cluster mode enabled) replication groups.
     */
    val snapshottingClusterId: kotlin.String? = builder.snapshottingClusterId
    /**
     * The ID of the user group you are associating with the replication group.
     */
    val userGroupIdsToAdd: List<String>? = builder.userGroupIdsToAdd
    /**
     * The ID of the user group to disassociate from the replication group, meaning the users in the group no longer can access the replication group.
     */
    val userGroupIdsToRemove: List<String>? = builder.userGroupIdsToRemove

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.ModifyReplicationGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyReplicationGroupRequest(")
        append("applyImmediately=$applyImmediately,")
        append("authToken=$authToken,")
        append("authTokenUpdateStrategy=$authTokenUpdateStrategy,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("automaticFailoverEnabled=$automaticFailoverEnabled,")
        append("cacheNodeType=$cacheNodeType,")
        append("cacheParameterGroupName=$cacheParameterGroupName,")
        append("cacheSecurityGroupNames=$cacheSecurityGroupNames,")
        append("engineVersion=$engineVersion,")
        append("logDeliveryConfigurations=$logDeliveryConfigurations,")
        append("multiAzEnabled=$multiAzEnabled,")
        append("nodeGroupId=$nodeGroupId,")
        append("notificationTopicArn=$notificationTopicArn,")
        append("notificationTopicStatus=$notificationTopicStatus,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("primaryClusterId=$primaryClusterId,")
        append("removeUserGroups=$removeUserGroups,")
        append("replicationGroupDescription=$replicationGroupDescription,")
        append("replicationGroupId=$replicationGroupId,")
        append("securityGroupIds=$securityGroupIds,")
        append("snapshotRetentionLimit=$snapshotRetentionLimit,")
        append("snapshotWindow=$snapshotWindow,")
        append("snapshottingClusterId=$snapshottingClusterId,")
        append("userGroupIdsToAdd=$userGroupIdsToAdd,")
        append("userGroupIdsToRemove=$userGroupIdsToRemove)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applyImmediately.hashCode()
        result = 31 * result + (authToken?.hashCode() ?: 0)
        result = 31 * result + (authTokenUpdateStrategy?.hashCode() ?: 0)
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (automaticFailoverEnabled?.hashCode() ?: 0)
        result = 31 * result + (cacheNodeType?.hashCode() ?: 0)
        result = 31 * result + (cacheParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (cacheSecurityGroupNames?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (logDeliveryConfigurations?.hashCode() ?: 0)
        result = 31 * result + (multiAzEnabled?.hashCode() ?: 0)
        result = 31 * result + (nodeGroupId?.hashCode() ?: 0)
        result = 31 * result + (notificationTopicArn?.hashCode() ?: 0)
        result = 31 * result + (notificationTopicStatus?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (primaryClusterId?.hashCode() ?: 0)
        result = 31 * result + (removeUserGroups?.hashCode() ?: 0)
        result = 31 * result + (replicationGroupDescription?.hashCode() ?: 0)
        result = 31 * result + (replicationGroupId?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (snapshotRetentionLimit ?: 0)
        result = 31 * result + (snapshotWindow?.hashCode() ?: 0)
        result = 31 * result + (snapshottingClusterId?.hashCode() ?: 0)
        result = 31 * result + (userGroupIdsToAdd?.hashCode() ?: 0)
        result = 31 * result + (userGroupIdsToRemove?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyReplicationGroupRequest

        if (applyImmediately != other.applyImmediately) return false
        if (authToken != other.authToken) return false
        if (authTokenUpdateStrategy != other.authTokenUpdateStrategy) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (automaticFailoverEnabled != other.automaticFailoverEnabled) return false
        if (cacheNodeType != other.cacheNodeType) return false
        if (cacheParameterGroupName != other.cacheParameterGroupName) return false
        if (cacheSecurityGroupNames != other.cacheSecurityGroupNames) return false
        if (engineVersion != other.engineVersion) return false
        if (logDeliveryConfigurations != other.logDeliveryConfigurations) return false
        if (multiAzEnabled != other.multiAzEnabled) return false
        if (nodeGroupId != other.nodeGroupId) return false
        if (notificationTopicArn != other.notificationTopicArn) return false
        if (notificationTopicStatus != other.notificationTopicStatus) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (primaryClusterId != other.primaryClusterId) return false
        if (removeUserGroups != other.removeUserGroups) return false
        if (replicationGroupDescription != other.replicationGroupDescription) return false
        if (replicationGroupId != other.replicationGroupId) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (snapshotRetentionLimit != other.snapshotRetentionLimit) return false
        if (snapshotWindow != other.snapshotWindow) return false
        if (snapshottingClusterId != other.snapshottingClusterId) return false
        if (userGroupIdsToAdd != other.userGroupIdsToAdd) return false
        if (userGroupIdsToRemove != other.userGroupIdsToRemove) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.ModifyReplicationGroupRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * If true, this parameter causes the modifications in this request and any
         * pending modifications to be applied, asynchronously and as soon as possible, regardless
         * of the PreferredMaintenanceWindow setting for the replication group.
         * If false, changes to the nodes in the replication group are applied on
         * the next maintenance reboot, or the next failure reboot, whichever occurs first.
         * Valid values: true | false
         *
         * Default: false
         */
        var applyImmediately: kotlin.Boolean = false
        /**
         * Reserved parameter. The password used to access a password protected server. This parameter must be specified with the auth-token-update-strategy
         * parameter.
         * Password constraints:
         *
         *
         * Must be only printable ASCII characters
         *
         * Must be at least 16 characters and no more than 128 characters in length
         *
         * Cannot contain any of the following characters: '/', '"', or '@', '%'
         *
         *
         *
         *
         * For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH.
         */
        var authToken: kotlin.String? = null
        /**
         * Specifies the strategy to use to update the AUTH token. This parameter must be specified with the auth-token parameter.
         * Possible values:
         *
         * Rotate
         *
         * Set
         *
         *
         *
         * For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis AUTH
         */
        var authTokenUpdateStrategy: aws.sdk.kotlin.services.elasticache.model.AuthTokenUpdateStrategyType? = null
        /**
         * If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.
         */
        var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * Determines whether a read replica is automatically promoted to read/write primary if the existing primary encounters a failure.
         * Valid values: true | false
         */
        var automaticFailoverEnabled: kotlin.Boolean? = null
        /**
         * A valid cache node type that you want to scale this replication group to.
         */
        var cacheNodeType: kotlin.String? = null
        /**
         * The name of the cache parameter group to apply to all of the clusters in this replication group.
         * This change is asynchronously applied as soon as possible for parameters when the
         * ApplyImmediately parameter is specified as true for this request.
         */
        var cacheParameterGroupName: kotlin.String? = null
        /**
         * A list of cache security group names to authorize for the clusters in this replication group. This change is asynchronously applied as soon as possible.
         * This parameter can be used only with replication group containing clusters running outside of an Amazon Virtual Private Cloud (Amazon VPC).
         * Constraints: Must contain no more than 255 alphanumeric characters. Must not be Default.
         */
        var cacheSecurityGroupNames: List<String>? = null
        /**
         * The upgraded version of the cache engine to be run on the clusters in the replication group.
         *
         * Important: You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version), but you cannot downgrade to an earlier engine version.
         * If you want to use an earlier engine version,
         * you must delete the existing replication group and create it anew with the earlier engine version.
         */
        var engineVersion: kotlin.String? = null
        /**
         * Specifies the destination, format and type of the logs.
         */
        var logDeliveryConfigurations: List<LogDeliveryConfigurationRequest>? = null
        /**
         * A flag to indicate MultiAZ is enabled.
         */
        var multiAzEnabled: kotlin.Boolean? = null
        /**
         * Deprecated. This parameter is not used.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        var nodeGroupId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.
         *
         * The Amazon SNS topic owner must be same as the replication group owner.
         */
        var notificationTopicArn: kotlin.String? = null
        /**
         * The status of the Amazon SNS notification topic for the replication group.
         * Notifications are sent only if the status is active.
         * Valid values: active | inactive
         */
        var notificationTopicStatus: kotlin.String? = null
        /**
         * Specifies the weekly time range during which maintenance
         * on the cluster is performed. It is specified as a range in
         * the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum
         * maintenance window is a 60 minute period.
         * Valid values for ddd are:
         *
         *
         *
         * sun
         *
         *
         *
         * mon
         *
         *
         *
         * tue
         *
         *
         *
         * wed
         *
         *
         *
         * thu
         *
         *
         *
         * fri
         *
         *
         *
         * sat
         *
         *
         *
         * Example: sun:23:00-mon:01:30
         */
        var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * For replication groups with a single primary,
         * if this parameter is specified, ElastiCache promotes the specified cluster in the specified replication group to the primary role.
         * The nodes of all other clusters in the replication group are read replicas.
         */
        var primaryClusterId: kotlin.String? = null
        /**
         * Removes the user group associated with this replication group.
         */
        var removeUserGroups: kotlin.Boolean? = null
        /**
         * A description for the replication group. Maximum length is 255 characters.
         */
        var replicationGroupDescription: kotlin.String? = null
        /**
         * The identifier of the replication group to modify.
         */
        var replicationGroupId: kotlin.String? = null
        /**
         * Specifies the VPC Security Groups associated with the clusters in the replication group.
         * This parameter can be used only with replication group containing clusters running in
         * an Amazon Virtual Private Cloud (Amazon VPC).
         */
        var securityGroupIds: List<String>? = null
        /**
         * The number of days for which ElastiCache retains automatic node group (shard) snapshots before
         * deleting them. For example, if you set SnapshotRetentionLimit to 5, a
         * snapshot that was taken today is retained for 5 days before being deleted.
         *
         * Important If the value of SnapshotRetentionLimit is set to zero (0),
         * backups are turned off.
         */
        var snapshotRetentionLimit: kotlin.Int? = null
        /**
         * The daily time range (in UTC) during which ElastiCache  begins taking a daily snapshot of
         * the node group (shard) specified by SnapshottingClusterId.
         * Example: 05:00-09:00
         *
         * If you do not specify this parameter, ElastiCache  automatically chooses an appropriate time range.
         */
        var snapshotWindow: kotlin.String? = null
        /**
         * The cluster ID that is used as the daily snapshot source for the replication group.
         * This parameter cannot be set for Redis (cluster mode enabled) replication groups.
         */
        var snapshottingClusterId: kotlin.String? = null
        /**
         * The ID of the user group you are associating with the replication group.
         */
        var userGroupIdsToAdd: List<String>? = null
        /**
         * The ID of the user group to disassociate from the replication group, meaning the users in the group no longer can access the replication group.
         */
        var userGroupIdsToRemove: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.ModifyReplicationGroupRequest) : this() {
            this.applyImmediately = x.applyImmediately
            this.authToken = x.authToken
            this.authTokenUpdateStrategy = x.authTokenUpdateStrategy
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.automaticFailoverEnabled = x.automaticFailoverEnabled
            this.cacheNodeType = x.cacheNodeType
            this.cacheParameterGroupName = x.cacheParameterGroupName
            this.cacheSecurityGroupNames = x.cacheSecurityGroupNames
            this.engineVersion = x.engineVersion
            this.logDeliveryConfigurations = x.logDeliveryConfigurations
            this.multiAzEnabled = x.multiAzEnabled
            this.nodeGroupId = x.nodeGroupId
            this.notificationTopicArn = x.notificationTopicArn
            this.notificationTopicStatus = x.notificationTopicStatus
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.primaryClusterId = x.primaryClusterId
            this.removeUserGroups = x.removeUserGroups
            this.replicationGroupDescription = x.replicationGroupDescription
            this.replicationGroupId = x.replicationGroupId
            this.securityGroupIds = x.securityGroupIds
            this.snapshotRetentionLimit = x.snapshotRetentionLimit
            this.snapshotWindow = x.snapshotWindow
            this.snapshottingClusterId = x.snapshottingClusterId
            this.userGroupIdsToAdd = x.userGroupIdsToAdd
            this.userGroupIdsToRemove = x.userGroupIdsToRemove
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.ModifyReplicationGroupRequest = ModifyReplicationGroupRequest(this)
    }
}
