// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model



/**
 * Represents the input of a DescribeReservedCacheNodes operation.
 */
class DescribeReservedCacheNodesRequest private constructor(builder: Builder) {
    /**
     * The cache node type filter value.
     * Use this parameter to show only those reservations matching the specified cache node type.
     *
     * The following node types are supported by ElastiCache.
     * Generally speaking, the current generation types provide more memory and computational power
     * at lower cost when compared to their equivalent previous generation counterparts.
     *
     *
     * General purpose:
     *
     *
     * Current generation:
     *
     *
     *
     *
     * M6g node types: (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward):
     * cache.m6g.large,
     * cache.m6g.xlarge,
     * cache.m6g.2xlarge,
     * cache.m6g.4xlarge,
     * cache.m6g.8xlarge,
     * cache.m6g.12xlarge,
     * cache.m6g.16xlarge
     *
     *
     *
     *
     * For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types
     *
     *
     *
     *
     * M5 node types:
     * cache.m5.large,
     * cache.m5.xlarge,
     * cache.m5.2xlarge,
     * cache.m5.4xlarge,
     * cache.m5.12xlarge,
     * cache.m5.24xlarge
     *
     *
     *
     *
     *
     * M4 node types:
     * cache.m4.large,
     * cache.m4.xlarge,
     * cache.m4.2xlarge,
     * cache.m4.4xlarge,
     * cache.m4.10xlarge
     *
     *
     *
     * T4g node types (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward):
     * cache.t4g.micro,
     * cache.t4g.small,
     * cache.t4g.medium
     *
     *
     *
     * T3 node types:
     * cache.t3.micro,
     * cache.t3.small,
     * cache.t3.medium
     *
     *
     *
     *
     * T2 node types:
     * cache.t2.micro,
     * cache.t2.small,
     * cache.t2.medium
     *
     *
     *
     *
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)
     *
     * T1 node types:
     * cache.t1.micro
     *
     *
     *
     * M1 node types:
     * cache.m1.small,
     * cache.m1.medium,
     * cache.m1.large,
     * cache.m1.xlarge
     *
     *
     *
     * M3 node types:
     * cache.m3.medium,
     * cache.m3.large,
     * cache.m3.xlarge,
     * cache.m3.2xlarge
     *
     *
     *
     *
     *
     * Compute optimized:
     *
     *
     *
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)
     *
     * C1 node types:
     * cache.c1.xlarge
     *
     *
     *
     *
     * Memory optimized with data tiering:
     *
     *
     * Current generation:
     *
     *
     * R6gd node types (available only for Redis engine version 6.2 onward).
     *
     *
     *
     * cache.r6gd.xlarge,
     * cache.r6gd.2xlarge,
     * cache.r6gd.4xlarge,
     * cache.r6gd.8xlarge,
     * cache.r6gd.12xlarge,
     * cache.r6gd.16xlarge
     *
     *
     *
     *
     *
     * Memory optimized:
     *
     *
     * Current generation:
     *
     *
     *
     *
     * R6g node types (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).
     *
     *
     * cache.r6g.large,
     * cache.r6g.xlarge,
     * cache.r6g.2xlarge,
     * cache.r6g.4xlarge,
     * cache.r6g.8xlarge,
     * cache.r6g.12xlarge,
     * cache.r6g.16xlarge
     *
     *
     *
     * For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types
     *
     *
     *
     * R5 node types:
     * cache.r5.large,
     * cache.r5.xlarge,
     * cache.r5.2xlarge,
     * cache.r5.4xlarge,
     * cache.r5.12xlarge,
     * cache.r5.24xlarge
     *
     *
     *
     * R4 node types:
     * cache.r4.large,
     * cache.r4.xlarge,
     * cache.r4.2xlarge,
     * cache.r4.4xlarge,
     * cache.r4.8xlarge,
     * cache.r4.16xlarge
     *
     *
     *
     *
     *
     *
     *
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)
     *
     * M2 node types:
     * cache.m2.xlarge,
     * cache.m2.2xlarge,
     * cache.m2.4xlarge
     *
     *
     *
     * R3 node types:
     * cache.r3.large,
     * cache.r3.xlarge,
     * cache.r3.2xlarge,
     * cache.r3.4xlarge,
     * cache.r3.8xlarge
     *
     *
     *
     *
     *
     *
     *
     *
     * Additional node type info
     *
     *
     *
     * All current generation instance types are created in Amazon VPC by default.
     *
     * Redis append-only files (AOF) are not supported for T1 or T2 instances.
     *
     * Redis Multi-AZ with automatic failover is not supported on T1 instances.
     *
     * Redis configuration variables appendonly and
     * appendfsync are not supported on Redis version 2.8.22 and later.
     */
    val cacheNodeType: kotlin.String? = builder.cacheNodeType
    /**
     * The duration filter value, specified in years or seconds.
     * Use this parameter to show only reservations for this duration.
     * Valid Values: 1 | 3 | 31536000 | 94608000
     */
    val duration: kotlin.String? = builder.duration
    /**
     * An optional marker returned from a prior request.
     * Use this marker for pagination of results from this operation.
     * If this parameter is specified, the response includes only records beyond the marker,
     * up to the value specified by MaxRecords.
     */
    val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than the
     * specified MaxRecords value, a marker is included in the response so that
     * the remaining results can be retrieved.
     *
     * Default: 100
     * Constraints: minimum 20; maximum 100.
     */
    val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * The offering type filter value.
     * Use this parameter to show only the available offerings matching the specified offering type.
     * Valid values: "Light Utilization"|"Medium Utilization"|"Heavy Utilization"|"All Upfront"|"Partial Upfront"| "No Upfront"
     */
    val offeringType: kotlin.String? = builder.offeringType
    /**
     * The product description filter value. Use this parameter to show only those reservations matching the specified product description.
     */
    val productDescription: kotlin.String? = builder.productDescription
    /**
     * The reserved cache node identifier filter value.
     * Use this parameter to show only the reservation that matches the specified reservation ID.
     */
    val reservedCacheNodeId: kotlin.String? = builder.reservedCacheNodeId
    /**
     * The offering identifier filter value.
     * Use this parameter to show only purchased reservations matching the specified offering identifier.
     */
    val reservedCacheNodesOfferingId: kotlin.String? = builder.reservedCacheNodesOfferingId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.DescribeReservedCacheNodesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeReservedCacheNodesRequest(")
        append("cacheNodeType=$cacheNodeType,")
        append("duration=$duration,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("offeringType=$offeringType,")
        append("productDescription=$productDescription,")
        append("reservedCacheNodeId=$reservedCacheNodeId,")
        append("reservedCacheNodesOfferingId=$reservedCacheNodesOfferingId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheNodeType?.hashCode() ?: 0
        result = 31 * result + (duration?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (offeringType?.hashCode() ?: 0)
        result = 31 * result + (productDescription?.hashCode() ?: 0)
        result = 31 * result + (reservedCacheNodeId?.hashCode() ?: 0)
        result = 31 * result + (reservedCacheNodesOfferingId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeReservedCacheNodesRequest

        if (cacheNodeType != other.cacheNodeType) return false
        if (duration != other.duration) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (offeringType != other.offeringType) return false
        if (productDescription != other.productDescription) return false
        if (reservedCacheNodeId != other.reservedCacheNodeId) return false
        if (reservedCacheNodesOfferingId != other.reservedCacheNodesOfferingId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.DescribeReservedCacheNodesRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The cache node type filter value.
         * Use this parameter to show only those reservations matching the specified cache node type.
         *
         * The following node types are supported by ElastiCache.
         * Generally speaking, the current generation types provide more memory and computational power
         * at lower cost when compared to their equivalent previous generation counterparts.
         *
         *
         * General purpose:
         *
         *
         * Current generation:
         *
         *
         *
         *
         * M6g node types: (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward):
         * cache.m6g.large,
         * cache.m6g.xlarge,
         * cache.m6g.2xlarge,
         * cache.m6g.4xlarge,
         * cache.m6g.8xlarge,
         * cache.m6g.12xlarge,
         * cache.m6g.16xlarge
         *
         *
         *
         *
         * For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types
         *
         *
         *
         *
         * M5 node types:
         * cache.m5.large,
         * cache.m5.xlarge,
         * cache.m5.2xlarge,
         * cache.m5.4xlarge,
         * cache.m5.12xlarge,
         * cache.m5.24xlarge
         *
         *
         *
         *
         *
         * M4 node types:
         * cache.m4.large,
         * cache.m4.xlarge,
         * cache.m4.2xlarge,
         * cache.m4.4xlarge,
         * cache.m4.10xlarge
         *
         *
         *
         * T4g node types (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward):
         * cache.t4g.micro,
         * cache.t4g.small,
         * cache.t4g.medium
         *
         *
         *
         * T3 node types:
         * cache.t3.micro,
         * cache.t3.small,
         * cache.t3.medium
         *
         *
         *
         *
         * T2 node types:
         * cache.t2.micro,
         * cache.t2.small,
         * cache.t2.medium
         *
         *
         *
         *
         * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)
         *
         * T1 node types:
         * cache.t1.micro
         *
         *
         *
         * M1 node types:
         * cache.m1.small,
         * cache.m1.medium,
         * cache.m1.large,
         * cache.m1.xlarge
         *
         *
         *
         * M3 node types:
         * cache.m3.medium,
         * cache.m3.large,
         * cache.m3.xlarge,
         * cache.m3.2xlarge
         *
         *
         *
         *
         *
         * Compute optimized:
         *
         *
         *
         * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)
         *
         * C1 node types:
         * cache.c1.xlarge
         *
         *
         *
         *
         * Memory optimized with data tiering:
         *
         *
         * Current generation:
         *
         *
         * R6gd node types (available only for Redis engine version 6.2 onward).
         *
         *
         *
         * cache.r6gd.xlarge,
         * cache.r6gd.2xlarge,
         * cache.r6gd.4xlarge,
         * cache.r6gd.8xlarge,
         * cache.r6gd.12xlarge,
         * cache.r6gd.16xlarge
         *
         *
         *
         *
         *
         * Memory optimized:
         *
         *
         * Current generation:
         *
         *
         *
         *
         * R6g node types (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).
         *
         *
         * cache.r6g.large,
         * cache.r6g.xlarge,
         * cache.r6g.2xlarge,
         * cache.r6g.4xlarge,
         * cache.r6g.8xlarge,
         * cache.r6g.12xlarge,
         * cache.r6g.16xlarge
         *
         *
         *
         * For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types
         *
         *
         *
         * R5 node types:
         * cache.r5.large,
         * cache.r5.xlarge,
         * cache.r5.2xlarge,
         * cache.r5.4xlarge,
         * cache.r5.12xlarge,
         * cache.r5.24xlarge
         *
         *
         *
         * R4 node types:
         * cache.r4.large,
         * cache.r4.xlarge,
         * cache.r4.2xlarge,
         * cache.r4.4xlarge,
         * cache.r4.8xlarge,
         * cache.r4.16xlarge
         *
         *
         *
         *
         *
         *
         *
         * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)
         *
         * M2 node types:
         * cache.m2.xlarge,
         * cache.m2.2xlarge,
         * cache.m2.4xlarge
         *
         *
         *
         * R3 node types:
         * cache.r3.large,
         * cache.r3.xlarge,
         * cache.r3.2xlarge,
         * cache.r3.4xlarge,
         * cache.r3.8xlarge
         *
         *
         *
         *
         *
         *
         *
         *
         * Additional node type info
         *
         *
         *
         * All current generation instance types are created in Amazon VPC by default.
         *
         * Redis append-only files (AOF) are not supported for T1 or T2 instances.
         *
         * Redis Multi-AZ with automatic failover is not supported on T1 instances.
         *
         * Redis configuration variables appendonly and
         * appendfsync are not supported on Redis version 2.8.22 and later.
         */
        var cacheNodeType: kotlin.String? = null
        /**
         * The duration filter value, specified in years or seconds.
         * Use this parameter to show only reservations for this duration.
         * Valid Values: 1 | 3 | 31536000 | 94608000
         */
        var duration: kotlin.String? = null
        /**
         * An optional marker returned from a prior request.
         * Use this marker for pagination of results from this operation.
         * If this parameter is specified, the response includes only records beyond the marker,
         * up to the value specified by MaxRecords.
         */
        var marker: kotlin.String? = null
        /**
         * The maximum number of records to include in the response. If more records exist than the
         * specified MaxRecords value, a marker is included in the response so that
         * the remaining results can be retrieved.
         *
         * Default: 100
         * Constraints: minimum 20; maximum 100.
         */
        var maxRecords: kotlin.Int? = null
        /**
         * The offering type filter value.
         * Use this parameter to show only the available offerings matching the specified offering type.
         * Valid values: "Light Utilization"|"Medium Utilization"|"Heavy Utilization"|"All Upfront"|"Partial Upfront"| "No Upfront"
         */
        var offeringType: kotlin.String? = null
        /**
         * The product description filter value. Use this parameter to show only those reservations matching the specified product description.
         */
        var productDescription: kotlin.String? = null
        /**
         * The reserved cache node identifier filter value.
         * Use this parameter to show only the reservation that matches the specified reservation ID.
         */
        var reservedCacheNodeId: kotlin.String? = null
        /**
         * The offering identifier filter value.
         * Use this parameter to show only purchased reservations matching the specified offering identifier.
         */
        var reservedCacheNodesOfferingId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.DescribeReservedCacheNodesRequest) : this() {
            this.cacheNodeType = x.cacheNodeType
            this.duration = x.duration
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.offeringType = x.offeringType
            this.productDescription = x.productDescription
            this.reservedCacheNodeId = x.reservedCacheNodeId
            this.reservedCacheNodesOfferingId = x.reservedCacheNodesOfferingId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.DescribeReservedCacheNodesRequest = DescribeReservedCacheNodesRequest(this)
    }
}
