// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model



/**
 * Represents a collection of cache nodes in a replication group.
 * One node in the node group is the read/write primary node.
 * All the other nodes are read-only Replica nodes.
 */
class NodeGroup private constructor(builder: Builder) {
    /**
     * The identifier for the node group (shard). A Redis (cluster mode disabled) replication group contains only 1 node group; therefore, the node group ID is 0001.
     * A Redis (cluster mode enabled) replication group contains 1 to 90 node groups numbered 0001 to 0090. Optionally, the user can provide the id for
     * a node group.
     */
    val nodeGroupId: kotlin.String? = builder.nodeGroupId
    /**
     * A list containing information about individual nodes within the node group (shard).
     */
    val nodeGroupMembers: List<NodeGroupMember>? = builder.nodeGroupMembers
    /**
     * The endpoint of the primary node in this node group (shard).
     */
    val primaryEndpoint: aws.sdk.kotlin.services.elasticache.model.Endpoint? = builder.primaryEndpoint
    /**
     * The endpoint of the replica nodes in this node group (shard).
     */
    val readerEndpoint: aws.sdk.kotlin.services.elasticache.model.Endpoint? = builder.readerEndpoint
    /**
     * The keyspace for this node group (shard).
     */
    val slots: kotlin.String? = builder.slots
    /**
     * The current state of this replication group - creating,
     * available, modifying, deleting.
     */
    val status: kotlin.String? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.NodeGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NodeGroup(")
        append("nodeGroupId=$nodeGroupId,")
        append("nodeGroupMembers=$nodeGroupMembers,")
        append("primaryEndpoint=$primaryEndpoint,")
        append("readerEndpoint=$readerEndpoint,")
        append("slots=$slots,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = nodeGroupId?.hashCode() ?: 0
        result = 31 * result + (nodeGroupMembers?.hashCode() ?: 0)
        result = 31 * result + (primaryEndpoint?.hashCode() ?: 0)
        result = 31 * result + (readerEndpoint?.hashCode() ?: 0)
        result = 31 * result + (slots?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NodeGroup

        if (nodeGroupId != other.nodeGroupId) return false
        if (nodeGroupMembers != other.nodeGroupMembers) return false
        if (primaryEndpoint != other.primaryEndpoint) return false
        if (readerEndpoint != other.readerEndpoint) return false
        if (slots != other.slots) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.NodeGroup = Builder(this).apply(block).build()

    class Builder {
        /**
         * The identifier for the node group (shard). A Redis (cluster mode disabled) replication group contains only 1 node group; therefore, the node group ID is 0001.
         * A Redis (cluster mode enabled) replication group contains 1 to 90 node groups numbered 0001 to 0090. Optionally, the user can provide the id for
         * a node group.
         */
        var nodeGroupId: kotlin.String? = null
        /**
         * A list containing information about individual nodes within the node group (shard).
         */
        var nodeGroupMembers: List<NodeGroupMember>? = null
        /**
         * The endpoint of the primary node in this node group (shard).
         */
        var primaryEndpoint: aws.sdk.kotlin.services.elasticache.model.Endpoint? = null
        /**
         * The endpoint of the replica nodes in this node group (shard).
         */
        var readerEndpoint: aws.sdk.kotlin.services.elasticache.model.Endpoint? = null
        /**
         * The keyspace for this node group (shard).
         */
        var slots: kotlin.String? = null
        /**
         * The current state of this replication group - creating,
         * available, modifying, deleting.
         */
        var status: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.NodeGroup) : this() {
            this.nodeGroupId = x.nodeGroupId
            this.nodeGroupMembers = x.nodeGroupMembers
            this.primaryEndpoint = x.primaryEndpoint
            this.readerEndpoint = x.readerEndpoint
            this.slots = x.slots
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.NodeGroup = NodeGroup(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticache.model.Endpoint] inside the given [block]
         */
        fun primaryEndpoint(block: aws.sdk.kotlin.services.elasticache.model.Endpoint.Builder.() -> kotlin.Unit) {
            this.primaryEndpoint = aws.sdk.kotlin.services.elasticache.model.Endpoint.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticache.model.Endpoint] inside the given [block]
         */
        fun readerEndpoint(block: aws.sdk.kotlin.services.elasticache.model.Endpoint.Builder.() -> kotlin.Unit) {
            this.readerEndpoint = aws.sdk.kotlin.services.elasticache.model.Endpoint.invoke(block)
        }
    }
}
