// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model



/**
 * Describes all of the attributes of a reserved cache node offering.
 */
class ReservedCacheNodesOffering private constructor(builder: Builder) {
    /**
     * The cache node type for the reserved cache node.
     * The following node types are supported by ElastiCache.
     * Generally speaking, the current generation types provide more memory and computational power
     * at lower cost when compared to their equivalent previous generation counterparts.
     *
     *
     * General purpose:
     *
     *
     * Current generation:
     *
     *
     *
     *
     * M6g node types: (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): 	cache.m6g.large,
     * cache.m6g.xlarge,
     * cache.m6g.2xlarge,
     * cache.m6g.4xlarge,
     * cache.m6g.8xlarge,
     * cache.m6g.12xlarge,
     * cache.m6g.16xlarge
     *
     *
     *
     *
     * For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types
     *
     *
     *
     *
     * M5 node types:
     * cache.m5.large,
     * cache.m5.xlarge,
     * cache.m5.2xlarge,
     * cache.m5.4xlarge,
     * cache.m5.12xlarge,
     * cache.m5.24xlarge
     *
     *
     *
     *
     *
     * M4 node types:
     * cache.m4.large,
     * cache.m4.xlarge,
     * cache.m4.2xlarge,
     * cache.m4.4xlarge,
     * cache.m4.10xlarge
     *
     *
     *
     * T4g node types (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward):
     * cache.t4g.micro,
     * cache.t4g.small,
     * cache.t4g.medium
     *
     *
     *
     * T3 node types:
     * cache.t3.micro,
     * cache.t3.small,
     * cache.t3.medium
     *
     *
     *
     *
     * T2 node types:
     * cache.t2.micro,
     * cache.t2.small,
     * cache.t2.medium
     *
     *
     *
     *
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)
     *
     * T1 node types:
     * cache.t1.micro
     *
     *
     *
     * M1 node types:
     * cache.m1.small,
     * cache.m1.medium,
     * cache.m1.large,
     * cache.m1.xlarge
     *
     *
     *
     * M3 node types:
     * cache.m3.medium,
     * cache.m3.large,
     * cache.m3.xlarge,
     * cache.m3.2xlarge
     *
     *
     *
     *
     *
     * Compute optimized:
     *
     *
     *
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)
     *
     * C1 node types:
     * cache.c1.xlarge
     *
     *
     *
     *
     * Memory optimized with data tiering:
     *
     *
     * Current generation:
     *
     *
     * R6gd node types (available only for Redis engine version 6.2 onward).
     *
     *
     *
     * cache.r6gd.xlarge,
     * cache.r6gd.2xlarge,
     * cache.r6gd.4xlarge,
     * cache.r6gd.8xlarge,
     * cache.r6gd.12xlarge,
     * cache.r6gd.16xlarge
     *
     *
     *
     *
     *
     * Memory optimized:
     *
     *
     * Current generation:
     *
     *
     *
     *
     * R6g node types (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).
     *
     *
     *
     *
     * cache.r6g.large,
     * cache.r6g.xlarge,
     * cache.r6g.2xlarge,
     * cache.r6g.4xlarge,
     * cache.r6g.8xlarge,
     * cache.r6g.12xlarge,
     * cache.r6g.16xlarge
     *
     *
     *
     * For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types
     *
     *
     *
     * R5 node types:
     * cache.r5.large,
     * cache.r5.xlarge,
     * cache.r5.2xlarge,
     * cache.r5.4xlarge,
     * cache.r5.12xlarge,
     * cache.r5.24xlarge
     *
     *
     *
     * R4 node types:
     * cache.r4.large,
     * cache.r4.xlarge,
     * cache.r4.2xlarge,
     * cache.r4.4xlarge,
     * cache.r4.8xlarge,
     * cache.r4.16xlarge
     *
     *
     *
     *
     *
     *
     *
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)
     *
     * M2 node types:
     * cache.m2.xlarge,
     * cache.m2.2xlarge,
     * cache.m2.4xlarge
     *
     *
     *
     * R3 node types:
     * cache.r3.large,
     * cache.r3.xlarge,
     * cache.r3.2xlarge,
     * cache.r3.4xlarge,
     * cache.r3.8xlarge
     *
     *
     *
     *
     *
     *
     *
     *
     * Additional node type info
     *
     *
     *
     * All current generation instance types are created in Amazon VPC by default.
     *
     * Redis append-only files (AOF) are not supported for T1 or T2 instances.
     *
     * Redis Multi-AZ with automatic failover is not supported on T1 instances.
     *
     * Redis configuration variables appendonly and
     * appendfsync are not supported on Redis version 2.8.22 and later.
     */
    val cacheNodeType: kotlin.String? = builder.cacheNodeType
    /**
     * The duration of the offering. in seconds.
     */
    val duration: kotlin.Int = builder.duration
    /**
     * The fixed price charged for this offering.
     */
    val fixedPrice: kotlin.Double = builder.fixedPrice
    /**
     * The offering type.
     */
    val offeringType: kotlin.String? = builder.offeringType
    /**
     * The cache engine used by the offering.
     */
    val productDescription: kotlin.String? = builder.productDescription
    /**
     * The recurring price charged to run this reserved cache node.
     */
    val recurringCharges: List<RecurringCharge>? = builder.recurringCharges
    /**
     * A unique identifier for the reserved cache node offering.
     */
    val reservedCacheNodesOfferingId: kotlin.String? = builder.reservedCacheNodesOfferingId
    /**
     * The hourly price charged for this offering.
     */
    val usagePrice: kotlin.Double = builder.usagePrice

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.ReservedCacheNodesOffering = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReservedCacheNodesOffering(")
        append("cacheNodeType=$cacheNodeType,")
        append("duration=$duration,")
        append("fixedPrice=$fixedPrice,")
        append("offeringType=$offeringType,")
        append("productDescription=$productDescription,")
        append("recurringCharges=$recurringCharges,")
        append("reservedCacheNodesOfferingId=$reservedCacheNodesOfferingId,")
        append("usagePrice=$usagePrice)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheNodeType?.hashCode() ?: 0
        result = 31 * result + (duration)
        result = 31 * result + (fixedPrice.hashCode())
        result = 31 * result + (offeringType?.hashCode() ?: 0)
        result = 31 * result + (productDescription?.hashCode() ?: 0)
        result = 31 * result + (recurringCharges?.hashCode() ?: 0)
        result = 31 * result + (reservedCacheNodesOfferingId?.hashCode() ?: 0)
        result = 31 * result + (usagePrice.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReservedCacheNodesOffering

        if (cacheNodeType != other.cacheNodeType) return false
        if (duration != other.duration) return false
        if (fixedPrice != other.fixedPrice) return false
        if (offeringType != other.offeringType) return false
        if (productDescription != other.productDescription) return false
        if (recurringCharges != other.recurringCharges) return false
        if (reservedCacheNodesOfferingId != other.reservedCacheNodesOfferingId) return false
        if (usagePrice != other.usagePrice) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.ReservedCacheNodesOffering = Builder(this).apply(block).build()

    class Builder {
        /**
         * The cache node type for the reserved cache node.
         * The following node types are supported by ElastiCache.
         * Generally speaking, the current generation types provide more memory and computational power
         * at lower cost when compared to their equivalent previous generation counterparts.
         *
         *
         * General purpose:
         *
         *
         * Current generation:
         *
         *
         *
         *
         * M6g node types: (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): 	cache.m6g.large,
         * cache.m6g.xlarge,
         * cache.m6g.2xlarge,
         * cache.m6g.4xlarge,
         * cache.m6g.8xlarge,
         * cache.m6g.12xlarge,
         * cache.m6g.16xlarge
         *
         *
         *
         *
         * For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types
         *
         *
         *
         *
         * M5 node types:
         * cache.m5.large,
         * cache.m5.xlarge,
         * cache.m5.2xlarge,
         * cache.m5.4xlarge,
         * cache.m5.12xlarge,
         * cache.m5.24xlarge
         *
         *
         *
         *
         *
         * M4 node types:
         * cache.m4.large,
         * cache.m4.xlarge,
         * cache.m4.2xlarge,
         * cache.m4.4xlarge,
         * cache.m4.10xlarge
         *
         *
         *
         * T4g node types (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward):
         * cache.t4g.micro,
         * cache.t4g.small,
         * cache.t4g.medium
         *
         *
         *
         * T3 node types:
         * cache.t3.micro,
         * cache.t3.small,
         * cache.t3.medium
         *
         *
         *
         *
         * T2 node types:
         * cache.t2.micro,
         * cache.t2.small,
         * cache.t2.medium
         *
         *
         *
         *
         * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)
         *
         * T1 node types:
         * cache.t1.micro
         *
         *
         *
         * M1 node types:
         * cache.m1.small,
         * cache.m1.medium,
         * cache.m1.large,
         * cache.m1.xlarge
         *
         *
         *
         * M3 node types:
         * cache.m3.medium,
         * cache.m3.large,
         * cache.m3.xlarge,
         * cache.m3.2xlarge
         *
         *
         *
         *
         *
         * Compute optimized:
         *
         *
         *
         * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)
         *
         * C1 node types:
         * cache.c1.xlarge
         *
         *
         *
         *
         * Memory optimized with data tiering:
         *
         *
         * Current generation:
         *
         *
         * R6gd node types (available only for Redis engine version 6.2 onward).
         *
         *
         *
         * cache.r6gd.xlarge,
         * cache.r6gd.2xlarge,
         * cache.r6gd.4xlarge,
         * cache.r6gd.8xlarge,
         * cache.r6gd.12xlarge,
         * cache.r6gd.16xlarge
         *
         *
         *
         *
         *
         * Memory optimized:
         *
         *
         * Current generation:
         *
         *
         *
         *
         * R6g node types (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).
         *
         *
         *
         *
         * cache.r6g.large,
         * cache.r6g.xlarge,
         * cache.r6g.2xlarge,
         * cache.r6g.4xlarge,
         * cache.r6g.8xlarge,
         * cache.r6g.12xlarge,
         * cache.r6g.16xlarge
         *
         *
         *
         * For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types
         *
         *
         *
         * R5 node types:
         * cache.r5.large,
         * cache.r5.xlarge,
         * cache.r5.2xlarge,
         * cache.r5.4xlarge,
         * cache.r5.12xlarge,
         * cache.r5.24xlarge
         *
         *
         *
         * R4 node types:
         * cache.r4.large,
         * cache.r4.xlarge,
         * cache.r4.2xlarge,
         * cache.r4.4xlarge,
         * cache.r4.8xlarge,
         * cache.r4.16xlarge
         *
         *
         *
         *
         *
         *
         *
         * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)
         *
         * M2 node types:
         * cache.m2.xlarge,
         * cache.m2.2xlarge,
         * cache.m2.4xlarge
         *
         *
         *
         * R3 node types:
         * cache.r3.large,
         * cache.r3.xlarge,
         * cache.r3.2xlarge,
         * cache.r3.4xlarge,
         * cache.r3.8xlarge
         *
         *
         *
         *
         *
         *
         *
         *
         * Additional node type info
         *
         *
         *
         * All current generation instance types are created in Amazon VPC by default.
         *
         * Redis append-only files (AOF) are not supported for T1 or T2 instances.
         *
         * Redis Multi-AZ with automatic failover is not supported on T1 instances.
         *
         * Redis configuration variables appendonly and
         * appendfsync are not supported on Redis version 2.8.22 and later.
         */
        var cacheNodeType: kotlin.String? = null
        /**
         * The duration of the offering. in seconds.
         */
        var duration: kotlin.Int = 0
        /**
         * The fixed price charged for this offering.
         */
        var fixedPrice: kotlin.Double = 0.0
        /**
         * The offering type.
         */
        var offeringType: kotlin.String? = null
        /**
         * The cache engine used by the offering.
         */
        var productDescription: kotlin.String? = null
        /**
         * The recurring price charged to run this reserved cache node.
         */
        var recurringCharges: List<RecurringCharge>? = null
        /**
         * A unique identifier for the reserved cache node offering.
         */
        var reservedCacheNodesOfferingId: kotlin.String? = null
        /**
         * The hourly price charged for this offering.
         */
        var usagePrice: kotlin.Double = 0.0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.ReservedCacheNodesOffering) : this() {
            this.cacheNodeType = x.cacheNodeType
            this.duration = x.duration
            this.fixedPrice = x.fixedPrice
            this.offeringType = x.offeringType
            this.productDescription = x.productDescription
            this.recurringCharges = x.recurringCharges
            this.reservedCacheNodesOfferingId = x.reservedCacheNodesOfferingId
            this.usagePrice = x.usagePrice
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.ReservedCacheNodesOffering = ReservedCacheNodesOffering(this)
    }
}
