// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.elasticache.model.CreateReplicationGroupResponse
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.sdk.kotlin.services.elasticache.model.ReplicationGroup
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class CreateReplicationGroupOperationDeserializer: HttpDeserialize<CreateReplicationGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateReplicationGroupResponse {
        if (!response.status.isSuccess()) {
            throwCreateReplicationGroupError(context, response)
        }
        val builder = CreateReplicationGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateReplicationGroupOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateReplicationGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CacheClusterNotFound" -> CacheClusterNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "CacheParameterGroupNotFound" -> CacheParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "CacheSecurityGroupNotFound" -> CacheSecurityGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "CacheSubnetGroupNotFoundFault" -> CacheSubnetGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "ClusterQuotaForCustomerExceeded" -> ClusterQuotaForCustomerExceededFaultDeserializer().deserialize(context, wrappedResponse)
        "GlobalReplicationGroupNotFoundFault" -> GlobalReplicationGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "InsufficientCacheClusterCapacity" -> InsufficientCacheClusterCapacityFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidCacheClusterState" -> InvalidCacheClusterStateFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidGlobalReplicationGroupState" -> InvalidGlobalReplicationGroupStateFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterCombination" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidUserGroupState" -> InvalidUserGroupStateFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidVPCNetworkStateFault" -> InvalidVpcNetworkStateFaultDeserializer().deserialize(context, wrappedResponse)
        "NodeGroupsPerReplicationGroupQuotaExceeded" -> NodeGroupsPerReplicationGroupQuotaExceededFaultDeserializer().deserialize(context, wrappedResponse)
        "NodeQuotaForClusterExceeded" -> NodeQuotaForClusterExceededFaultDeserializer().deserialize(context, wrappedResponse)
        "NodeQuotaForCustomerExceeded" -> NodeQuotaForCustomerExceededFaultDeserializer().deserialize(context, wrappedResponse)
        "ReplicationGroupAlreadyExists" -> ReplicationGroupAlreadyExistsFaultDeserializer().deserialize(context, wrappedResponse)
        "TagQuotaPerResourceExceeded" -> TagQuotaPerResourceExceededDeserializer().deserialize(context, wrappedResponse)
        "UserGroupNotFound" -> UserGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateReplicationGroupOperationBody(builder: CreateReplicationGroupResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("CreateReplicationGroupResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("CreateReplicationGroupResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap CreateReplicationGroup response")
    }
    // end unwrap response wrapper

    val REPLICATIONGROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ReplicationGroup"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticache.amazonaws.com/doc/2015-02-02/"))
        trait(XmlSerialName("CreateReplicationGroupResult"))
        field(REPLICATIONGROUP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                REPLICATIONGROUP_DESCRIPTOR.index -> builder.replicationGroup = deserializeReplicationGroupDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
