// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.elasticache.endpoints.internal.ResolveEndpointMiddleware
import aws.sdk.kotlin.services.elasticache.endpoints.internal.bindAwsBuiltins
import aws.sdk.kotlin.services.elasticache.model.*
import aws.sdk.kotlin.services.elasticache.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.middleware.MutateHeaders
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "ElastiCache"
public const val ServiceApiVersion: String = "2015-02-02"
public const val SdkVersion: String = "0.19.1-beta"

internal class DefaultElastiCacheClient(override val config: ElastiCacheClient.Config) : ElastiCacheClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. For more information, see [Resource-level permissions](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html).
     *
     *  For example, you can use cost-allocation tags to your ElastiCache resources, Amazon generates a cost allocation report as a comma-separated value (CSV) file with your usage and costs aggregated by your tags. You can apply tags that represent business categories (such as cost centers, application names, or owners) to organize your costs across multiple services.
     *
     * For more information, see [Using Cost Allocation Tags in Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Tagging.html) in the *ElastiCache User Guide*.
     */
    override suspend fun addTagsToResource(input: AddTagsToResourceRequest): AddTagsToResourceResponse {
        val op = SdkHttpOperation.build<AddTagsToResourceRequest, AddTagsToResourceResponse> {
            serializer = AddTagsToResourceOperationSerializer()
            deserializer = AddTagsToResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddTagsToResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("AddTagsToResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Allows network ingress to a cache security group. Applications using ElastiCache must be running on Amazon EC2, and Amazon EC2 security groups are used as the authorization mechanism.
     *
     * You cannot authorize ingress from an Amazon EC2 security group in one region to an ElastiCache cluster in another region.
     */
    override suspend fun authorizeCacheSecurityGroupIngress(input: AuthorizeCacheSecurityGroupIngressRequest): AuthorizeCacheSecurityGroupIngressResponse {
        val op = SdkHttpOperation.build<AuthorizeCacheSecurityGroupIngressRequest, AuthorizeCacheSecurityGroupIngressResponse> {
            serializer = AuthorizeCacheSecurityGroupIngressOperationSerializer()
            deserializer = AuthorizeCacheSecurityGroupIngressOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AuthorizeCacheSecurityGroupIngress"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("AuthorizeCacheSecurityGroupIngress-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Apply the service update. For more information on service updates and applying them, see [Applying Service Updates](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/applying-updates.html).
     */
    override suspend fun batchApplyUpdateAction(input: BatchApplyUpdateActionRequest): BatchApplyUpdateActionResponse {
        val op = SdkHttpOperation.build<BatchApplyUpdateActionRequest, BatchApplyUpdateActionResponse> {
            serializer = BatchApplyUpdateActionOperationSerializer()
            deserializer = BatchApplyUpdateActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchApplyUpdateAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("BatchApplyUpdateAction-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Stop the service update. For more information on service updates and stopping them, see [Stopping Service Updates](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/stopping-self-service-updates.html).
     */
    override suspend fun batchStopUpdateAction(input: BatchStopUpdateActionRequest): BatchStopUpdateActionResponse {
        val op = SdkHttpOperation.build<BatchStopUpdateActionRequest, BatchStopUpdateActionResponse> {
            serializer = BatchStopUpdateActionOperationSerializer()
            deserializer = BatchStopUpdateActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchStopUpdateAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("BatchStopUpdateAction-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Complete the migration of data.
     */
    override suspend fun completeMigration(input: CompleteMigrationRequest): CompleteMigrationResponse {
        val op = SdkHttpOperation.build<CompleteMigrationRequest, CompleteMigrationResponse> {
            serializer = CompleteMigrationOperationSerializer()
            deserializer = CompleteMigrationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CompleteMigration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CompleteMigration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Makes a copy of an existing snapshot.
     *
     * This operation is valid for Redis only.
     *
     * Users or groups that have permissions to use the `CopySnapshot` operation can create their own Amazon S3 buckets and copy snapshots to it. To control access to your snapshots, use an IAM policy to control who has the ability to use the `CopySnapshot` operation. For more information about using IAM to control the use of ElastiCache operations, see [Exporting Snapshots](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html) and [Authentication & Access Control](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.html).
     *
     * You could receive the following error messages.
     *
     * **Error Messages**
     * + **Error Message:** The S3 bucket %s is outside of the region.**Solution:** Create an Amazon S3 bucket in the same region as your snapshot. For more information, see [Step 1: Create an Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket) in the ElastiCache User Guide.
     * + **Error Message:** The S3 bucket %s does not exist.**Solution:** Create an Amazon S3 bucket in the same region as your snapshot. For more information, see [Step 1: Create an Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket) in the ElastiCache User Guide.
     * + **Error Message:** The S3 bucket %s is not owned by the authenticated user.**Solution:** Create an Amazon S3 bucket in the same region as your snapshot. For more information, see [Step 1: Create an Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket) in the ElastiCache User Guide.
     * + **Error Message:** The authenticated user does not have sufficient permissions to perform the desired activity.**Solution:** Contact your system administrator to get the needed permissions.
     * + **Error Message:** The S3 bucket %s already contains an object with key %s.**Solution:** Give the `TargetSnapshotName` a new and unique value. If exporting a snapshot, you could alternatively create a new Amazon S3 bucket and use this same value for `TargetSnapshotName`.
     * + **Error Message: ** ElastiCache has not been granted READ permissions %s on the S3 Bucket.**Solution:** Add List and Read permissions on the bucket. For more information, see [Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access) in the ElastiCache User Guide.
     * + **Error Message: ** ElastiCache has not been granted WRITE permissions %s on the S3 Bucket.**Solution:** Add Upload/Delete permissions on the bucket. For more information, see [Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access) in the ElastiCache User Guide.
     * + **Error Message: ** ElastiCache has not been granted READ_ACP permissions %s on the S3 Bucket.**Solution:** Add View Permissions on the bucket. For more information, see [Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access) in the ElastiCache User Guide.
     */
    override suspend fun copySnapshot(input: CopySnapshotRequest): CopySnapshotResponse {
        val op = SdkHttpOperation.build<CopySnapshotRequest, CopySnapshotResponse> {
            serializer = CopySnapshotOperationSerializer()
            deserializer = CopySnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CopySnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CopySnapshot-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a cluster. All nodes in the cluster run the same protocol-compliant cache engine software, either Memcached or Redis.
     *
     * This operation is not supported for Redis (cluster mode enabled) clusters.
     */
    override suspend fun createCacheCluster(input: CreateCacheClusterRequest): CreateCacheClusterResponse {
        val op = SdkHttpOperation.build<CreateCacheClusterRequest, CreateCacheClusterResponse> {
            serializer = CreateCacheClusterOperationSerializer()
            deserializer = CreateCacheClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCacheCluster"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateCacheCluster-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new Amazon ElastiCache cache parameter group. An ElastiCache cache parameter group is a collection of parameters and their values that are applied to all of the nodes in any cluster or replication group using the CacheParameterGroup.
     *
     * A newly created CacheParameterGroup is an exact duplicate of the default parameter group for the CacheParameterGroupFamily. To customize the newly created CacheParameterGroup you can change the values of specific parameters. For more information, see:
     * + [ModifyCacheParameterGroup](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheParameterGroup.html) in the ElastiCache API Reference.
     * + [Parameters and Parameter Groups](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ParameterGroups.html) in the ElastiCache User Guide.
     */
    override suspend fun createCacheParameterGroup(input: CreateCacheParameterGroupRequest): CreateCacheParameterGroupResponse {
        val op = SdkHttpOperation.build<CreateCacheParameterGroupRequest, CreateCacheParameterGroupResponse> {
            serializer = CreateCacheParameterGroupOperationSerializer()
            deserializer = CreateCacheParameterGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCacheParameterGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateCacheParameterGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new cache security group. Use a cache security group to control access to one or more clusters.
     *
     * Cache security groups are only used when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon VPC). If you are creating a cluster inside of a VPC, use a cache subnet group instead. For more information, see [CreateCacheSubnetGroup](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateCacheSubnetGroup.html).
     */
    override suspend fun createCacheSecurityGroup(input: CreateCacheSecurityGroupRequest): CreateCacheSecurityGroupResponse {
        val op = SdkHttpOperation.build<CreateCacheSecurityGroupRequest, CreateCacheSecurityGroupResponse> {
            serializer = CreateCacheSecurityGroupOperationSerializer()
            deserializer = CreateCacheSecurityGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCacheSecurityGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateCacheSecurityGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new cache subnet group.
     *
     * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
     */
    override suspend fun createCacheSubnetGroup(input: CreateCacheSubnetGroupRequest): CreateCacheSubnetGroupResponse {
        val op = SdkHttpOperation.build<CreateCacheSubnetGroupRequest, CreateCacheSubnetGroupResponse> {
            serializer = CreateCacheSubnetGroupOperationSerializer()
            deserializer = CreateCacheSubnetGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCacheSubnetGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateCacheSubnetGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Global Datastore for Redis offers fully managed, fast, reliable and secure cross-region replication. Using Global Datastore for Redis, you can create cross-region read replica clusters for ElastiCache for Redis to enable low-latency reads and disaster recovery across regions. For more information, see [Replication Across Regions Using Global Datastore](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Redis-Global-Datastore.html).
     * + The **GlobalReplicationGroupIdSuffix** is the name of the Global datastore.
     * + The **PrimaryReplicationGroupId** represents the name of the primary cluster that accepts writes and will replicate updates to the secondary cluster.
     */
    override suspend fun createGlobalReplicationGroup(input: CreateGlobalReplicationGroupRequest): CreateGlobalReplicationGroupResponse {
        val op = SdkHttpOperation.build<CreateGlobalReplicationGroupRequest, CreateGlobalReplicationGroupResponse> {
            serializer = CreateGlobalReplicationGroupOperationSerializer()
            deserializer = CreateGlobalReplicationGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateGlobalReplicationGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateGlobalReplicationGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group.
     *
     * This API can be used to create a standalone regional replication group or a secondary replication group associated with a Global datastore.
     *
     * A Redis (cluster mode disabled) replication group is a collection of clusters, where one of the clusters is a read/write primary and the others are read-only replicas. Writes to the primary are asynchronously propagated to the replicas.
     *
     * A Redis cluster-mode enabled cluster is comprised of from 1 to 90 shards (API/CLI: node groups). Each shard has a primary node and up to 5 read-only replica nodes. The configuration can range from 90 shards and 0 replicas to 15 shards and 5 replicas, which is the maximum number or replicas allowed.
     *
     * The node or shard limit can be increased to a maximum of 500 per cluster if the Redis engine version is 5.0.6 or higher. For example, you can choose to configure a 500 node cluster that ranges between 83 shards (one primary and 5 replicas per shard) and 500 shards (single primary and no replicas). Make sure there are enough available IP addresses to accommodate the increase. Common pitfalls include the subnets in the subnet group have too small a CIDR range or the subnets are shared and heavily used by other clusters. For more information, see [Creating a Subnet Group](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.Creating.html). For versions below 5.0.6, the limit is 250 per cluster.
     *
     * To request a limit increase, see [Amazon Service Limits](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html) and choose the limit type **Nodes per cluster per instance type**.
     *
     * When a Redis (cluster mode disabled) replication group has been successfully created, you can add one or more read replicas to it, up to a total of 5 read replicas. If you need to increase or decrease the number of node groups (console: shards), you can avail yourself of ElastiCache for Redis' scaling. For more information, see [Scaling ElastiCache for Redis Clusters](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Scaling.html) in the *ElastiCache User Guide*.
     *
     * This operation is valid for Redis only.
     */
    override suspend fun createReplicationGroup(input: CreateReplicationGroupRequest): CreateReplicationGroupResponse {
        val op = SdkHttpOperation.build<CreateReplicationGroupRequest, CreateReplicationGroupResponse> {
            serializer = CreateReplicationGroupOperationSerializer()
            deserializer = CreateReplicationGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateReplicationGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateReplicationGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a copy of an entire cluster or replication group at a specific moment in time.
     *
     * This operation is valid for Redis only.
     */
    override suspend fun createSnapshot(input: CreateSnapshotRequest): CreateSnapshotResponse {
        val op = SdkHttpOperation.build<CreateSnapshotRequest, CreateSnapshotResponse> {
            serializer = CreateSnapshotOperationSerializer()
            deserializer = CreateSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateSnapshot-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * For Redis engine version 6.0 onwards: Creates a Redis user. For more information, see [Using Role Based Access Control (RBAC)](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html).
     */
    override suspend fun createUser(input: CreateUserRequest): CreateUserResponse {
        val op = SdkHttpOperation.build<CreateUserRequest, CreateUserResponse> {
            serializer = CreateUserOperationSerializer()
            deserializer = CreateUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateUser-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * For Redis engine version 6.0 onwards: Creates a Redis user group. For more information, see [Using Role Based Access Control (RBAC)](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html)
     */
    override suspend fun createUserGroup(input: CreateUserGroupRequest): CreateUserGroupResponse {
        val op = SdkHttpOperation.build<CreateUserGroupRequest, CreateUserGroupResponse> {
            serializer = CreateUserGroupOperationSerializer()
            deserializer = CreateUserGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateUserGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateUserGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Decreases the number of node groups in a Global datastore
     */
    override suspend fun decreaseNodeGroupsInGlobalReplicationGroup(input: DecreaseNodeGroupsInGlobalReplicationGroupRequest): DecreaseNodeGroupsInGlobalReplicationGroupResponse {
        val op = SdkHttpOperation.build<DecreaseNodeGroupsInGlobalReplicationGroupRequest, DecreaseNodeGroupsInGlobalReplicationGroupResponse> {
            serializer = DecreaseNodeGroupsInGlobalReplicationGroupOperationSerializer()
            deserializer = DecreaseNodeGroupsInGlobalReplicationGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DecreaseNodeGroupsInGlobalReplicationGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DecreaseNodeGroupsInGlobalReplicationGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Dynamically decreases the number of replicas in a Redis (cluster mode disabled) replication group or the number of replica nodes in one or more node groups (shards) of a Redis (cluster mode enabled) replication group. This operation is performed with no cluster down time.
     */
    override suspend fun decreaseReplicaCount(input: DecreaseReplicaCountRequest): DecreaseReplicaCountResponse {
        val op = SdkHttpOperation.build<DecreaseReplicaCountRequest, DecreaseReplicaCountResponse> {
            serializer = DecreaseReplicaCountOperationSerializer()
            deserializer = DecreaseReplicaCountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DecreaseReplicaCount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DecreaseReplicaCount-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a previously provisioned cluster. `DeleteCacheCluster` deletes all associated cache nodes, node endpoints and the cluster itself. When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the cluster; you cannot cancel or revert this operation.
     *
     * This operation is not valid for:
     * + Redis (cluster mode enabled) clusters
     * + Redis (cluster mode disabled) clusters
     * + A cluster that is the last read replica of a replication group
     * + A cluster that is the primary node of a replication group
     * + A node group (shard) that has Multi-AZ mode enabled
     * + A cluster from a Redis (cluster mode enabled) replication group
     * + A cluster that is not in the `available` state
     */
    override suspend fun deleteCacheCluster(input: DeleteCacheClusterRequest): DeleteCacheClusterResponse {
        val op = SdkHttpOperation.build<DeleteCacheClusterRequest, DeleteCacheClusterResponse> {
            serializer = DeleteCacheClusterOperationSerializer()
            deserializer = DeleteCacheClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCacheCluster"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteCacheCluster-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the specified cache parameter group. You cannot delete a cache parameter group if it is associated with any cache clusters. You cannot delete the default cache parameter groups in your account.
     */
    override suspend fun deleteCacheParameterGroup(input: DeleteCacheParameterGroupRequest): DeleteCacheParameterGroupResponse {
        val op = SdkHttpOperation.build<DeleteCacheParameterGroupRequest, DeleteCacheParameterGroupResponse> {
            serializer = DeleteCacheParameterGroupOperationSerializer()
            deserializer = DeleteCacheParameterGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCacheParameterGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteCacheParameterGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a cache security group.
     *
     * You cannot delete a cache security group if it is associated with any clusters.
     */
    override suspend fun deleteCacheSecurityGroup(input: DeleteCacheSecurityGroupRequest): DeleteCacheSecurityGroupResponse {
        val op = SdkHttpOperation.build<DeleteCacheSecurityGroupRequest, DeleteCacheSecurityGroupResponse> {
            serializer = DeleteCacheSecurityGroupOperationSerializer()
            deserializer = DeleteCacheSecurityGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCacheSecurityGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteCacheSecurityGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a cache subnet group.
     *
     * You cannot delete a default cache subnet group or one that is associated with any clusters.
     */
    override suspend fun deleteCacheSubnetGroup(input: DeleteCacheSubnetGroupRequest): DeleteCacheSubnetGroupResponse {
        val op = SdkHttpOperation.build<DeleteCacheSubnetGroupRequest, DeleteCacheSubnetGroupResponse> {
            serializer = DeleteCacheSubnetGroupOperationSerializer()
            deserializer = DeleteCacheSubnetGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCacheSubnetGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteCacheSubnetGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deleting a Global datastore is a two-step process:
     * + First, you must DisassociateGlobalReplicationGroup to remove the secondary clusters in the Global datastore.
     * + Once the Global datastore contains only the primary cluster, you can use the `DeleteGlobalReplicationGroup` API to delete the Global datastore while retainining the primary cluster using `RetainPrimaryReplicationGroup=true`.
     *
     * Since the Global Datastore has only a primary cluster, you can delete the Global Datastore while retaining the primary by setting `RetainPrimaryReplicationGroup=true`. The primary cluster is never deleted when deleting a Global Datastore. It can only be deleted when it no longer is associated with any Global Datastore.
     *
     * When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the selected resources; you cannot cancel or revert this operation.
     */
    override suspend fun deleteGlobalReplicationGroup(input: DeleteGlobalReplicationGroupRequest): DeleteGlobalReplicationGroupResponse {
        val op = SdkHttpOperation.build<DeleteGlobalReplicationGroupRequest, DeleteGlobalReplicationGroupResponse> {
            serializer = DeleteGlobalReplicationGroupOperationSerializer()
            deserializer = DeleteGlobalReplicationGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteGlobalReplicationGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteGlobalReplicationGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an existing replication group. By default, this operation deletes the entire replication group, including the primary/primaries and all of the read replicas. If the replication group has only one primary, you can optionally delete only the read replicas, while retaining the primary by setting `RetainPrimaryCluster=true`.
     *
     * When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the selected resources; you cannot cancel or revert this operation.
     *
     * This operation is valid for Redis only.
     */
    override suspend fun deleteReplicationGroup(input: DeleteReplicationGroupRequest): DeleteReplicationGroupResponse {
        val op = SdkHttpOperation.build<DeleteReplicationGroupRequest, DeleteReplicationGroupResponse> {
            serializer = DeleteReplicationGroupOperationSerializer()
            deserializer = DeleteReplicationGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteReplicationGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteReplicationGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an existing snapshot. When you receive a successful response from this operation, ElastiCache immediately begins deleting the snapshot; you cannot cancel or revert this operation.
     *
     * This operation is valid for Redis only.
     */
    override suspend fun deleteSnapshot(input: DeleteSnapshotRequest): DeleteSnapshotResponse {
        val op = SdkHttpOperation.build<DeleteSnapshotRequest, DeleteSnapshotResponse> {
            serializer = DeleteSnapshotOperationSerializer()
            deserializer = DeleteSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteSnapshot-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * For Redis engine version 6.0 onwards: Deletes a user. The user will be removed from all user groups and in turn removed from all replication groups. For more information, see [Using Role Based Access Control (RBAC)](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html).
     */
    override suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse {
        val op = SdkHttpOperation.build<DeleteUserRequest, DeleteUserResponse> {
            serializer = DeleteUserOperationSerializer()
            deserializer = DeleteUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteUser-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * For Redis engine version 6.0 onwards: Deletes a user group. The user group must first be disassociated from the replication group before it can be deleted. For more information, see [Using Role Based Access Control (RBAC)](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html).
     */
    override suspend fun deleteUserGroup(input: DeleteUserGroupRequest): DeleteUserGroupResponse {
        val op = SdkHttpOperation.build<DeleteUserGroupRequest, DeleteUserGroupResponse> {
            serializer = DeleteUserGroupOperationSerializer()
            deserializer = DeleteUserGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteUserGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteUserGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific cache cluster if a cluster identifier is supplied.
     *
     * By default, abbreviated information about the clusters is returned. You can use the optional *ShowCacheNodeInfo* flag to retrieve detailed information about the cache nodes associated with the clusters. These details include the DNS address and port for the cache node endpoint.
     *
     * If the cluster is in the *creating* state, only cluster-level information is displayed until all of the nodes are successfully provisioned.
     *
     * If the cluster is in the *deleting* state, only cluster-level information is displayed.
     *
     * If cache nodes are currently being added to the cluster, node endpoint information and creation time for the additional nodes are not displayed until they are completely provisioned. When the cluster state is *available*, the cluster is ready for use.
     *
     * If cache nodes are currently being removed from the cluster, no endpoint information for the removed nodes is displayed.
     */
    override suspend fun describeCacheClusters(input: DescribeCacheClustersRequest): DescribeCacheClustersResponse {
        val op = SdkHttpOperation.build<DescribeCacheClustersRequest, DescribeCacheClustersResponse> {
            serializer = DescribeCacheClustersOperationSerializer()
            deserializer = DescribeCacheClustersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCacheClusters"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DescribeCacheClusters-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of the available cache engines and their versions.
     */
    override suspend fun describeCacheEngineVersions(input: DescribeCacheEngineVersionsRequest): DescribeCacheEngineVersionsResponse {
        val op = SdkHttpOperation.build<DescribeCacheEngineVersionsRequest, DescribeCacheEngineVersionsResponse> {
            serializer = DescribeCacheEngineVersionsOperationSerializer()
            deserializer = DescribeCacheEngineVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCacheEngineVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DescribeCacheEngineVersions-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of cache parameter group descriptions. If a cache parameter group name is specified, the list contains only the descriptions for that group.
     */
    override suspend fun describeCacheParameterGroups(input: DescribeCacheParameterGroupsRequest): DescribeCacheParameterGroupsResponse {
        val op = SdkHttpOperation.build<DescribeCacheParameterGroupsRequest, DescribeCacheParameterGroupsResponse> {
            serializer = DescribeCacheParameterGroupsOperationSerializer()
            deserializer = DescribeCacheParameterGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCacheParameterGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DescribeCacheParameterGroups-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the detailed parameter list for a particular cache parameter group.
     */
    override suspend fun describeCacheParameters(input: DescribeCacheParametersRequest): DescribeCacheParametersResponse {
        val op = SdkHttpOperation.build<DescribeCacheParametersRequest, DescribeCacheParametersResponse> {
            serializer = DescribeCacheParametersOperationSerializer()
            deserializer = DescribeCacheParametersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCacheParameters"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DescribeCacheParameters-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of cache security group descriptions. If a cache security group name is specified, the list contains only the description of that group. This applicable only when you have ElastiCache in Classic setup
     */
    override suspend fun describeCacheSecurityGroups(input: DescribeCacheSecurityGroupsRequest): DescribeCacheSecurityGroupsResponse {
        val op = SdkHttpOperation.build<DescribeCacheSecurityGroupsRequest, DescribeCacheSecurityGroupsResponse> {
            serializer = DescribeCacheSecurityGroupsOperationSerializer()
            deserializer = DescribeCacheSecurityGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCacheSecurityGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DescribeCacheSecurityGroups-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of cache subnet group descriptions. If a subnet group name is specified, the list contains only the description of that group. This is applicable only when you have ElastiCache in VPC setup. All ElastiCache clusters now launch in VPC by default.
     */
    override suspend fun describeCacheSubnetGroups(input: DescribeCacheSubnetGroupsRequest): DescribeCacheSubnetGroupsResponse {
        val op = SdkHttpOperation.build<DescribeCacheSubnetGroupsRequest, DescribeCacheSubnetGroupsResponse> {
            serializer = DescribeCacheSubnetGroupsOperationSerializer()
            deserializer = DescribeCacheSubnetGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCacheSubnetGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DescribeCacheSubnetGroups-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns the default engine and system parameter information for the specified cache engine.
     */
    override suspend fun describeEngineDefaultParameters(input: DescribeEngineDefaultParametersRequest): DescribeEngineDefaultParametersResponse {
        val op = SdkHttpOperation.build<DescribeEngineDefaultParametersRequest, DescribeEngineDefaultParametersResponse> {
            serializer = DescribeEngineDefaultParametersOperationSerializer()
            deserializer = DescribeEngineDefaultParametersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEngineDefaultParameters"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DescribeEngineDefaultParameters-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns events related to clusters, cache security groups, and cache parameter groups. You can obtain events specific to a particular cluster, cache security group, or cache parameter group by providing the name as a parameter.
     *
     * By default, only the events occurring within the last hour are returned; however, you can retrieve up to 14 days' worth of events if necessary.
     */
    override suspend fun describeEvents(input: DescribeEventsRequest): DescribeEventsResponse {
        val op = SdkHttpOperation.build<DescribeEventsRequest, DescribeEventsResponse> {
            serializer = DescribeEventsOperationSerializer()
            deserializer = DescribeEventsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEvents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DescribeEvents-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a particular global replication group. If no identifier is specified, returns information about all Global datastores.
     */
    override suspend fun describeGlobalReplicationGroups(input: DescribeGlobalReplicationGroupsRequest): DescribeGlobalReplicationGroupsResponse {
        val op = SdkHttpOperation.build<DescribeGlobalReplicationGroupsRequest, DescribeGlobalReplicationGroupsResponse> {
            serializer = DescribeGlobalReplicationGroupsOperationSerializer()
            deserializer = DescribeGlobalReplicationGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeGlobalReplicationGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DescribeGlobalReplicationGroups-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a particular replication group. If no identifier is specified, `DescribeReplicationGroups` returns information about all replication groups.
     *
     * This operation is valid for Redis only.
     */
    override suspend fun describeReplicationGroups(input: DescribeReplicationGroupsRequest): DescribeReplicationGroupsResponse {
        val op = SdkHttpOperation.build<DescribeReplicationGroupsRequest, DescribeReplicationGroupsResponse> {
            serializer = DescribeReplicationGroupsOperationSerializer()
            deserializer = DescribeReplicationGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeReplicationGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DescribeReplicationGroups-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about reserved cache nodes for this account, or about a specified reserved cache node.
     */
    override suspend fun describeReservedCacheNodes(input: DescribeReservedCacheNodesRequest): DescribeReservedCacheNodesResponse {
        val op = SdkHttpOperation.build<DescribeReservedCacheNodesRequest, DescribeReservedCacheNodesResponse> {
            serializer = DescribeReservedCacheNodesOperationSerializer()
            deserializer = DescribeReservedCacheNodesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeReservedCacheNodes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DescribeReservedCacheNodes-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists available reserved cache node offerings.
     */
    override suspend fun describeReservedCacheNodesOfferings(input: DescribeReservedCacheNodesOfferingsRequest): DescribeReservedCacheNodesOfferingsResponse {
        val op = SdkHttpOperation.build<DescribeReservedCacheNodesOfferingsRequest, DescribeReservedCacheNodesOfferingsResponse> {
            serializer = DescribeReservedCacheNodesOfferingsOperationSerializer()
            deserializer = DescribeReservedCacheNodesOfferingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeReservedCacheNodesOfferings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DescribeReservedCacheNodesOfferings-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns details of the service updates
     */
    override suspend fun describeServiceUpdates(input: DescribeServiceUpdatesRequest): DescribeServiceUpdatesResponse {
        val op = SdkHttpOperation.build<DescribeServiceUpdatesRequest, DescribeServiceUpdatesResponse> {
            serializer = DescribeServiceUpdatesOperationSerializer()
            deserializer = DescribeServiceUpdatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeServiceUpdates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DescribeServiceUpdates-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about cluster or replication group snapshots. By default, `DescribeSnapshots` lists all of your snapshots; it can optionally describe a single snapshot, or just the snapshots associated with a particular cache cluster.
     *
     * This operation is valid for Redis only.
     */
    override suspend fun describeSnapshots(input: DescribeSnapshotsRequest): DescribeSnapshotsResponse {
        val op = SdkHttpOperation.build<DescribeSnapshotsRequest, DescribeSnapshotsResponse> {
            serializer = DescribeSnapshotsOperationSerializer()
            deserializer = DescribeSnapshotsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSnapshots"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DescribeSnapshots-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns details of the update actions
     */
    override suspend fun describeUpdateActions(input: DescribeUpdateActionsRequest): DescribeUpdateActionsResponse {
        val op = SdkHttpOperation.build<DescribeUpdateActionsRequest, DescribeUpdateActionsResponse> {
            serializer = DescribeUpdateActionsOperationSerializer()
            deserializer = DescribeUpdateActionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeUpdateActions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DescribeUpdateActions-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of user groups.
     */
    override suspend fun describeUserGroups(input: DescribeUserGroupsRequest): DescribeUserGroupsResponse {
        val op = SdkHttpOperation.build<DescribeUserGroupsRequest, DescribeUserGroupsResponse> {
            serializer = DescribeUserGroupsOperationSerializer()
            deserializer = DescribeUserGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeUserGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DescribeUserGroups-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of users.
     */
    override suspend fun describeUsers(input: DescribeUsersRequest): DescribeUsersResponse {
        val op = SdkHttpOperation.build<DescribeUsersRequest, DescribeUsersResponse> {
            serializer = DescribeUsersOperationSerializer()
            deserializer = DescribeUsersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeUsers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DescribeUsers-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Remove a secondary cluster from the Global datastore using the Global datastore name. The secondary cluster will no longer receive updates from the primary cluster, but will remain as a standalone cluster in that Amazon region.
     */
    override suspend fun disassociateGlobalReplicationGroup(input: DisassociateGlobalReplicationGroupRequest): DisassociateGlobalReplicationGroupResponse {
        val op = SdkHttpOperation.build<DisassociateGlobalReplicationGroupRequest, DisassociateGlobalReplicationGroupResponse> {
            serializer = DisassociateGlobalReplicationGroupOperationSerializer()
            deserializer = DisassociateGlobalReplicationGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateGlobalReplicationGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DisassociateGlobalReplicationGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Used to failover the primary region to a secondary region. The secondary region will become primary, and all other clusters will become secondary.
     */
    override suspend fun failoverGlobalReplicationGroup(input: FailoverGlobalReplicationGroupRequest): FailoverGlobalReplicationGroupResponse {
        val op = SdkHttpOperation.build<FailoverGlobalReplicationGroupRequest, FailoverGlobalReplicationGroupResponse> {
            serializer = FailoverGlobalReplicationGroupOperationSerializer()
            deserializer = FailoverGlobalReplicationGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "FailoverGlobalReplicationGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("FailoverGlobalReplicationGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Increase the number of node groups in the Global datastore
     */
    override suspend fun increaseNodeGroupsInGlobalReplicationGroup(input: IncreaseNodeGroupsInGlobalReplicationGroupRequest): IncreaseNodeGroupsInGlobalReplicationGroupResponse {
        val op = SdkHttpOperation.build<IncreaseNodeGroupsInGlobalReplicationGroupRequest, IncreaseNodeGroupsInGlobalReplicationGroupResponse> {
            serializer = IncreaseNodeGroupsInGlobalReplicationGroupOperationSerializer()
            deserializer = IncreaseNodeGroupsInGlobalReplicationGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "IncreaseNodeGroupsInGlobalReplicationGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("IncreaseNodeGroupsInGlobalReplicationGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Dynamically increases the number of replicas in a Redis (cluster mode disabled) replication group or the number of replica nodes in one or more node groups (shards) of a Redis (cluster mode enabled) replication group. This operation is performed with no cluster down time.
     */
    override suspend fun increaseReplicaCount(input: IncreaseReplicaCountRequest): IncreaseReplicaCountResponse {
        val op = SdkHttpOperation.build<IncreaseReplicaCountRequest, IncreaseReplicaCountResponse> {
            serializer = IncreaseReplicaCountOperationSerializer()
            deserializer = IncreaseReplicaCountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "IncreaseReplicaCount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("IncreaseReplicaCount-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists all available node types that you can scale your Redis cluster's or replication group's current node type.
     *
     * When you use the `ModifyCacheCluster` or `ModifyReplicationGroup` operations to scale your cluster or replication group, the value of the `CacheNodeType` parameter must be one of the node types returned by this operation.
     */
    override suspend fun listAllowedNodeTypeModifications(input: ListAllowedNodeTypeModificationsRequest): ListAllowedNodeTypeModificationsResponse {
        val op = SdkHttpOperation.build<ListAllowedNodeTypeModificationsRequest, ListAllowedNodeTypeModificationsResponse> {
            serializer = ListAllowedNodeTypeModificationsOperationSerializer()
            deserializer = ListAllowedNodeTypeModificationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAllowedNodeTypeModifications"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListAllowedNodeTypeModifications-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists all tags currently on a named resource.
     *
     *  A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. For more information, see [Resource-level permissions](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html).
     *
     * If the cluster is not in the *available* state, `ListTagsForResource` returns an error.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListTagsForResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Modifies the settings for a cluster. You can use this operation to change one or more cluster configuration parameters by specifying the parameters and the new values.
     */
    override suspend fun modifyCacheCluster(input: ModifyCacheClusterRequest): ModifyCacheClusterResponse {
        val op = SdkHttpOperation.build<ModifyCacheClusterRequest, ModifyCacheClusterResponse> {
            serializer = ModifyCacheClusterOperationSerializer()
            deserializer = ModifyCacheClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyCacheCluster"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ModifyCacheCluster-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Modifies the parameters of a cache parameter group. You can modify up to 20 parameters in a single request by submitting a list parameter name and value pairs.
     */
    override suspend fun modifyCacheParameterGroup(input: ModifyCacheParameterGroupRequest): ModifyCacheParameterGroupResponse {
        val op = SdkHttpOperation.build<ModifyCacheParameterGroupRequest, ModifyCacheParameterGroupResponse> {
            serializer = ModifyCacheParameterGroupOperationSerializer()
            deserializer = ModifyCacheParameterGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyCacheParameterGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ModifyCacheParameterGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Modifies an existing cache subnet group.
     */
    override suspend fun modifyCacheSubnetGroup(input: ModifyCacheSubnetGroupRequest): ModifyCacheSubnetGroupResponse {
        val op = SdkHttpOperation.build<ModifyCacheSubnetGroupRequest, ModifyCacheSubnetGroupResponse> {
            serializer = ModifyCacheSubnetGroupOperationSerializer()
            deserializer = ModifyCacheSubnetGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyCacheSubnetGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ModifyCacheSubnetGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Modifies the settings for a Global datastore.
     */
    override suspend fun modifyGlobalReplicationGroup(input: ModifyGlobalReplicationGroupRequest): ModifyGlobalReplicationGroupResponse {
        val op = SdkHttpOperation.build<ModifyGlobalReplicationGroupRequest, ModifyGlobalReplicationGroupResponse> {
            serializer = ModifyGlobalReplicationGroupOperationSerializer()
            deserializer = ModifyGlobalReplicationGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyGlobalReplicationGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ModifyGlobalReplicationGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Modifies the settings for a replication group.
     * + [Scaling for Amazon ElastiCache for Redis (cluster mode enabled)](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/scaling-redis-cluster-mode-enabled.html) in the ElastiCache User Guide
     * + [ModifyReplicationGroupShardConfiguration](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyReplicationGroupShardConfiguration.html) in the ElastiCache API Reference
     *
     * This operation is valid for Redis only.
     */
    override suspend fun modifyReplicationGroup(input: ModifyReplicationGroupRequest): ModifyReplicationGroupResponse {
        val op = SdkHttpOperation.build<ModifyReplicationGroupRequest, ModifyReplicationGroupResponse> {
            serializer = ModifyReplicationGroupOperationSerializer()
            deserializer = ModifyReplicationGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyReplicationGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ModifyReplicationGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Modifies a replication group's shards (node groups) by allowing you to add shards, remove shards, or rebalance the keyspaces among existing shards.
     */
    override suspend fun modifyReplicationGroupShardConfiguration(input: ModifyReplicationGroupShardConfigurationRequest): ModifyReplicationGroupShardConfigurationResponse {
        val op = SdkHttpOperation.build<ModifyReplicationGroupShardConfigurationRequest, ModifyReplicationGroupShardConfigurationResponse> {
            serializer = ModifyReplicationGroupShardConfigurationOperationSerializer()
            deserializer = ModifyReplicationGroupShardConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyReplicationGroupShardConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ModifyReplicationGroupShardConfiguration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Changes user password(s) and/or access string.
     */
    override suspend fun modifyUser(input: ModifyUserRequest): ModifyUserResponse {
        val op = SdkHttpOperation.build<ModifyUserRequest, ModifyUserResponse> {
            serializer = ModifyUserOperationSerializer()
            deserializer = ModifyUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ModifyUser-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Changes the list of users that belong to the user group.
     */
    override suspend fun modifyUserGroup(input: ModifyUserGroupRequest): ModifyUserGroupResponse {
        val op = SdkHttpOperation.build<ModifyUserGroupRequest, ModifyUserGroupResponse> {
            serializer = ModifyUserGroupOperationSerializer()
            deserializer = ModifyUserGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyUserGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ModifyUserGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Allows you to purchase a reserved cache node offering. Reserved nodes are not eligible for cancellation and are non-refundable. For more information, see [Managing Costs with Reserved Nodes](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/reserved-nodes.html) for Redis or [Managing Costs with Reserved Nodes](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/reserved-nodes.html) for Memcached.
     */
    override suspend fun purchaseReservedCacheNodesOffering(input: PurchaseReservedCacheNodesOfferingRequest): PurchaseReservedCacheNodesOfferingResponse {
        val op = SdkHttpOperation.build<PurchaseReservedCacheNodesOfferingRequest, PurchaseReservedCacheNodesOfferingResponse> {
            serializer = PurchaseReservedCacheNodesOfferingOperationSerializer()
            deserializer = PurchaseReservedCacheNodesOfferingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PurchaseReservedCacheNodesOffering"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("PurchaseReservedCacheNodesOffering-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Redistribute slots to ensure uniform distribution across existing shards in the cluster.
     */
    override suspend fun rebalanceSlotsInGlobalReplicationGroup(input: RebalanceSlotsInGlobalReplicationGroupRequest): RebalanceSlotsInGlobalReplicationGroupResponse {
        val op = SdkHttpOperation.build<RebalanceSlotsInGlobalReplicationGroupRequest, RebalanceSlotsInGlobalReplicationGroupResponse> {
            serializer = RebalanceSlotsInGlobalReplicationGroupOperationSerializer()
            deserializer = RebalanceSlotsInGlobalReplicationGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RebalanceSlotsInGlobalReplicationGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("RebalanceSlotsInGlobalReplicationGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Reboots some, or all, of the cache nodes within a provisioned cluster. This operation applies any modified cache parameter groups to the cluster. The reboot operation takes place as soon as possible, and results in a momentary outage to the cluster. During the reboot, the cluster status is set to REBOOTING.
     *
     * The reboot causes the contents of the cache (for each cache node being rebooted) to be lost.
     *
     * When the reboot is complete, a cluster event is created.
     *
     * Rebooting a cluster is currently supported on Memcached and Redis (cluster mode disabled) clusters. Rebooting is not supported on Redis (cluster mode enabled) clusters.
     *
     * If you make changes to parameters that require a Redis (cluster mode enabled) cluster reboot for the changes to be applied, see [Rebooting a Cluster](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes.rebooting.html) for an alternate process.
     */
    override suspend fun rebootCacheCluster(input: RebootCacheClusterRequest): RebootCacheClusterResponse {
        val op = SdkHttpOperation.build<RebootCacheClusterRequest, RebootCacheClusterResponse> {
            serializer = RebootCacheClusterOperationSerializer()
            deserializer = RebootCacheClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RebootCacheCluster"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("RebootCacheCluster-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes the tags identified by the `TagKeys` list from the named resource. A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. For more information, see [Resource-level permissions](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html).
     */
    override suspend fun removeTagsFromResource(input: RemoveTagsFromResourceRequest): RemoveTagsFromResourceResponse {
        val op = SdkHttpOperation.build<RemoveTagsFromResourceRequest, RemoveTagsFromResourceResponse> {
            serializer = RemoveTagsFromResourceOperationSerializer()
            deserializer = RemoveTagsFromResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveTagsFromResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("RemoveTagsFromResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Modifies the parameters of a cache parameter group to the engine or system default value. You can reset specific parameters by submitting a list of parameter names. To reset the entire cache parameter group, specify the `ResetAllParameters` and `CacheParameterGroupName` parameters.
     */
    override suspend fun resetCacheParameterGroup(input: ResetCacheParameterGroupRequest): ResetCacheParameterGroupResponse {
        val op = SdkHttpOperation.build<ResetCacheParameterGroupRequest, ResetCacheParameterGroupResponse> {
            serializer = ResetCacheParameterGroupOperationSerializer()
            deserializer = ResetCacheParameterGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ResetCacheParameterGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ResetCacheParameterGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Revokes ingress from a cache security group. Use this operation to disallow access from an Amazon EC2 security group that had been previously authorized.
     */
    override suspend fun revokeCacheSecurityGroupIngress(input: RevokeCacheSecurityGroupIngressRequest): RevokeCacheSecurityGroupIngressResponse {
        val op = SdkHttpOperation.build<RevokeCacheSecurityGroupIngressRequest, RevokeCacheSecurityGroupIngressResponse> {
            serializer = RevokeCacheSecurityGroupIngressOperationSerializer()
            deserializer = RevokeCacheSecurityGroupIngressOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RevokeCacheSecurityGroupIngress"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("RevokeCacheSecurityGroupIngress-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Start the migration of data.
     */
    override suspend fun startMigration(input: StartMigrationRequest): StartMigrationResponse {
        val op = SdkHttpOperation.build<StartMigrationRequest, StartMigrationResponse> {
            serializer = StartMigrationOperationSerializer()
            deserializer = StartMigrationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartMigration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("StartMigration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Represents the input of a `TestFailover` operation which test automatic failover on a specified node group (called shard in the console) in a replication group (called cluster in the console).
     *
     * This API is designed for testing the behavior of your application in case of ElastiCache failover. It is not designed to be an operational tool for initiating a failover to overcome a problem you may have with the cluster. Moreover, in certain conditions such as large-scale operational events, Amazon may block this API.
     *
     * **Note the following**
     * + A customer can use this operation to test automatic failover on up to 5 shards (called node groups in the ElastiCache API and Amazon CLI) in any rolling 24-hour period.
     * + If calling this operation on shards in different clusters (called replication groups in the API and CLI), the calls can be made concurrently.
     * + If calling this operation multiple times on different shards in the same Redis (cluster mode enabled) replication group, the first node replacement must complete before a subsequent call can be made.
     * + To determine whether the node replacement is complete you can check Events using the Amazon ElastiCache console, the Amazon CLI, or the ElastiCache API. Look for the following automatic failover related events, listed here in order of occurrance:
     *    + Replication group message: `Test Failover API called for node group <node-group-id>`
     *    + Cache cluster message: `Failover from primary node <primary-node-id> to replica node <node-id> completed`
     *    + Replication group message: `Failover from primary node <primary-node-id> to replica node <node-id> completed`
     *    + Cache cluster message: `Recovering cache nodes <node-id>`
     *    + Cache cluster message: `Finished recovery for cache nodes <node-id>`
     * For more information see:
     *    + [Viewing ElastiCache Events](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ECEvents.Viewing.html) in the *ElastiCache User Guide*
     *    + [DescribeEvents](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeEvents.html) in the ElastiCache API Reference
     *
     * Also see, [Testing Multi-AZ ](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html#auto-failover-test) in the *ElastiCache User Guide*.
     */
    override suspend fun testFailover(input: TestFailoverRequest): TestFailoverResponse {
        val op = SdkHttpOperation.build<TestFailoverRequest, TestFailoverResponse> {
            serializer = TestFailoverOperationSerializer()
            deserializer = TestFailoverOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TestFailover"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticache"
            }
        )
        val rootSpan = config.tracer.createRootSpan("TestFailover-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "elasticache")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
