// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model



/**
 * A parameter that has a different value for each cache node type it is applied to. For example, in a Redis cluster, a `cache.m1.large` cache node type would have a larger `maxmemory` value than a `cache.m1.small` type.
 */
public class CacheNodeTypeSpecificParameter private constructor(builder: Builder) {
    /**
     * The valid range of values for the parameter.
     */
    public val allowedValues: kotlin.String? = builder.allowedValues
    /**
     * A list of cache node types and their corresponding values for this parameter.
     */
    public val cacheNodeTypeSpecificValues: List<CacheNodeTypeSpecificValue>? = builder.cacheNodeTypeSpecificValues
    /**
     * Indicates whether a change to the parameter is applied immediately or requires a reboot for the change to be applied. You can force a reboot or wait until the next maintenance window's reboot. For more information, see [Rebooting a Cluster](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html).
     */
    public val changeType: aws.sdk.kotlin.services.elasticache.model.ChangeType? = builder.changeType
    /**
     * The valid data type for the parameter.
     */
    public val dataType: kotlin.String? = builder.dataType
    /**
     * A description of the parameter.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Indicates whether (`true`) or not (`false`) the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed.
     */
    public val isModifiable: kotlin.Boolean = builder.isModifiable
    /**
     * The earliest cache engine version to which the parameter can apply.
     */
    public val minimumEngineVersion: kotlin.String? = builder.minimumEngineVersion
    /**
     * The name of the parameter.
     */
    public val parameterName: kotlin.String? = builder.parameterName
    /**
     * The source of the parameter value.
     */
    public val source: kotlin.String? = builder.source

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.CacheNodeTypeSpecificParameter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CacheNodeTypeSpecificParameter(")
        append("allowedValues=$allowedValues,")
        append("cacheNodeTypeSpecificValues=$cacheNodeTypeSpecificValues,")
        append("changeType=$changeType,")
        append("dataType=$dataType,")
        append("description=$description,")
        append("isModifiable=$isModifiable,")
        append("minimumEngineVersion=$minimumEngineVersion,")
        append("parameterName=$parameterName,")
        append("source=$source")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedValues?.hashCode() ?: 0
        result = 31 * result + (cacheNodeTypeSpecificValues?.hashCode() ?: 0)
        result = 31 * result + (changeType?.hashCode() ?: 0)
        result = 31 * result + (dataType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (isModifiable.hashCode())
        result = 31 * result + (minimumEngineVersion?.hashCode() ?: 0)
        result = 31 * result + (parameterName?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CacheNodeTypeSpecificParameter

        if (allowedValues != other.allowedValues) return false
        if (cacheNodeTypeSpecificValues != other.cacheNodeTypeSpecificValues) return false
        if (changeType != other.changeType) return false
        if (dataType != other.dataType) return false
        if (description != other.description) return false
        if (isModifiable != other.isModifiable) return false
        if (minimumEngineVersion != other.minimumEngineVersion) return false
        if (parameterName != other.parameterName) return false
        if (source != other.source) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.CacheNodeTypeSpecificParameter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The valid range of values for the parameter.
         */
        public var allowedValues: kotlin.String? = null
        /**
         * A list of cache node types and their corresponding values for this parameter.
         */
        public var cacheNodeTypeSpecificValues: List<CacheNodeTypeSpecificValue>? = null
        /**
         * Indicates whether a change to the parameter is applied immediately or requires a reboot for the change to be applied. You can force a reboot or wait until the next maintenance window's reboot. For more information, see [Rebooting a Cluster](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html).
         */
        public var changeType: aws.sdk.kotlin.services.elasticache.model.ChangeType? = null
        /**
         * The valid data type for the parameter.
         */
        public var dataType: kotlin.String? = null
        /**
         * A description of the parameter.
         */
        public var description: kotlin.String? = null
        /**
         * Indicates whether (`true`) or not (`false`) the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed.
         */
        public var isModifiable: kotlin.Boolean = false
        /**
         * The earliest cache engine version to which the parameter can apply.
         */
        public var minimumEngineVersion: kotlin.String? = null
        /**
         * The name of the parameter.
         */
        public var parameterName: kotlin.String? = null
        /**
         * The source of the parameter value.
         */
        public var source: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.CacheNodeTypeSpecificParameter) : this() {
            this.allowedValues = x.allowedValues
            this.cacheNodeTypeSpecificValues = x.cacheNodeTypeSpecificValues
            this.changeType = x.changeType
            this.dataType = x.dataType
            this.description = x.description
            this.isModifiable = x.isModifiable
            this.minimumEngineVersion = x.minimumEngineVersion
            this.parameterName = x.parameterName
            this.source = x.source
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.CacheNodeTypeSpecificParameter = CacheNodeTypeSpecificParameter(this)
    }
}
