// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model



/**
 * Represents the input of a CreateCacheCluster operation.
 */
public class CreateCacheClusterRequest private constructor(builder: Builder) {
    /**
     * **Reserved parameter.** The password used to access a password protected server.
     *
     * Password constraints:
     * + Must be only printable ASCII characters.
     * + Must be at least 16 characters and no more than 128 characters in length.
     * + The only permitted printable special characters are !, &, #, $, ^, <, >, and -. Other printable special characters cannot be used in the AUTH token.
     *
     * For more information, see [AUTH password](http://redis.io/commands/AUTH) at http://redis.io/commands/AUTH.
     */
    public val authToken: kotlin.String? = builder.authToken
    /**
     * If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or created across multiple Availability Zones in the cluster's region.
     *
     * This parameter is only supported for Memcached clusters.
     *
     * If the `AZMode` and `PreferredAvailabilityZones` are not specified, ElastiCache assumes `single-az` mode.
     */
    public val azMode: aws.sdk.kotlin.services.elasticache.model.AzMode? = builder.azMode
    /**
     * The node group (shard) identifier. This parameter is stored as a lowercase string.
     *
     * **Constraints:**
     * + A name must contain from 1 to 50 alphanumeric characters or hyphens.
     * + The first character must be a letter.
     * + A name cannot end with a hyphen or contain two consecutive hyphens.
     */
    public val cacheClusterId: kotlin.String? = builder.cacheClusterId
    /**
     * The compute and memory capacity of the nodes in the node group (shard).
     *
     * The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.
     * + General purpose:
     *    + Current generation: **M6g node types** (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): `cache.m6g.large`, `cache.m6g.xlarge`, `cache.m6g.2xlarge`, `cache.m6g.4xlarge`, `cache.m6g.8xlarge`, `cache.m6g.12xlarge`, `cache.m6g.16xlarge`For region availability, see [Supported Node Types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)**M5 node types:**`cache.m5.large`, `cache.m5.xlarge`, `cache.m5.2xlarge`, `cache.m5.4xlarge`, `cache.m5.12xlarge`, `cache.m5.24xlarge`**M4 node types:**`cache.m4.large`, `cache.m4.xlarge`, `cache.m4.2xlarge`, `cache.m4.4xlarge`, `cache.m4.10xlarge`**T4g node types** (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward): `cache.t4g.micro`, `cache.t4g.small`, `cache.t4g.medium`**T3 node types:**`cache.t3.micro`, `cache.t3.small`, `cache.t3.medium`**T2 node types:**`cache.t2.micro`, `cache.t2.small`, `cache.t2.medium`
     *    + Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)**T1 node types:**`cache.t1.micro`**M1 node types:**`cache.m1.small`, `cache.m1.medium`, `cache.m1.large`, `cache.m1.xlarge`**M3 node types:**`cache.m3.medium`, `cache.m3.large`, `cache.m3.xlarge`, `cache.m3.2xlarge`
     * + Compute optimized:
     *    + Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)**C1 node types:**`cache.c1.xlarge`
     * + Memory optimized:
     *    + Current generation: **R6g node types** (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).`cache.r6g.large`, `cache.r6g.xlarge`, `cache.r6g.2xlarge`, `cache.r6g.4xlarge`, `cache.r6g.8xlarge`, `cache.r6g.12xlarge`, `cache.r6g.16xlarge`For region availability, see [Supported Node Types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)**R5 node types:**`cache.r5.large`, `cache.r5.xlarge`, `cache.r5.2xlarge`, `cache.r5.4xlarge`, `cache.r5.12xlarge`, `cache.r5.24xlarge`**R4 node types:**`cache.r4.large`, `cache.r4.xlarge`, `cache.r4.2xlarge`, `cache.r4.4xlarge`, `cache.r4.8xlarge`, `cache.r4.16xlarge`
     *    + Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)**M2 node types:**`cache.m2.xlarge`, `cache.m2.2xlarge`, `cache.m2.4xlarge`**R3 node types:**`cache.r3.large`, `cache.r3.xlarge`, `cache.r3.2xlarge`, `cache.r3.4xlarge`, `cache.r3.8xlarge`
     *
     * **Additional node type info**
     * + All current generation instance types are created in Amazon VPC by default.
     * + Redis append-only files (AOF) are not supported for T1 or T2 instances.
     * + Redis Multi-AZ with automatic failover is not supported on T1 instances.
     * + Redis configuration variables `appendonly` and `appendfsync` are not supported on Redis version 2.8.22 and later.
     */
    public val cacheNodeType: kotlin.String? = builder.cacheNodeType
    /**
     * The name of the parameter group to associate with this cluster. If this argument is omitted, the default parameter group for the specified engine is used. You cannot use any parameter group which has `cluster-enabled='yes'` when creating a cluster.
     */
    public val cacheParameterGroupName: kotlin.String? = builder.cacheParameterGroupName
    /**
     * A list of security group names to associate with this cluster.
     *
     * Use this parameter only when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon VPC).
     */
    public val cacheSecurityGroupNames: List<String>? = builder.cacheSecurityGroupNames
    /**
     * The name of the subnet group to be used for the cluster.
     *
     * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
     *
     * If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see [Subnets and Subnet Groups](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html).
     */
    public val cacheSubnetGroupName: kotlin.String? = builder.cacheSubnetGroupName
    /**
     * The name of the cache engine to be used for this cluster.
     *
     * Valid values for this parameter are: `memcached` | `redis`
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The version number of the cache engine to be used for this cluster. To view the supported cache engine versions, use the DescribeCacheEngineVersions operation.
     *
     * **Important:** You can upgrade to a newer engine version (see [Selecting a Cache Engine and Version](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement)), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The network type you choose when modifying a cluster, either `ipv4` | `ipv6`. IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the [Nitro system](https://aws.amazon.com/ec2/nitro/).
     */
    public val ipDiscovery: aws.sdk.kotlin.services.elasticache.model.IpDiscovery? = builder.ipDiscovery
    /**
     * Specifies the destination, format and type of the logs.
     */
    public val logDeliveryConfigurations: List<LogDeliveryConfigurationRequest>? = builder.logDeliveryConfigurations
    /**
     * Must be either `ipv4` | `ipv6` | `dual_stack`. IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the [Nitro system](https://aws.amazon.com/ec2/nitro/).
     */
    public val networkType: aws.sdk.kotlin.services.elasticache.model.NetworkType? = builder.networkType
    /**
     * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.
     *
     * The Amazon SNS topic owner must be the same as the cluster owner.
     */
    public val notificationTopicArn: kotlin.String? = builder.notificationTopicArn
    /**
     * The initial number of cache nodes that the cluster has.
     *
     * For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.
     *
     * If you need more than 40 nodes for your Memcached cluster, please fill out the ElastiCache Limit Increase Request form at [http://aws.amazon.com/contact-us/elasticache-node-limit-request/](http://aws.amazon.com/contact-us/elasticache-node-limit-request/).
     */
    public val numCacheNodes: kotlin.Int? = builder.numCacheNodes
    /**
     * Specifies whether the nodes in the cluster are created in a single outpost or across multiple outposts.
     */
    public val outpostMode: aws.sdk.kotlin.services.elasticache.model.OutpostMode? = builder.outpostMode
    /**
     * The port number on which each of the cache nodes accepts connections.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The EC2 Availability Zone in which the cluster is created.
     *
     * All nodes belonging to this cluster are placed in the preferred Availability Zone. If you want to create your nodes across multiple Availability Zones, use `PreferredAvailabilityZones`.
     *
     * Default: System chosen Availability Zone.
     */
    public val preferredAvailabilityZone: kotlin.String? = builder.preferredAvailabilityZone
    /**
     * A list of the Availability Zones in which cache nodes are created. The order of the zones in the list is not important.
     *
     * This option is only supported on Memcached.
     *
     * If you are creating your cluster in an Amazon VPC (recommended) you can only locate nodes in Availability Zones that are associated with the subnets in the selected subnet group.
     *
     * The number of Availability Zones listed must equal the value of `NumCacheNodes`.
     *
     * If you want all the nodes in the same Availability Zone, use `PreferredAvailabilityZone` instead, or repeat the Availability Zone multiple times in the list.
     *
     * Default: System chosen Availability Zones.
     */
    public val preferredAvailabilityZones: List<String>? = builder.preferredAvailabilityZones
    /**
     * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * The outpost ARN in which the cache cluster is created.
     */
    public val preferredOutpostArn: kotlin.String? = builder.preferredOutpostArn
    /**
     * The outpost ARNs in which the cache cluster is created.
     */
    public val preferredOutpostArns: List<String>? = builder.preferredOutpostArns
    /**
     * The ID of the replication group to which this cluster should belong. If this parameter is specified, the cluster is added to the specified replication group as a read replica; otherwise, the cluster is a standalone primary that is not part of any replication group.
     *
     * If the specified replication group is Multi-AZ enabled and the Availability Zone is not specified, the cluster is created in Availability Zones that provide the best spread of read replicas across Availability Zones.
     *
     * This parameter is only valid if the `Engine` parameter is `redis`.
     */
    public val replicationGroupId: kotlin.String? = builder.replicationGroupId
    /**
     * One or more VPC security groups associated with the cluster.
     *
     * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Redis RDB snapshot file stored in Amazon S3. The snapshot file is used to populate the node group (shard). The Amazon S3 object name in the ARN cannot contain any commas.
     *
     * This parameter is only valid if the `Engine` parameter is `redis`.
     *
     * Example of an Amazon S3 ARN: `arn:aws:s3:::my_bucket/snapshot1.rdb`
     */
    public val snapshotArns: List<String>? = builder.snapshotArns
    /**
     * The name of a Redis snapshot from which to restore data into the new node group (shard). The snapshot status changes to `restoring` while the new node group (shard) is being created.
     *
     * This parameter is only valid if the `Engine` parameter is `redis`.
     */
    public val snapshotName: kotlin.String? = builder.snapshotName
    /**
     * The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you set `SnapshotRetentionLimit` to 5, a snapshot taken today is retained for 5 days before being deleted.
     *
     * This parameter is only valid if the `Engine` parameter is `redis`.
     *
     * Default: 0 (i.e., automatic backups are disabled for this cache cluster).
     */
    public val snapshotRetentionLimit: kotlin.Int? = builder.snapshotRetentionLimit
    /**
     * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).
     *
     * Example: `05:00-09:00`
     *
     * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     *
     * This parameter is only valid if the `Engine` parameter is `redis`.
     */
    public val snapshotWindow: kotlin.String? = builder.snapshotWindow
    /**
     * A list of tags to be added to this resource.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A flag that enables in-transit encryption when set to true. You cannot modify the value of TransitEncryptionEnabled after the cluster is created. To enable in-transit encryption on a cluster you must set `TransitEncryptionEnabled` to true when you create a cluster.
     *
     *  Only available when creating a cache cluster in an Amazon VPC using Memcached version 1.6.12 or later.
     */
    public val transitEncryptionEnabled: kotlin.Boolean? = builder.transitEncryptionEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.CreateCacheClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCacheClusterRequest(")
        append("authToken=$authToken,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("azMode=$azMode,")
        append("cacheClusterId=$cacheClusterId,")
        append("cacheNodeType=$cacheNodeType,")
        append("cacheParameterGroupName=$cacheParameterGroupName,")
        append("cacheSecurityGroupNames=$cacheSecurityGroupNames,")
        append("cacheSubnetGroupName=$cacheSubnetGroupName,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("ipDiscovery=$ipDiscovery,")
        append("logDeliveryConfigurations=$logDeliveryConfigurations,")
        append("networkType=$networkType,")
        append("notificationTopicArn=$notificationTopicArn,")
        append("numCacheNodes=$numCacheNodes,")
        append("outpostMode=$outpostMode,")
        append("port=$port,")
        append("preferredAvailabilityZone=$preferredAvailabilityZone,")
        append("preferredAvailabilityZones=$preferredAvailabilityZones,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("preferredOutpostArn=$preferredOutpostArn,")
        append("preferredOutpostArns=$preferredOutpostArns,")
        append("replicationGroupId=$replicationGroupId,")
        append("securityGroupIds=$securityGroupIds,")
        append("snapshotArns=$snapshotArns,")
        append("snapshotName=$snapshotName,")
        append("snapshotRetentionLimit=$snapshotRetentionLimit,")
        append("snapshotWindow=$snapshotWindow,")
        append("tags=$tags,")
        append("transitEncryptionEnabled=$transitEncryptionEnabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authToken?.hashCode() ?: 0
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (azMode?.hashCode() ?: 0)
        result = 31 * result + (cacheClusterId?.hashCode() ?: 0)
        result = 31 * result + (cacheNodeType?.hashCode() ?: 0)
        result = 31 * result + (cacheParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (cacheSecurityGroupNames?.hashCode() ?: 0)
        result = 31 * result + (cacheSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (ipDiscovery?.hashCode() ?: 0)
        result = 31 * result + (logDeliveryConfigurations?.hashCode() ?: 0)
        result = 31 * result + (networkType?.hashCode() ?: 0)
        result = 31 * result + (notificationTopicArn?.hashCode() ?: 0)
        result = 31 * result + (numCacheNodes ?: 0)
        result = 31 * result + (outpostMode?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (preferredAvailabilityZone?.hashCode() ?: 0)
        result = 31 * result + (preferredAvailabilityZones?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredOutpostArn?.hashCode() ?: 0)
        result = 31 * result + (preferredOutpostArns?.hashCode() ?: 0)
        result = 31 * result + (replicationGroupId?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (snapshotArns?.hashCode() ?: 0)
        result = 31 * result + (snapshotName?.hashCode() ?: 0)
        result = 31 * result + (snapshotRetentionLimit ?: 0)
        result = 31 * result + (snapshotWindow?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (transitEncryptionEnabled?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateCacheClusterRequest

        if (authToken != other.authToken) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (azMode != other.azMode) return false
        if (cacheClusterId != other.cacheClusterId) return false
        if (cacheNodeType != other.cacheNodeType) return false
        if (cacheParameterGroupName != other.cacheParameterGroupName) return false
        if (cacheSecurityGroupNames != other.cacheSecurityGroupNames) return false
        if (cacheSubnetGroupName != other.cacheSubnetGroupName) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (ipDiscovery != other.ipDiscovery) return false
        if (logDeliveryConfigurations != other.logDeliveryConfigurations) return false
        if (networkType != other.networkType) return false
        if (notificationTopicArn != other.notificationTopicArn) return false
        if (numCacheNodes != other.numCacheNodes) return false
        if (outpostMode != other.outpostMode) return false
        if (port != other.port) return false
        if (preferredAvailabilityZone != other.preferredAvailabilityZone) return false
        if (preferredAvailabilityZones != other.preferredAvailabilityZones) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (preferredOutpostArn != other.preferredOutpostArn) return false
        if (preferredOutpostArns != other.preferredOutpostArns) return false
        if (replicationGroupId != other.replicationGroupId) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (snapshotArns != other.snapshotArns) return false
        if (snapshotName != other.snapshotName) return false
        if (snapshotRetentionLimit != other.snapshotRetentionLimit) return false
        if (snapshotWindow != other.snapshotWindow) return false
        if (tags != other.tags) return false
        if (transitEncryptionEnabled != other.transitEncryptionEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.CreateCacheClusterRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * **Reserved parameter.** The password used to access a password protected server.
         *
         * Password constraints:
         * + Must be only printable ASCII characters.
         * + Must be at least 16 characters and no more than 128 characters in length.
         * + The only permitted printable special characters are !, &, #, $, ^, <, >, and -. Other printable special characters cannot be used in the AUTH token.
         *
         * For more information, see [AUTH password](http://redis.io/commands/AUTH) at http://redis.io/commands/AUTH.
         */
        public var authToken: kotlin.String? = null
        /**
         * If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or created across multiple Availability Zones in the cluster's region.
         *
         * This parameter is only supported for Memcached clusters.
         *
         * If the `AZMode` and `PreferredAvailabilityZones` are not specified, ElastiCache assumes `single-az` mode.
         */
        public var azMode: aws.sdk.kotlin.services.elasticache.model.AzMode? = null
        /**
         * The node group (shard) identifier. This parameter is stored as a lowercase string.
         *
         * **Constraints:**
         * + A name must contain from 1 to 50 alphanumeric characters or hyphens.
         * + The first character must be a letter.
         * + A name cannot end with a hyphen or contain two consecutive hyphens.
         */
        public var cacheClusterId: kotlin.String? = null
        /**
         * The compute and memory capacity of the nodes in the node group (shard).
         *
         * The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.
         * + General purpose:
         *    + Current generation: **M6g node types** (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): `cache.m6g.large`, `cache.m6g.xlarge`, `cache.m6g.2xlarge`, `cache.m6g.4xlarge`, `cache.m6g.8xlarge`, `cache.m6g.12xlarge`, `cache.m6g.16xlarge`For region availability, see [Supported Node Types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)**M5 node types:**`cache.m5.large`, `cache.m5.xlarge`, `cache.m5.2xlarge`, `cache.m5.4xlarge`, `cache.m5.12xlarge`, `cache.m5.24xlarge`**M4 node types:**`cache.m4.large`, `cache.m4.xlarge`, `cache.m4.2xlarge`, `cache.m4.4xlarge`, `cache.m4.10xlarge`**T4g node types** (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward): `cache.t4g.micro`, `cache.t4g.small`, `cache.t4g.medium`**T3 node types:**`cache.t3.micro`, `cache.t3.small`, `cache.t3.medium`**T2 node types:**`cache.t2.micro`, `cache.t2.small`, `cache.t2.medium`
         *    + Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)**T1 node types:**`cache.t1.micro`**M1 node types:**`cache.m1.small`, `cache.m1.medium`, `cache.m1.large`, `cache.m1.xlarge`**M3 node types:**`cache.m3.medium`, `cache.m3.large`, `cache.m3.xlarge`, `cache.m3.2xlarge`
         * + Compute optimized:
         *    + Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)**C1 node types:**`cache.c1.xlarge`
         * + Memory optimized:
         *    + Current generation: **R6g node types** (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).`cache.r6g.large`, `cache.r6g.xlarge`, `cache.r6g.2xlarge`, `cache.r6g.4xlarge`, `cache.r6g.8xlarge`, `cache.r6g.12xlarge`, `cache.r6g.16xlarge`For region availability, see [Supported Node Types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)**R5 node types:**`cache.r5.large`, `cache.r5.xlarge`, `cache.r5.2xlarge`, `cache.r5.4xlarge`, `cache.r5.12xlarge`, `cache.r5.24xlarge`**R4 node types:**`cache.r4.large`, `cache.r4.xlarge`, `cache.r4.2xlarge`, `cache.r4.4xlarge`, `cache.r4.8xlarge`, `cache.r4.16xlarge`
         *    + Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)**M2 node types:**`cache.m2.xlarge`, `cache.m2.2xlarge`, `cache.m2.4xlarge`**R3 node types:**`cache.r3.large`, `cache.r3.xlarge`, `cache.r3.2xlarge`, `cache.r3.4xlarge`, `cache.r3.8xlarge`
         *
         * **Additional node type info**
         * + All current generation instance types are created in Amazon VPC by default.
         * + Redis append-only files (AOF) are not supported for T1 or T2 instances.
         * + Redis Multi-AZ with automatic failover is not supported on T1 instances.
         * + Redis configuration variables `appendonly` and `appendfsync` are not supported on Redis version 2.8.22 and later.
         */
        public var cacheNodeType: kotlin.String? = null
        /**
         * The name of the parameter group to associate with this cluster. If this argument is omitted, the default parameter group for the specified engine is used. You cannot use any parameter group which has `cluster-enabled='yes'` when creating a cluster.
         */
        public var cacheParameterGroupName: kotlin.String? = null
        /**
         * A list of security group names to associate with this cluster.
         *
         * Use this parameter only when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon VPC).
         */
        public var cacheSecurityGroupNames: List<String>? = null
        /**
         * The name of the subnet group to be used for the cluster.
         *
         * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
         *
         * If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see [Subnets and Subnet Groups](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html).
         */
        public var cacheSubnetGroupName: kotlin.String? = null
        /**
         * The name of the cache engine to be used for this cluster.
         *
         * Valid values for this parameter are: `memcached` | `redis`
         */
        public var engine: kotlin.String? = null
        /**
         * The version number of the cache engine to be used for this cluster. To view the supported cache engine versions, use the DescribeCacheEngineVersions operation.
         *
         * **Important:** You can upgrade to a newer engine version (see [Selecting a Cache Engine and Version](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement)), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The network type you choose when modifying a cluster, either `ipv4` | `ipv6`. IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the [Nitro system](https://aws.amazon.com/ec2/nitro/).
         */
        public var ipDiscovery: aws.sdk.kotlin.services.elasticache.model.IpDiscovery? = null
        /**
         * Specifies the destination, format and type of the logs.
         */
        public var logDeliveryConfigurations: List<LogDeliveryConfigurationRequest>? = null
        /**
         * Must be either `ipv4` | `ipv6` | `dual_stack`. IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the [Nitro system](https://aws.amazon.com/ec2/nitro/).
         */
        public var networkType: aws.sdk.kotlin.services.elasticache.model.NetworkType? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.
         *
         * The Amazon SNS topic owner must be the same as the cluster owner.
         */
        public var notificationTopicArn: kotlin.String? = null
        /**
         * The initial number of cache nodes that the cluster has.
         *
         * For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.
         *
         * If you need more than 40 nodes for your Memcached cluster, please fill out the ElastiCache Limit Increase Request form at [http://aws.amazon.com/contact-us/elasticache-node-limit-request/](http://aws.amazon.com/contact-us/elasticache-node-limit-request/).
         */
        public var numCacheNodes: kotlin.Int? = null
        /**
         * Specifies whether the nodes in the cluster are created in a single outpost or across multiple outposts.
         */
        public var outpostMode: aws.sdk.kotlin.services.elasticache.model.OutpostMode? = null
        /**
         * The port number on which each of the cache nodes accepts connections.
         */
        public var port: kotlin.Int? = null
        /**
         * The EC2 Availability Zone in which the cluster is created.
         *
         * All nodes belonging to this cluster are placed in the preferred Availability Zone. If you want to create your nodes across multiple Availability Zones, use `PreferredAvailabilityZones`.
         *
         * Default: System chosen Availability Zone.
         */
        public var preferredAvailabilityZone: kotlin.String? = null
        /**
         * A list of the Availability Zones in which cache nodes are created. The order of the zones in the list is not important.
         *
         * This option is only supported on Memcached.
         *
         * If you are creating your cluster in an Amazon VPC (recommended) you can only locate nodes in Availability Zones that are associated with the subnets in the selected subnet group.
         *
         * The number of Availability Zones listed must equal the value of `NumCacheNodes`.
         *
         * If you want all the nodes in the same Availability Zone, use `PreferredAvailabilityZone` instead, or repeat the Availability Zone multiple times in the list.
         *
         * Default: System chosen Availability Zones.
         */
        public var preferredAvailabilityZones: List<String>? = null
        /**
         * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * The outpost ARN in which the cache cluster is created.
         */
        public var preferredOutpostArn: kotlin.String? = null
        /**
         * The outpost ARNs in which the cache cluster is created.
         */
        public var preferredOutpostArns: List<String>? = null
        /**
         * The ID of the replication group to which this cluster should belong. If this parameter is specified, the cluster is added to the specified replication group as a read replica; otherwise, the cluster is a standalone primary that is not part of any replication group.
         *
         * If the specified replication group is Multi-AZ enabled and the Availability Zone is not specified, the cluster is created in Availability Zones that provide the best spread of read replicas across Availability Zones.
         *
         * This parameter is only valid if the `Engine` parameter is `redis`.
         */
        public var replicationGroupId: kotlin.String? = null
        /**
         * One or more VPC security groups associated with the cluster.
         *
         * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
         */
        public var securityGroupIds: List<String>? = null
        /**
         * A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Redis RDB snapshot file stored in Amazon S3. The snapshot file is used to populate the node group (shard). The Amazon S3 object name in the ARN cannot contain any commas.
         *
         * This parameter is only valid if the `Engine` parameter is `redis`.
         *
         * Example of an Amazon S3 ARN: `arn:aws:s3:::my_bucket/snapshot1.rdb`
         */
        public var snapshotArns: List<String>? = null
        /**
         * The name of a Redis snapshot from which to restore data into the new node group (shard). The snapshot status changes to `restoring` while the new node group (shard) is being created.
         *
         * This parameter is only valid if the `Engine` parameter is `redis`.
         */
        public var snapshotName: kotlin.String? = null
        /**
         * The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you set `SnapshotRetentionLimit` to 5, a snapshot taken today is retained for 5 days before being deleted.
         *
         * This parameter is only valid if the `Engine` parameter is `redis`.
         *
         * Default: 0 (i.e., automatic backups are disabled for this cache cluster).
         */
        public var snapshotRetentionLimit: kotlin.Int? = null
        /**
         * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).
         *
         * Example: `05:00-09:00`
         *
         * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
         *
         * This parameter is only valid if the `Engine` parameter is `redis`.
         */
        public var snapshotWindow: kotlin.String? = null
        /**
         * A list of tags to be added to this resource.
         */
        public var tags: List<Tag>? = null
        /**
         * A flag that enables in-transit encryption when set to true. You cannot modify the value of TransitEncryptionEnabled after the cluster is created. To enable in-transit encryption on a cluster you must set `TransitEncryptionEnabled` to true when you create a cluster.
         *
         *  Only available when creating a cache cluster in an Amazon VPC using Memcached version 1.6.12 or later.
         */
        public var transitEncryptionEnabled: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.CreateCacheClusterRequest) : this() {
            this.authToken = x.authToken
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.azMode = x.azMode
            this.cacheClusterId = x.cacheClusterId
            this.cacheNodeType = x.cacheNodeType
            this.cacheParameterGroupName = x.cacheParameterGroupName
            this.cacheSecurityGroupNames = x.cacheSecurityGroupNames
            this.cacheSubnetGroupName = x.cacheSubnetGroupName
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.ipDiscovery = x.ipDiscovery
            this.logDeliveryConfigurations = x.logDeliveryConfigurations
            this.networkType = x.networkType
            this.notificationTopicArn = x.notificationTopicArn
            this.numCacheNodes = x.numCacheNodes
            this.outpostMode = x.outpostMode
            this.port = x.port
            this.preferredAvailabilityZone = x.preferredAvailabilityZone
            this.preferredAvailabilityZones = x.preferredAvailabilityZones
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.preferredOutpostArn = x.preferredOutpostArn
            this.preferredOutpostArns = x.preferredOutpostArns
            this.replicationGroupId = x.replicationGroupId
            this.securityGroupIds = x.securityGroupIds
            this.snapshotArns = x.snapshotArns
            this.snapshotName = x.snapshotName
            this.snapshotRetentionLimit = x.snapshotRetentionLimit
            this.snapshotWindow = x.snapshotWindow
            this.tags = x.tags
            this.transitEncryptionEnabled = x.transitEncryptionEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.CreateCacheClusterRequest = CreateCacheClusterRequest(this)
    }
}
