// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model



public class CreateGlobalReplicationGroupRequest private constructor(builder: Builder) {
    /**
     * Provides details of the Global datastore
     */
    public val globalReplicationGroupDescription: kotlin.String? = builder.globalReplicationGroupDescription
    /**
     * The suffix name of a Global datastore. Amazon ElastiCache automatically applies a prefix to the Global datastore ID when it is created. Each Amazon Region has its own prefix. For instance, a Global datastore ID created in the US-West-1 region will begin with "dsdfu" along with the suffix name you provide. The suffix, combined with the auto-generated prefix, guarantees uniqueness of the Global datastore name across multiple regions.
     *
     * For a full list of Amazon Regions and their respective Global datastore iD prefixes, see [Using the Amazon CLI with Global datastores ](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Redis-Global-Datastores-CLI.html).
     */
    public val globalReplicationGroupIdSuffix: kotlin.String? = builder.globalReplicationGroupIdSuffix
    /**
     * The name of the primary cluster that accepts writes and will replicate updates to the secondary cluster.
     */
    public val primaryReplicationGroupId: kotlin.String? = builder.primaryReplicationGroupId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.CreateGlobalReplicationGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateGlobalReplicationGroupRequest(")
        append("globalReplicationGroupDescription=$globalReplicationGroupDescription,")
        append("globalReplicationGroupIdSuffix=$globalReplicationGroupIdSuffix,")
        append("primaryReplicationGroupId=$primaryReplicationGroupId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = globalReplicationGroupDescription?.hashCode() ?: 0
        result = 31 * result + (globalReplicationGroupIdSuffix?.hashCode() ?: 0)
        result = 31 * result + (primaryReplicationGroupId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateGlobalReplicationGroupRequest

        if (globalReplicationGroupDescription != other.globalReplicationGroupDescription) return false
        if (globalReplicationGroupIdSuffix != other.globalReplicationGroupIdSuffix) return false
        if (primaryReplicationGroupId != other.primaryReplicationGroupId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.CreateGlobalReplicationGroupRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Provides details of the Global datastore
         */
        public var globalReplicationGroupDescription: kotlin.String? = null
        /**
         * The suffix name of a Global datastore. Amazon ElastiCache automatically applies a prefix to the Global datastore ID when it is created. Each Amazon Region has its own prefix. For instance, a Global datastore ID created in the US-West-1 region will begin with "dsdfu" along with the suffix name you provide. The suffix, combined with the auto-generated prefix, guarantees uniqueness of the Global datastore name across multiple regions.
         *
         * For a full list of Amazon Regions and their respective Global datastore iD prefixes, see [Using the Amazon CLI with Global datastores ](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Redis-Global-Datastores-CLI.html).
         */
        public var globalReplicationGroupIdSuffix: kotlin.String? = null
        /**
         * The name of the primary cluster that accepts writes and will replicate updates to the secondary cluster.
         */
        public var primaryReplicationGroupId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.CreateGlobalReplicationGroupRequest) : this() {
            this.globalReplicationGroupDescription = x.globalReplicationGroupDescription
            this.globalReplicationGroupIdSuffix = x.globalReplicationGroupIdSuffix
            this.primaryReplicationGroupId = x.primaryReplicationGroupId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.CreateGlobalReplicationGroupRequest = CreateGlobalReplicationGroupRequest(this)
    }
}
