// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model



/**
 * Represents the input of a `DescribeCacheEngineVersions` operation.
 */
public class DescribeCacheEngineVersionsRequest private constructor(builder: Builder) {
    /**
     * The name of a specific cache parameter group family to return details for.
     *
     * Valid values are: `memcached1.4` | `memcached1.5` | `memcached1.6` | `redis2.6` | `redis2.8` | `redis3.2` | `redis4.0` | `redis5.0` | `redis6.x` | `redis6.2`
     *
     * Constraints:
     * + Must be 1 to 255 alphanumeric characters
     * + First character must be a letter
     * + Cannot end with a hyphen or contain two consecutive hyphens
     */
    public val cacheParameterGroupFamily: kotlin.String? = builder.cacheParameterGroupFamily
    /**
     * If `true`, specifies that only the default version of the specified engine or engine and major version combination is to be returned.
     */
    public val defaultOnly: kotlin.Boolean = builder.defaultOnly
    /**
     * The cache engine to return. Valid values: `memcached` | `redis`
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The cache engine version to return.
     *
     * Example: `1.4.14`
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a marker is included in the response so that the remaining results can be retrieved.
     *
     * Default: 100
     *
     * Constraints: minimum 20; maximum 100.
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.DescribeCacheEngineVersionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeCacheEngineVersionsRequest(")
        append("cacheParameterGroupFamily=$cacheParameterGroupFamily,")
        append("defaultOnly=$defaultOnly,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheParameterGroupFamily?.hashCode() ?: 0
        result = 31 * result + (defaultOnly.hashCode())
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeCacheEngineVersionsRequest

        if (cacheParameterGroupFamily != other.cacheParameterGroupFamily) return false
        if (defaultOnly != other.defaultOnly) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.DescribeCacheEngineVersionsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of a specific cache parameter group family to return details for.
         *
         * Valid values are: `memcached1.4` | `memcached1.5` | `memcached1.6` | `redis2.6` | `redis2.8` | `redis3.2` | `redis4.0` | `redis5.0` | `redis6.x` | `redis6.2`
         *
         * Constraints:
         * + Must be 1 to 255 alphanumeric characters
         * + First character must be a letter
         * + Cannot end with a hyphen or contain two consecutive hyphens
         */
        public var cacheParameterGroupFamily: kotlin.String? = null
        /**
         * If `true`, specifies that only the default version of the specified engine or engine and major version combination is to be returned.
         */
        public var defaultOnly: kotlin.Boolean = false
        /**
         * The cache engine to return. Valid values: `memcached` | `redis`
         */
        public var engine: kotlin.String? = null
        /**
         * The cache engine version to return.
         *
         * Example: `1.4.14`
         */
        public var engineVersion: kotlin.String? = null
        /**
         * An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a marker is included in the response so that the remaining results can be retrieved.
         *
         * Default: 100
         *
         * Constraints: minimum 20; maximum 100.
         */
        public var maxRecords: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.DescribeCacheEngineVersionsRequest) : this() {
            this.cacheParameterGroupFamily = x.cacheParameterGroupFamily
            this.defaultOnly = x.defaultOnly
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.marker = x.marker
            this.maxRecords = x.maxRecords
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.DescribeCacheEngineVersionsRequest = DescribeCacheEngineVersionsRequest(this)
    }
}
