// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model



/**
 * Represents the input of a `ModifyCacheCluster` operation.
 */
public class ModifyCacheClusterRequest private constructor(builder: Builder) {
    /**
     * If `true`, this parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible, regardless of the `PreferredMaintenanceWindow` setting for the cluster.
     *
     * If `false`, changes to the cluster are applied on the next maintenance reboot, or the next failure reboot, whichever occurs first.
     *
     * If you perform a `ModifyCacheCluster` before a pending modification is applied, the pending modification is replaced by the newer modification.
     *
     * Valid values: `true` | `false`
     *
     * Default: `false`
     */
    public val applyImmediately: kotlin.Boolean = builder.applyImmediately
    /**
     * Reserved parameter. The password used to access a password protected server. This parameter must be specified with the `auth-token-update` parameter. Password constraints:
     * + Must be only printable ASCII characters
     * + Must be at least 16 characters and no more than 128 characters in length
     * + Cannot contain any of the following characters: '/', '"', or '@', '%'
     *
     *  For more information, see AUTH password at [AUTH](http://redis.io/commands/AUTH).
     */
    public val authToken: kotlin.String? = builder.authToken
    /**
     * Specifies the strategy to use to update the AUTH token. This parameter must be specified with the `auth-token` parameter. Possible values:
     * + Rotate
     * + Set
     *
     *  For more information, see [Authenticating Users with Redis AUTH](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html)
     */
    public val authTokenUpdateStrategy: aws.sdk.kotlin.services.elasticache.model.AuthTokenUpdateStrategyType? = builder.authTokenUpdateStrategy
    /**
     * If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * Specifies whether the new nodes in this Memcached cluster are all created in a single Availability Zone or created across multiple Availability Zones.
     *
     * Valid values: `single-az` | `cross-az`.
     *
     * This option is only supported for Memcached clusters.
     *
     * You cannot specify `single-az` if the Memcached cluster already has cache nodes in different Availability Zones. If `cross-az` is specified, existing Memcached nodes remain in their current Availability Zone.
     *
     * Only newly created nodes are located in different Availability Zones.
     */
    public val azMode: aws.sdk.kotlin.services.elasticache.model.AzMode? = builder.azMode
    /**
     * The cluster identifier. This value is stored as a lowercase string.
     */
    public val cacheClusterId: kotlin.String? = builder.cacheClusterId
    /**
     * A list of cache node IDs to be removed. A node ID is a numeric identifier (0001, 0002, etc.). This parameter is only valid when `NumCacheNodes` is less than the existing number of cache nodes. The number of cache node IDs supplied in this parameter must match the difference between the existing number of cache nodes in the cluster or pending cache nodes, whichever is greater, and the value of `NumCacheNodes` in the request.
     *
     * For example: If you have 3 active cache nodes, 7 pending cache nodes, and the number of cache nodes in this `ModifyCacheCluster` call is 5, you must list 2 (7 - 5) cache node IDs to remove.
     */
    public val cacheNodeIdsToRemove: List<String>? = builder.cacheNodeIdsToRemove
    /**
     * A valid cache node type that you want to scale this cluster up to.
     */
    public val cacheNodeType: kotlin.String? = builder.cacheNodeType
    /**
     * The name of the cache parameter group to apply to this cluster. This change is asynchronously applied as soon as possible for parameters when the `ApplyImmediately` parameter is specified as `true` for this request.
     */
    public val cacheParameterGroupName: kotlin.String? = builder.cacheParameterGroupName
    /**
     * A list of cache security group names to authorize on this cluster. This change is asynchronously applied as soon as possible.
     *
     * You can use this parameter only with clusters that are created outside of an Amazon Virtual Private Cloud (Amazon VPC).
     *
     * Constraints: Must contain no more than 255 alphanumeric characters. Must not be "Default".
     */
    public val cacheSecurityGroupNames: List<String>? = builder.cacheSecurityGroupNames
    /**
     * The upgraded version of the cache engine to be run on the cache nodes.
     *
     * **Important:** You can upgrade to a newer engine version (see [Selecting a Cache Engine and Version](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement)), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster and create it anew with the earlier engine version.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The network type you choose when modifying a cluster, either `ipv4` | `ipv6`. IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the [Nitro system](https://aws.amazon.com/ec2/nitro/).
     */
    public val ipDiscovery: aws.sdk.kotlin.services.elasticache.model.IpDiscovery? = builder.ipDiscovery
    /**
     * Specifies the destination, format and type of the logs.
     */
    public val logDeliveryConfigurations: List<LogDeliveryConfigurationRequest>? = builder.logDeliveryConfigurations
    /**
     * This option is only supported on Memcached clusters.
     *
     * The list of Availability Zones where the new Memcached cache nodes are created.
     *
     * This parameter is only valid when `NumCacheNodes` in the request is greater than the sum of the number of active cache nodes and the number of cache nodes pending creation (which may be zero). The number of Availability Zones supplied in this list must match the cache nodes being added in this request.
     *
     * Scenarios:
     * + **Scenario 1:** You have 3 active nodes and wish to add 2 nodes. Specify `NumCacheNodes=5` (3 + 2) and optionally specify two Availability Zones for the two new nodes.
     * + **Scenario 2:** You have 3 active nodes and 2 nodes pending creation (from the scenario 1 call) and want to add 1 more node. Specify `NumCacheNodes=6` ((3 + 2) + 1) and optionally specify an Availability Zone for the new node.
     * + **Scenario 3:** You want to cancel all pending operations. Specify `NumCacheNodes=3` to cancel all pending operations.
     *
     * The Availability Zone placement of nodes pending creation cannot be modified. If you wish to cancel any nodes pending creation, add 0 nodes by setting `NumCacheNodes` to the number of current nodes.
     *
     * If `cross-az` is specified, existing Memcached nodes remain in their current Availability Zone. Only newly created nodes can be located in different Availability Zones. For guidance on how to move existing Memcached nodes to different Availability Zones, see the **Availability Zone Considerations** section of [Cache Node Considerations for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheNodes.SupportedTypes.html).
     *
     * **Impact of new add/remove requests upon pending requests**
     * + Scenario-1
     *    + Pending Action: Delete
     *    + New Request: Delete
     *    + Result: The new delete, pending or immediate, replaces the pending delete.
     * + Scenario-2
     *    + Pending Action: Delete
     *    + New Request: Create
     *    + Result: The new create, pending or immediate, replaces the pending delete.
     * + Scenario-3
     *    + Pending Action: Create
     *    + New Request: Delete
     *    + Result: The new delete, pending or immediate, replaces the pending create.
     * + Scenario-4
     *    + Pending Action: Create
     *    + New Request: Create
     *    + Result: The new create is added to the pending create.**Important:** If the new create request is **Apply Immediately - Yes**, all creates are performed immediately. If the new create request is **Apply Immediately - No**, all creates are pending.
     */
    public val newAvailabilityZones: List<String>? = builder.newAvailabilityZones
    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.
     *
     * The Amazon SNS topic owner must be same as the cluster owner.
     */
    public val notificationTopicArn: kotlin.String? = builder.notificationTopicArn
    /**
     * The status of the Amazon SNS notification topic. Notifications are sent only if the status is `active`.
     *
     * Valid values: `active` | `inactive`
     */
    public val notificationTopicStatus: kotlin.String? = builder.notificationTopicStatus
    /**
     * The number of cache nodes that the cluster should have. If the value for `NumCacheNodes` is greater than the sum of the number of current cache nodes and the number of cache nodes pending creation (which may be zero), more nodes are added. If the value is less than the number of existing cache nodes, nodes are removed. If the value is equal to the number of current cache nodes, any pending add or remove requests are canceled.
     *
     * If you are removing cache nodes, you must use the `CacheNodeIdsToRemove` parameter to provide the IDs of the specific cache nodes to remove.
     *
     * For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.
     *
     * Adding or removing Memcached cache nodes can be applied immediately or as a pending operation (see `ApplyImmediately`).
     *
     * A pending operation to modify the number of cache nodes in a cluster during its maintenance window, whether by adding or removing nodes in accordance with the scale out architecture, is not queued. The customer's latest request to add or remove nodes to the cluster overrides any previous pending operations to modify the number of cache nodes in the cluster. For example, a request to remove 2 nodes would override a previous pending operation to remove 3 nodes. Similarly, a request to add 2 nodes would override a previous pending operation to remove 3 nodes and vice versa. As Memcached cache nodes may now be provisioned in different Availability Zones with flexible cache node placement, a request to add nodes does not automatically override a previous pending operation to add nodes. The customer can modify the previous pending operation to add more nodes or explicitly cancel the pending request and retry the new request. To cancel pending operations to modify the number of cache nodes in a cluster, use the `ModifyCacheCluster` request and set `NumCacheNodes` equal to the number of cache nodes currently in the cluster.
     */
    public val numCacheNodes: kotlin.Int? = builder.numCacheNodes
    /**
     * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     *
     * Valid values for `ddd` are:
     * + `sun`
     * + `mon`
     * + `tue`
     * + `wed`
     * + `thu`
     * + `fri`
     * + `sat`
     *
     * Example: `sun:23:00-mon:01:30`
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * Specifies the VPC Security Groups associated with the cluster.
     *
     * This parameter can be used only with clusters that are created in an Amazon Virtual Private Cloud (Amazon VPC).
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For example, if you set `SnapshotRetentionLimit` to 5, a snapshot that was taken today is retained for 5 days before being deleted.
     *
     * If the value of `SnapshotRetentionLimit` is set to zero (0), backups are turned off.
     */
    public val snapshotRetentionLimit: kotlin.Int? = builder.snapshotRetentionLimit
    /**
     * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your cluster.
     */
    public val snapshotWindow: kotlin.String? = builder.snapshotWindow

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.ModifyCacheClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyCacheClusterRequest(")
        append("applyImmediately=$applyImmediately,")
        append("authToken=$authToken,")
        append("authTokenUpdateStrategy=$authTokenUpdateStrategy,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("azMode=$azMode,")
        append("cacheClusterId=$cacheClusterId,")
        append("cacheNodeIdsToRemove=$cacheNodeIdsToRemove,")
        append("cacheNodeType=$cacheNodeType,")
        append("cacheParameterGroupName=$cacheParameterGroupName,")
        append("cacheSecurityGroupNames=$cacheSecurityGroupNames,")
        append("engineVersion=$engineVersion,")
        append("ipDiscovery=$ipDiscovery,")
        append("logDeliveryConfigurations=$logDeliveryConfigurations,")
        append("newAvailabilityZones=$newAvailabilityZones,")
        append("notificationTopicArn=$notificationTopicArn,")
        append("notificationTopicStatus=$notificationTopicStatus,")
        append("numCacheNodes=$numCacheNodes,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("securityGroupIds=$securityGroupIds,")
        append("snapshotRetentionLimit=$snapshotRetentionLimit,")
        append("snapshotWindow=$snapshotWindow")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applyImmediately.hashCode()
        result = 31 * result + (authToken?.hashCode() ?: 0)
        result = 31 * result + (authTokenUpdateStrategy?.hashCode() ?: 0)
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (azMode?.hashCode() ?: 0)
        result = 31 * result + (cacheClusterId?.hashCode() ?: 0)
        result = 31 * result + (cacheNodeIdsToRemove?.hashCode() ?: 0)
        result = 31 * result + (cacheNodeType?.hashCode() ?: 0)
        result = 31 * result + (cacheParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (cacheSecurityGroupNames?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (ipDiscovery?.hashCode() ?: 0)
        result = 31 * result + (logDeliveryConfigurations?.hashCode() ?: 0)
        result = 31 * result + (newAvailabilityZones?.hashCode() ?: 0)
        result = 31 * result + (notificationTopicArn?.hashCode() ?: 0)
        result = 31 * result + (notificationTopicStatus?.hashCode() ?: 0)
        result = 31 * result + (numCacheNodes ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (snapshotRetentionLimit ?: 0)
        result = 31 * result + (snapshotWindow?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyCacheClusterRequest

        if (applyImmediately != other.applyImmediately) return false
        if (authToken != other.authToken) return false
        if (authTokenUpdateStrategy != other.authTokenUpdateStrategy) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (azMode != other.azMode) return false
        if (cacheClusterId != other.cacheClusterId) return false
        if (cacheNodeIdsToRemove != other.cacheNodeIdsToRemove) return false
        if (cacheNodeType != other.cacheNodeType) return false
        if (cacheParameterGroupName != other.cacheParameterGroupName) return false
        if (cacheSecurityGroupNames != other.cacheSecurityGroupNames) return false
        if (engineVersion != other.engineVersion) return false
        if (ipDiscovery != other.ipDiscovery) return false
        if (logDeliveryConfigurations != other.logDeliveryConfigurations) return false
        if (newAvailabilityZones != other.newAvailabilityZones) return false
        if (notificationTopicArn != other.notificationTopicArn) return false
        if (notificationTopicStatus != other.notificationTopicStatus) return false
        if (numCacheNodes != other.numCacheNodes) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (snapshotRetentionLimit != other.snapshotRetentionLimit) return false
        if (snapshotWindow != other.snapshotWindow) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.ModifyCacheClusterRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If `true`, this parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible, regardless of the `PreferredMaintenanceWindow` setting for the cluster.
         *
         * If `false`, changes to the cluster are applied on the next maintenance reboot, or the next failure reboot, whichever occurs first.
         *
         * If you perform a `ModifyCacheCluster` before a pending modification is applied, the pending modification is replaced by the newer modification.
         *
         * Valid values: `true` | `false`
         *
         * Default: `false`
         */
        public var applyImmediately: kotlin.Boolean = false
        /**
         * Reserved parameter. The password used to access a password protected server. This parameter must be specified with the `auth-token-update` parameter. Password constraints:
         * + Must be only printable ASCII characters
         * + Must be at least 16 characters and no more than 128 characters in length
         * + Cannot contain any of the following characters: '/', '"', or '@', '%'
         *
         *  For more information, see AUTH password at [AUTH](http://redis.io/commands/AUTH).
         */
        public var authToken: kotlin.String? = null
        /**
         * Specifies the strategy to use to update the AUTH token. This parameter must be specified with the `auth-token` parameter. Possible values:
         * + Rotate
         * + Set
         *
         *  For more information, see [Authenticating Users with Redis AUTH](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html)
         */
        public var authTokenUpdateStrategy: aws.sdk.kotlin.services.elasticache.model.AuthTokenUpdateStrategyType? = null
        /**
         * If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * Specifies whether the new nodes in this Memcached cluster are all created in a single Availability Zone or created across multiple Availability Zones.
         *
         * Valid values: `single-az` | `cross-az`.
         *
         * This option is only supported for Memcached clusters.
         *
         * You cannot specify `single-az` if the Memcached cluster already has cache nodes in different Availability Zones. If `cross-az` is specified, existing Memcached nodes remain in their current Availability Zone.
         *
         * Only newly created nodes are located in different Availability Zones.
         */
        public var azMode: aws.sdk.kotlin.services.elasticache.model.AzMode? = null
        /**
         * The cluster identifier. This value is stored as a lowercase string.
         */
        public var cacheClusterId: kotlin.String? = null
        /**
         * A list of cache node IDs to be removed. A node ID is a numeric identifier (0001, 0002, etc.). This parameter is only valid when `NumCacheNodes` is less than the existing number of cache nodes. The number of cache node IDs supplied in this parameter must match the difference between the existing number of cache nodes in the cluster or pending cache nodes, whichever is greater, and the value of `NumCacheNodes` in the request.
         *
         * For example: If you have 3 active cache nodes, 7 pending cache nodes, and the number of cache nodes in this `ModifyCacheCluster` call is 5, you must list 2 (7 - 5) cache node IDs to remove.
         */
        public var cacheNodeIdsToRemove: List<String>? = null
        /**
         * A valid cache node type that you want to scale this cluster up to.
         */
        public var cacheNodeType: kotlin.String? = null
        /**
         * The name of the cache parameter group to apply to this cluster. This change is asynchronously applied as soon as possible for parameters when the `ApplyImmediately` parameter is specified as `true` for this request.
         */
        public var cacheParameterGroupName: kotlin.String? = null
        /**
         * A list of cache security group names to authorize on this cluster. This change is asynchronously applied as soon as possible.
         *
         * You can use this parameter only with clusters that are created outside of an Amazon Virtual Private Cloud (Amazon VPC).
         *
         * Constraints: Must contain no more than 255 alphanumeric characters. Must not be "Default".
         */
        public var cacheSecurityGroupNames: List<String>? = null
        /**
         * The upgraded version of the cache engine to be run on the cache nodes.
         *
         * **Important:** You can upgrade to a newer engine version (see [Selecting a Cache Engine and Version](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement)), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster and create it anew with the earlier engine version.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The network type you choose when modifying a cluster, either `ipv4` | `ipv6`. IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the [Nitro system](https://aws.amazon.com/ec2/nitro/).
         */
        public var ipDiscovery: aws.sdk.kotlin.services.elasticache.model.IpDiscovery? = null
        /**
         * Specifies the destination, format and type of the logs.
         */
        public var logDeliveryConfigurations: List<LogDeliveryConfigurationRequest>? = null
        /**
         * This option is only supported on Memcached clusters.
         *
         * The list of Availability Zones where the new Memcached cache nodes are created.
         *
         * This parameter is only valid when `NumCacheNodes` in the request is greater than the sum of the number of active cache nodes and the number of cache nodes pending creation (which may be zero). The number of Availability Zones supplied in this list must match the cache nodes being added in this request.
         *
         * Scenarios:
         * + **Scenario 1:** You have 3 active nodes and wish to add 2 nodes. Specify `NumCacheNodes=5` (3 + 2) and optionally specify two Availability Zones for the two new nodes.
         * + **Scenario 2:** You have 3 active nodes and 2 nodes pending creation (from the scenario 1 call) and want to add 1 more node. Specify `NumCacheNodes=6` ((3 + 2) + 1) and optionally specify an Availability Zone for the new node.
         * + **Scenario 3:** You want to cancel all pending operations. Specify `NumCacheNodes=3` to cancel all pending operations.
         *
         * The Availability Zone placement of nodes pending creation cannot be modified. If you wish to cancel any nodes pending creation, add 0 nodes by setting `NumCacheNodes` to the number of current nodes.
         *
         * If `cross-az` is specified, existing Memcached nodes remain in their current Availability Zone. Only newly created nodes can be located in different Availability Zones. For guidance on how to move existing Memcached nodes to different Availability Zones, see the **Availability Zone Considerations** section of [Cache Node Considerations for Memcached](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheNodes.SupportedTypes.html).
         *
         * **Impact of new add/remove requests upon pending requests**
         * + Scenario-1
         *    + Pending Action: Delete
         *    + New Request: Delete
         *    + Result: The new delete, pending or immediate, replaces the pending delete.
         * + Scenario-2
         *    + Pending Action: Delete
         *    + New Request: Create
         *    + Result: The new create, pending or immediate, replaces the pending delete.
         * + Scenario-3
         *    + Pending Action: Create
         *    + New Request: Delete
         *    + Result: The new delete, pending or immediate, replaces the pending create.
         * + Scenario-4
         *    + Pending Action: Create
         *    + New Request: Create
         *    + Result: The new create is added to the pending create.**Important:** If the new create request is **Apply Immediately - Yes**, all creates are performed immediately. If the new create request is **Apply Immediately - No**, all creates are pending.
         */
        public var newAvailabilityZones: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.
         *
         * The Amazon SNS topic owner must be same as the cluster owner.
         */
        public var notificationTopicArn: kotlin.String? = null
        /**
         * The status of the Amazon SNS notification topic. Notifications are sent only if the status is `active`.
         *
         * Valid values: `active` | `inactive`
         */
        public var notificationTopicStatus: kotlin.String? = null
        /**
         * The number of cache nodes that the cluster should have. If the value for `NumCacheNodes` is greater than the sum of the number of current cache nodes and the number of cache nodes pending creation (which may be zero), more nodes are added. If the value is less than the number of existing cache nodes, nodes are removed. If the value is equal to the number of current cache nodes, any pending add or remove requests are canceled.
         *
         * If you are removing cache nodes, you must use the `CacheNodeIdsToRemove` parameter to provide the IDs of the specific cache nodes to remove.
         *
         * For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.
         *
         * Adding or removing Memcached cache nodes can be applied immediately or as a pending operation (see `ApplyImmediately`).
         *
         * A pending operation to modify the number of cache nodes in a cluster during its maintenance window, whether by adding or removing nodes in accordance with the scale out architecture, is not queued. The customer's latest request to add or remove nodes to the cluster overrides any previous pending operations to modify the number of cache nodes in the cluster. For example, a request to remove 2 nodes would override a previous pending operation to remove 3 nodes. Similarly, a request to add 2 nodes would override a previous pending operation to remove 3 nodes and vice versa. As Memcached cache nodes may now be provisioned in different Availability Zones with flexible cache node placement, a request to add nodes does not automatically override a previous pending operation to add nodes. The customer can modify the previous pending operation to add more nodes or explicitly cancel the pending request and retry the new request. To cancel pending operations to modify the number of cache nodes in a cluster, use the `ModifyCacheCluster` request and set `NumCacheNodes` equal to the number of cache nodes currently in the cluster.
         */
        public var numCacheNodes: kotlin.Int? = null
        /**
         * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
         *
         * Valid values for `ddd` are:
         * + `sun`
         * + `mon`
         * + `tue`
         * + `wed`
         * + `thu`
         * + `fri`
         * + `sat`
         *
         * Example: `sun:23:00-mon:01:30`
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * Specifies the VPC Security Groups associated with the cluster.
         *
         * This parameter can be used only with clusters that are created in an Amazon Virtual Private Cloud (Amazon VPC).
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For example, if you set `SnapshotRetentionLimit` to 5, a snapshot that was taken today is retained for 5 days before being deleted.
         *
         * If the value of `SnapshotRetentionLimit` is set to zero (0), backups are turned off.
         */
        public var snapshotRetentionLimit: kotlin.Int? = null
        /**
         * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your cluster.
         */
        public var snapshotWindow: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.ModifyCacheClusterRequest) : this() {
            this.applyImmediately = x.applyImmediately
            this.authToken = x.authToken
            this.authTokenUpdateStrategy = x.authTokenUpdateStrategy
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.azMode = x.azMode
            this.cacheClusterId = x.cacheClusterId
            this.cacheNodeIdsToRemove = x.cacheNodeIdsToRemove
            this.cacheNodeType = x.cacheNodeType
            this.cacheParameterGroupName = x.cacheParameterGroupName
            this.cacheSecurityGroupNames = x.cacheSecurityGroupNames
            this.engineVersion = x.engineVersion
            this.ipDiscovery = x.ipDiscovery
            this.logDeliveryConfigurations = x.logDeliveryConfigurations
            this.newAvailabilityZones = x.newAvailabilityZones
            this.notificationTopicArn = x.notificationTopicArn
            this.notificationTopicStatus = x.notificationTopicStatus
            this.numCacheNodes = x.numCacheNodes
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.securityGroupIds = x.securityGroupIds
            this.snapshotRetentionLimit = x.snapshotRetentionLimit
            this.snapshotWindow = x.snapshotWindow
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.ModifyCacheClusterRequest = ModifyCacheClusterRequest(this)
    }
}
