// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.elasticache.model.BatchApplyUpdateActionResponse
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.sdk.kotlin.services.elasticache.model.ProcessedUpdateAction
import aws.sdk.kotlin.services.elasticache.model.UnprocessedUpdateAction
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class BatchApplyUpdateActionOperationDeserializer: HttpDeserialize<BatchApplyUpdateActionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchApplyUpdateActionResponse {
        if (!response.status.isSuccess()) {
            throwBatchApplyUpdateActionError(context, response)
        }
        val builder = BatchApplyUpdateActionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchApplyUpdateActionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchApplyUpdateActionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUpdateNotFoundFault" -> ServiceUpdateNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchApplyUpdateActionOperationBody(builder: BatchApplyUpdateActionResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("BatchApplyUpdateActionResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("BatchApplyUpdateActionResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap BatchApplyUpdateAction response")
    }
    // end unwrap response wrapper

    val PROCESSEDUPDATEACTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("ProcessedUpdateActions"), XmlCollectionName("ProcessedUpdateAction"))
    val UNPROCESSEDUPDATEACTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("UnprocessedUpdateActions"), XmlCollectionName("UnprocessedUpdateAction"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticache.amazonaws.com/doc/2015-02-02/"))
        trait(XmlSerialName("BatchApplyUpdateActionResult"))
        field(PROCESSEDUPDATEACTIONS_DESCRIPTOR)
        field(UNPROCESSEDUPDATEACTIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PROCESSEDUPDATEACTIONS_DESCRIPTOR.index -> builder.processedUpdateActions =
                    deserializer.deserializeList(PROCESSEDUPDATEACTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<ProcessedUpdateAction>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProcessedUpdateActionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                UNPROCESSEDUPDATEACTIONS_DESCRIPTOR.index -> builder.unprocessedUpdateActions =
                    deserializer.deserializeList(UNPROCESSEDUPDATEACTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<UnprocessedUpdateAction>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUnprocessedUpdateActionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
