// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.elasticache.model.CacheEngineVersion
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheEngineVersionsResponse
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class DescribeCacheEngineVersionsOperationDeserializer: HttpDeserialize<DescribeCacheEngineVersionsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeCacheEngineVersionsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeCacheEngineVersionsError(context, response)
        }
        val builder = DescribeCacheEngineVersionsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeCacheEngineVersionsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeCacheEngineVersionsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeCacheEngineVersionsOperationBody(builder: DescribeCacheEngineVersionsResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribeCacheEngineVersionsResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribeCacheEngineVersionsResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribeCacheEngineVersions response")
    }
    // end unwrap response wrapper

    val CACHEENGINEVERSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("CacheEngineVersions"), XmlCollectionName("CacheEngineVersion"))
    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Marker"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticache.amazonaws.com/doc/2015-02-02/"))
        trait(XmlSerialName("DescribeCacheEngineVersionsResult"))
        field(CACHEENGINEVERSIONS_DESCRIPTOR)
        field(MARKER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CACHEENGINEVERSIONS_DESCRIPTOR.index -> builder.cacheEngineVersions =
                    deserializer.deserializeList(CACHEENGINEVERSIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<CacheEngineVersion>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCacheEngineVersionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MARKER_DESCRIPTOR.index -> builder.marker = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
