// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.sdk.kotlin.services.elasticache.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.elasticache.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class ListTagsForResourceOperationDeserializer: HttpDeserialize<ListTagsForResourceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListTagsForResourceResponse {
        if (!response.status.isSuccess()) {
            throwListTagsForResourceError(context, response)
        }
        val builder = ListTagsForResourceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListTagsForResourceOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListTagsForResourceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CacheClusterNotFound" -> CacheClusterNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "CacheParameterGroupNotFound" -> CacheParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "CacheSecurityGroupNotFound" -> CacheSecurityGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "CacheSubnetGroupNotFoundFault" -> CacheSubnetGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidARN" -> InvalidArnFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidReplicationGroupState" -> InvalidReplicationGroupStateFaultDeserializer().deserialize(context, wrappedResponse)
        "ReplicationGroupNotFoundFault" -> ReplicationGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "ReservedCacheNodeNotFound" -> ReservedCacheNodeNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "SnapshotNotFoundFault" -> SnapshotNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "UserGroupNotFound" -> UserGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "UserNotFound" -> UserNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListTagsForResourceOperationBody(builder: ListTagsForResourceResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ListTagsForResourceResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("ListTagsForResourceResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap ListTagsForResource response")
    }
    // end unwrap response wrapper

    val TAGLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("TagList"), XmlCollectionName("Tag"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticache.amazonaws.com/doc/2015-02-02/"))
        trait(XmlSerialName("ListTagsForResourceResult"))
        field(TAGLIST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                TAGLIST_DESCRIPTOR.index -> builder.tagList =
                    deserializer.deserializeList(TAGLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
