// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.sdk.kotlin.services.elasticache.model.ModifyUserGroupResponse
import aws.sdk.kotlin.services.elasticache.model.UserGroupPendingChanges
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class ModifyUserGroupOperationDeserializer: HttpDeserialize<ModifyUserGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ModifyUserGroupResponse {
        if (!response.status.isSuccess()) {
            throwModifyUserGroupError(context, response)
        }
        val builder = ModifyUserGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyUserGroupOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwModifyUserGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DefaultUserRequired" -> DefaultUserRequiredDeserializer().deserialize(context, wrappedResponse)
        "DuplicateUserName" -> DuplicateUserNameFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterCombination" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidUserGroupState" -> InvalidUserGroupStateFaultDeserializer().deserialize(context, wrappedResponse)
        "ServiceLinkedRoleNotFoundFault" -> ServiceLinkedRoleNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "UserGroupNotFound" -> UserGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "UserNotFound" -> UserNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyUserGroupOperationBody(builder: ModifyUserGroupResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ModifyUserGroupResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("ModifyUserGroupResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap ModifyUserGroup response")
    }
    // end unwrap response wrapper

    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ARN"))
    val ENGINE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Engine"))
    val MINIMUMENGINEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("MinimumEngineVersion"))
    val PENDINGCHANGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("PendingChanges"))
    val REPLICATIONGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("ReplicationGroups"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Status"))
    val USERGROUPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("UserGroupId"))
    val USERIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("UserIds"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticache.amazonaws.com/doc/2015-02-02/"))
        trait(XmlSerialName("ModifyUserGroupResult"))
        field(ARN_DESCRIPTOR)
        field(ENGINE_DESCRIPTOR)
        field(MINIMUMENGINEVERSION_DESCRIPTOR)
        field(PENDINGCHANGES_DESCRIPTOR)
        field(REPLICATIONGROUPS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(USERGROUPID_DESCRIPTOR)
        field(USERIDS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                ENGINE_DESCRIPTOR.index -> builder.engine = deserializeString()
                MINIMUMENGINEVERSION_DESCRIPTOR.index -> builder.minimumEngineVersion = deserializeString()
                PENDINGCHANGES_DESCRIPTOR.index -> builder.pendingChanges = deserializeUserGroupPendingChangesDocument(deserializer)
                REPLICATIONGROUPS_DESCRIPTOR.index -> builder.replicationGroups =
                    deserializer.deserializeList(REPLICATIONGROUPS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString()
                USERGROUPID_DESCRIPTOR.index -> builder.userGroupId = deserializeString()
                USERIDS_DESCRIPTOR.index -> builder.userIds =
                    deserializer.deserializeList(USERIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
