// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.elasticache.model.Authentication
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.sdk.kotlin.services.elasticache.model.ModifyUserResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class ModifyUserOperationDeserializer: HttpDeserialize<ModifyUserResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ModifyUserResponse {
        if (!response.status.isSuccess()) {
            throwModifyUserError(context, response)
        }
        val builder = ModifyUserResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyUserOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwModifyUserError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterCombination" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidUserState" -> InvalidUserStateFaultDeserializer().deserialize(context, wrappedResponse)
        "ServiceLinkedRoleNotFoundFault" -> ServiceLinkedRoleNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "UserNotFound" -> UserNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyUserOperationBody(builder: ModifyUserResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ModifyUserResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("ModifyUserResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap ModifyUser response")
    }
    // end unwrap response wrapper

    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ARN"))
    val ACCESSSTRING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("AccessString"))
    val AUTHENTICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Authentication"))
    val ENGINE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Engine"))
    val MINIMUMENGINEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("MinimumEngineVersion"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Status"))
    val USERGROUPIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("UserGroupIds"))
    val USERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("UserId"))
    val USERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("UserName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticache.amazonaws.com/doc/2015-02-02/"))
        trait(XmlSerialName("ModifyUserResult"))
        field(ARN_DESCRIPTOR)
        field(ACCESSSTRING_DESCRIPTOR)
        field(AUTHENTICATION_DESCRIPTOR)
        field(ENGINE_DESCRIPTOR)
        field(MINIMUMENGINEVERSION_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(USERGROUPIDS_DESCRIPTOR)
        field(USERID_DESCRIPTOR)
        field(USERNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                ACCESSSTRING_DESCRIPTOR.index -> builder.accessString = deserializeString()
                AUTHENTICATION_DESCRIPTOR.index -> builder.authentication = deserializeAuthenticationDocument(deserializer)
                ENGINE_DESCRIPTOR.index -> builder.engine = deserializeString()
                MINIMUMENGINEVERSION_DESCRIPTOR.index -> builder.minimumEngineVersion = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString()
                USERGROUPIDS_DESCRIPTOR.index -> builder.userGroupIds =
                    deserializer.deserializeList(USERGROUPIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                USERID_DESCRIPTOR.index -> builder.userId = deserializeString()
                USERNAME_DESCRIPTOR.index -> builder.userName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
